"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createNodeStatusMachine = exports.nodeStatusMachineStateToNodeStatus = void 0;
const core_1 = require("@zwave-js/core");
const xstate_1 = require("xstate");
const Types_1 = require("./Types");
/* eslint-enable @typescript-eslint/ban-types */
const statusDict = {
    unknown: Types_1.NodeStatus.Unknown,
    dead: Types_1.NodeStatus.Dead,
    alive: Types_1.NodeStatus.Alive,
    asleep: Types_1.NodeStatus.Asleep,
    awake: Types_1.NodeStatus.Awake,
};
function nodeStatusMachineStateToNodeStatus(state) {
    var _a;
    return (_a = statusDict[state]) !== null && _a !== void 0 ? _a : Types_1.NodeStatus.Unknown;
}
exports.nodeStatusMachineStateToNodeStatus = nodeStatusMachineStateToNodeStatus;
function createNodeStatusMachine(node) {
    return xstate_1.Machine({
        id: "nodeStatus",
        initial: "unknown",
        states: {
            unknown: {
                on: {
                    DEAD: {
                        target: "dead",
                        cond: "notSupportsWakeup",
                    },
                    ALIVE: {
                        target: "alive",
                        cond: "notSupportsWakeup",
                    },
                    ASLEEP: {
                        target: "asleep",
                        cond: "supportsWakeup",
                    },
                    AWAKE: {
                        target: "awake",
                        cond: "supportsWakeup",
                    },
                },
            },
            dead: {
                on: {
                    ALIVE: "alive",
                },
            },
            alive: {
                on: {
                    DEAD: "dead",
                    // GH#1054 we must have a way to send a node to sleep even if
                    // it was previously detected as a non-sleeping device
                    ASLEEP: {
                        target: "asleep",
                        cond: "supportsWakeup",
                    },
                },
            },
            asleep: {
                on: {
                    AWAKE: "awake",
                },
            },
            awake: {
                on: {
                    ASLEEP: "asleep",
                },
            },
        },
    }, {
        services: {
        // send: (ctx) => sendData(ctx.data),
        },
        guards: {
            supportsWakeup: () => node.supportsCC(core_1.CommandClasses["Wake Up"]),
            notSupportsWakeup: () => !node.supportsCC(core_1.CommandClasses["Wake Up"]),
        },
        delays: {},
    });
}
exports.createNodeStatusMachine = createNodeStatusMachine;

//# sourceMappingURL=NodeStatusMachine.js.map
