"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.RequestNodeInfoRequest = exports.RequestNodeInfoResponse = void 0;
const ApplicationUpdateRequest_1 = require("../controller/ApplicationUpdateRequest");
const Constants_1 = require("../message/Constants");
const Message_1 = require("../message/Message");
function testCallbackForRequestNodeInfoRequest(sent, received) {
    return ((received instanceof ApplicationUpdateRequest_1.ApplicationUpdateRequestNodeInfoReceived &&
        received.nodeId === sent.nodeId) ||
        received instanceof ApplicationUpdateRequest_1.ApplicationUpdateRequestNodeInfoRequestFailed);
}
let RequestNodeInfoResponse = class RequestNodeInfoResponse extends Message_1.Message {
    constructor(driver, options) {
        super(driver, options);
        this._wasSent = this.payload[0] !== 0;
        if (!this._wasSent)
            this._errorCode = this.payload[0];
    }
    isOK() {
        return this._wasSent;
    }
    get wasSent() {
        return this._wasSent;
    }
    get errorCode() {
        return this._errorCode;
    }
    toJSON() {
        return super.toJSONInherited({
            wasSent: this.wasSent,
            errorCode: this.errorCode,
        });
    }
};
RequestNodeInfoResponse = __decorate([
    Message_1.messageTypes(Constants_1.MessageType.Response, Constants_1.FunctionType.RequestNodeInfo)
], RequestNodeInfoResponse);
exports.RequestNodeInfoResponse = RequestNodeInfoResponse;
let RequestNodeInfoRequest = class RequestNodeInfoRequest extends Message_1.Message {
    constructor(driver, options) {
        super(driver, options);
        this.nodeId = options.nodeId;
    }
    needsCallbackId() {
        // Not sure why it is this way, but this message contains no callback id
        return false;
    }
    serialize() {
        this.payload = Buffer.from([this.nodeId]);
        return super.serialize();
    }
    toJSON() {
        return super.toJSONInherited({
            nodeId: this.nodeId,
        });
    }
};
RequestNodeInfoRequest = __decorate([
    Message_1.messageTypes(Constants_1.MessageType.Request, Constants_1.FunctionType.RequestNodeInfo),
    Message_1.expectedResponse(RequestNodeInfoResponse),
    Message_1.expectedCallback(testCallbackForRequestNodeInfoRequest),
    Message_1.priority(Constants_1.MessagePriority.NodeQuery)
], RequestNodeInfoRequest);
exports.RequestNodeInfoRequest = RequestNodeInfoRequest;

//# sourceMappingURL=RequestNodeInfoMessages.js.map
