import { JSONObject, ReadonlyObjectKeyMap } from "@zwave-js/shared";
import { CompatConfig } from "./CompatConfig";
export interface FirmwareVersionRange {
    min: string;
    max: string;
}
export interface DeviceConfigIndexEntry {
    manufacturerId: string;
    productType: string;
    productId: string;
    firmwareVersion: FirmwareVersionRange | false;
    filename: string;
}
export declare type ParamInfoMap = ReadonlyObjectKeyMap<{
    parameter: number;
    valueBitMask?: number;
}, ParamInformation>;
export declare const devicesDir: string;
export declare const indexPath: string;
export declare type DeviceConfigIndex = DeviceConfigIndexEntry[];
export declare class DeviceConfig {
    constructor(filename: string, fileContents: string);
    readonly manufacturer: string;
    readonly manufacturerId: number;
    readonly label: string;
    readonly description: string;
    readonly devices: readonly {
        productType: string;
        productId: string;
    }[];
    readonly firmwareVersion: FirmwareVersionRange | false;
    readonly associations?: ReadonlyMap<number, AssociationConfig>;
    readonly paramInformation?: ParamInfoMap;
    /**
     * Contains manufacturer-specific support information for the
     * ManufacturerProprietary CC
     */
    readonly proprietary?: Record<string, unknown>;
    /** Contains compatibility options */
    readonly compat?: CompatConfig;
}
export declare class AssociationConfig {
    constructor(filename: string, groupId: number, definition: JSONObject);
    readonly groupId: number;
    readonly label: string;
    readonly description?: string;
    readonly maxNodes: number;
    /**
     * Whether this association group is used to report updates to the controller.
     * While Z-Wave+ defines a single lifeline, older devices may have multiple lifeline associations.
     */
    readonly isLifeline: boolean;
    /** Some devices support multi channel associations but require some of its groups to use node id associations */
    readonly noEndpoint: boolean;
}
export declare class ParamInformation {
    constructor(filename: string, parameterNumber: number, valueBitMask: number | undefined, definition: JSONObject);
    readonly parameterNumber: number;
    readonly valueBitMask?: number;
    readonly label: string;
    readonly description?: string;
    readonly valueSize: number;
    readonly minValue: number;
    readonly maxValue: number;
    readonly unsigned?: boolean;
    readonly defaultValue: number;
    readonly readOnly: boolean;
    readonly writeOnly: boolean;
    readonly allowManualEntry: boolean;
    readonly options: readonly ConfigOption[];
}
export interface ConfigOption {
    value: number;
    label: string;
}
//# sourceMappingURL=Devices.d.ts.map