import type { Duration } from "./Duration";
/** Returns an array with the values of a numeric enum */
export declare function getNumericEnumValues<T extends Record<string, any>>(enumeration: T): readonly number[];
/** Takes an enumeration and an array of values of this enumeration and returns a states record to be used as metadata */
export declare function enumValuesToMetadataStates<T extends Record<string, any>>(enumeration: T, values?: readonly number[]): Record<number, string>;
export declare type ValueType = "number" | "boolean" | "string" | "number[]" | "boolean[]" | "string[]" | "duration" | "color" | "any";
export interface ValueMetadataAny {
    /** The type of the value */
    type: ValueType;
    /** The default value */
    default?: any;
    /** Whether the value can be read. By default all values are assumed readable */
    readable: boolean;
    /** Whether the value can be written. By default all values are assumed writeable */
    writeable: boolean;
    /** A description of the value */
    description?: string;
    /** A human-readable name for the property */
    label?: string;
    /** CC-specific information to help identify this value */
    ccSpecific?: Record<string, any>;
}
export interface ValueMetadataNumeric extends ValueMetadataAny {
    type: "number";
    /** The minimum value that can be assigned to a CC value (optional) */
    min?: number;
    /** The maximum value that can be assigned to a CC value (optional) */
    max?: number;
    /** When only certain values between min and max are allowed, this determines the step size */
    steps?: number;
    /** The default value */
    default?: number;
    /** Speaking names for numeric values */
    states?: Record<number, string>;
    /** An optional unit for numeric values */
    unit?: string;
}
export interface ValueMetadataBoolean extends ValueMetadataAny {
    type: "boolean";
    /** The default value */
    default?: number;
}
export interface ValueMetadataString extends ValueMetadataAny {
    type: "string" | "color";
    /** The minimum length this string must have (optional) */
    minLength?: number;
    /** The maximum length this string may have (optional) */
    maxLength?: number;
    /** The default value */
    default?: string;
}
export interface ValueMetadataDuration extends ValueMetadataAny {
    type: "duration";
    default?: Duration;
}
export declare type ValueMetadata = ValueMetadataAny | ValueMetadataNumeric | ValueMetadataBoolean | ValueMetadataString;
/** A collection of predefined CC value metadata */
export declare const ValueMetadata: {
    /** The default value for metadata: readable and writeable */
    Any: Readonly<ValueMetadataAny>;
    /** The default value for readonly metadata */
    ReadOnly: Readonly<ValueMetadataAny>;
    /** The default value for writeonly metadata */
    WriteOnly: Readonly<ValueMetadataAny>;
    /** A numeric value */
    Number: Readonly<ValueMetadataNumeric>;
    /** A numeric value (readonly) */
    ReadOnlyNumber: Readonly<ValueMetadataNumeric>;
    /** A numeric value (writeonly) */
    WriteOnlyNumber: Readonly<ValueMetadataNumeric>;
    /** Unsigned 8-bit integer */
    UInt8: Readonly<ValueMetadataNumeric>;
    /** Unsigned 16-bit integer */
    UInt16: Readonly<ValueMetadataNumeric>;
    /** Unsigned 24-bit integer */
    UInt24: Readonly<ValueMetadataNumeric>;
    /** Unsigned 32-bit integer */
    UInt32: Readonly<ValueMetadataNumeric>;
    /** Signed 8-bit integer */
    Int8: Readonly<ValueMetadataNumeric>;
    /** Signed 16-bit integer */
    Int16: Readonly<ValueMetadataNumeric>;
    /** Signed 24-bit integer */
    Int24: Readonly<ValueMetadataNumeric>;
    /** Signed 32-bit integer */
    Int32: Readonly<ValueMetadataNumeric>;
    /** Unsigned 8-bit integer (readonly) */
    ReadOnlyUInt8: Readonly<ValueMetadataNumeric>;
    /** Unsigned 16-bit integer (readonly) */
    ReadOnlyUInt16: Readonly<ValueMetadataNumeric>;
    /** Unsigned 24-bit integer (readonly) */
    ReadOnlyUInt24: Readonly<ValueMetadataNumeric>;
    /** Unsigned 32-bit integer (readonly) */
    ReadOnlyUInt32: Readonly<ValueMetadataNumeric>;
    /** Signed 8-bit integer (readonly) */
    ReadOnlyInt8: Readonly<ValueMetadataNumeric>;
    /** Signed 16-bit integer (readonly) */
    ReadOnlyInt16: Readonly<ValueMetadataNumeric>;
    /** Signed 24-bit integer (readonly) */
    ReadOnlyInt24: Readonly<ValueMetadataNumeric>;
    /** Signed 32-bit integer (readonly) */
    ReadOnlyInt32: Readonly<ValueMetadataNumeric>;
    /** Unsigned 8-bit integer (writeonly) */
    WriteOnlyUInt8: Readonly<ValueMetadataNumeric>;
    /** Unsigned 16-bit integer (writeonly) */
    WriteOnlyUInt16: Readonly<ValueMetadataNumeric>;
    /** Unsigned 24-bit integer (writeonly) */
    WriteOnlyUInt24: Readonly<ValueMetadataNumeric>;
    /** Unsigned 32-bit integer (writeonly) */
    WriteOnlyUInt32: Readonly<ValueMetadataNumeric>;
    /** Signed 8-bit integer (writeonly) */
    WriteOnlyInt8: Readonly<ValueMetadataNumeric>;
    /** Signed 16-bit integer (writeonly) */
    WriteOnlyInt16: Readonly<ValueMetadataNumeric>;
    /** Signed 24-bit integer (writeonly) */
    WriteOnlyInt24: Readonly<ValueMetadataNumeric>;
    /** Signed 32-bit integer (writeonly) */
    WriteOnlyInt32: Readonly<ValueMetadataNumeric>;
    /** The level of a Switch (0-99) */
    Level: Readonly<ValueMetadataNumeric>;
    /** The level of a Switch (0-99, readonly) */
    ReadOnlyLevel: Readonly<ValueMetadataNumeric>;
    /** The level of a Switch (0-99, writeonly) */
    WriteOnlyLevel: Readonly<ValueMetadataNumeric>;
    /** A boolean value */
    Boolean: Readonly<ValueMetadataBoolean>;
    /** A boolean value (readonly) */
    ReadOnlyBoolean: Readonly<ValueMetadataBoolean>;
    /** A boolean value (writeonly) */
    WriteOnlyBoolean: Readonly<ValueMetadataBoolean>;
    /** A string */
    String: Readonly<ValueMetadataString>;
    /** A string (readonly) */
    ReadOnlyString: Readonly<ValueMetadataString>;
    /** A string (writeonly) */
    WriteOnlyString: Readonly<ValueMetadataString>;
    /** A (hex) string that represents a color */
    Color: Readonly<ValueMetadataString>;
    /** A (hex) string that represents a color (readonly) */
    ReadOnlyColor: Readonly<ValueMetadataString>;
    /** A (hex) string that represents a color (writeonly) */
    WriteOnlyColor: Readonly<ValueMetadataString>;
    /** A duration value */
    Duration: Readonly<ValueMetadataDuration>;
    /** A duration value (readonly) */
    ReadOnlyDuration: Readonly<ValueMetadataDuration>;
    /** A duration value (writeonly) */
    WriteOnlyDuration: Readonly<ValueMetadataDuration>;
};
//# sourceMappingURL=Metadata.d.ts.map