"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.staticExtends = exports.Mixin = void 0;
/** Decorator to support multi-inheritance using mixins */
function Mixin(baseCtors) {
    return function (derivedCtor) {
        baseCtors.forEach((baseCtor) => {
            Object.getOwnPropertyNames(baseCtor.prototype).forEach((name) => {
                // Do not override the constructor
                if (name !== "constructor") {
                    derivedCtor.prototype[name] = baseCtor.prototype[name];
                }
            });
        });
    };
}
exports.Mixin = Mixin;
/** Tests if base is in the super chain of `constructor` */
function staticExtends(constructor, base) {
    while (constructor) {
        if (constructor === base)
            return true;
        constructor = Object.getPrototypeOf(constructor);
    }
    return false;
}
exports.staticExtends = staticExtends;
//# sourceMappingURL=inheritance.js.map