"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AlarmSensorCCSupportedGet = exports.AlarmSensorCCSupportedReport = exports.AlarmSensorCCGet = exports.AlarmSensorCCReport = exports.AlarmSensorCC = exports.AlarmSensorCCAPI = exports.getSupportedSensorTypesValueId = exports.getAlarmSensorDurationValueId = exports.getAlarmSensorSeverityValueId = exports.getAlarmSensorStateValueId = exports.AlarmSensorType = exports.AlarmSensorCommand = void 0;
const core_1 = require("@zwave-js/core");
const shared_1 = require("@zwave-js/shared");
const Constants_1 = require("../message/Constants");
const API_1 = require("./API");
const CommandClass_1 = require("./CommandClass");
// All the supported commands
var AlarmSensorCommand;
(function (AlarmSensorCommand) {
    AlarmSensorCommand[AlarmSensorCommand["Get"] = 1] = "Get";
    AlarmSensorCommand[AlarmSensorCommand["Report"] = 2] = "Report";
    AlarmSensorCommand[AlarmSensorCommand["SupportedGet"] = 3] = "SupportedGet";
    AlarmSensorCommand[AlarmSensorCommand["SupportedReport"] = 4] = "SupportedReport";
})(AlarmSensorCommand = exports.AlarmSensorCommand || (exports.AlarmSensorCommand = {}));
// @publicAPI
var AlarmSensorType;
(function (AlarmSensorType) {
    AlarmSensorType[AlarmSensorType["General Purpose"] = 0] = "General Purpose";
    AlarmSensorType[AlarmSensorType["Smoke"] = 1] = "Smoke";
    AlarmSensorType[AlarmSensorType["CO"] = 2] = "CO";
    AlarmSensorType[AlarmSensorType["CO2"] = 3] = "CO2";
    AlarmSensorType[AlarmSensorType["Heat"] = 4] = "Heat";
    AlarmSensorType[AlarmSensorType["Water Leak"] = 5] = "Water Leak";
    AlarmSensorType[AlarmSensorType["Any"] = 255] = "Any";
})(AlarmSensorType = exports.AlarmSensorType || (exports.AlarmSensorType = {}));
function getAlarmSensorStateValueId(endpointIndex, sensorType) {
    return {
        commandClass: core_1.CommandClasses["Alarm Sensor"],
        endpoint: endpointIndex,
        property: "state",
        propertyKey: sensorType,
    };
}
exports.getAlarmSensorStateValueId = getAlarmSensorStateValueId;
function getAlarmSensorSeverityValueId(endpointIndex, sensorType) {
    return {
        commandClass: core_1.CommandClasses["Alarm Sensor"],
        endpoint: endpointIndex,
        property: "severity",
        propertyKey: sensorType,
    };
}
exports.getAlarmSensorSeverityValueId = getAlarmSensorSeverityValueId;
function getAlarmSensorDurationValueId(endpointIndex, sensorType) {
    return {
        commandClass: core_1.CommandClasses["Alarm Sensor"],
        endpoint: endpointIndex,
        property: "duration",
        propertyKey: sensorType,
    };
}
exports.getAlarmSensorDurationValueId = getAlarmSensorDurationValueId;
function getSupportedSensorTypesValueId(endpointIndex) {
    return {
        commandClass: core_1.CommandClasses["Alarm Sensor"],
        endpoint: endpointIndex,
        property: "supportedSensorTypes",
    };
}
exports.getSupportedSensorTypesValueId = getSupportedSensorTypesValueId;
// @noSetValueAPI This CC is read-only
let AlarmSensorCCAPI = class AlarmSensorCCAPI extends API_1.PhysicalCCAPI {
    supportsCommand(cmd) {
        switch (cmd) {
            case AlarmSensorCommand.Get:
            case AlarmSensorCommand.SupportedGet:
                return true; // This is mandatory
        }
        return super.supportsCommand(cmd);
    }
    /**
     * Retrieves the current value from this sensor
     * @param sensorType The (optional) sensor type to retrieve the value for
     */
    // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
    async get(sensorType) {
        this.assertSupportsCommand(AlarmSensorCommand, AlarmSensorCommand.Get);
        const cc = new AlarmSensorCCGet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
            sensorType,
        });
        const response = await this.driver.sendCommand(cc, this.commandOptions);
        if (response)
            return shared_1.pick(response, ["state", "severity", "duration"]);
    }
    // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
    async getSupportedSensorTypes() {
        this.assertSupportsCommand(AlarmSensorCommand, AlarmSensorCommand.SupportedGet);
        const cc = new AlarmSensorCCSupportedGet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
        });
        const response = await this.driver.sendCommand(cc, this.commandOptions);
        if (response)
            return response.supportedSensorTypes;
    }
};
AlarmSensorCCAPI = __decorate([
    CommandClass_1.API(core_1.CommandClasses["Alarm Sensor"])
], AlarmSensorCCAPI);
exports.AlarmSensorCCAPI = AlarmSensorCCAPI;
let AlarmSensorCC = class AlarmSensorCC extends CommandClass_1.CommandClass {
    async interview(complete = true) {
        var _a;
        const node = this.getNode();
        const endpoint = this.getEndpoint();
        // Skip the interview in favor of Notification CC if possible
        if (endpoint.commandClasses.Notification.isSupported()) {
            this.driver.controllerLog.logNode(node.id, {
                endpoint: this.endpointIndex,
                message: `${this.constructor.name}: skipping interview because Notification CC is supported...`,
                direction: "none",
            });
            this.interviewComplete = true;
            return;
        }
        const api = endpoint.commandClasses["Alarm Sensor"].withOptions({
            priority: Constants_1.MessagePriority.NodeQuery,
        });
        this.driver.controllerLog.logNode(node.id, {
            endpoint: this.endpointIndex,
            message: `${this.constructor.name}: doing a ${complete ? "complete" : "partial"} interview...`,
            direction: "none",
        });
        // Find out which sensor types this sensor supports
        let supportedSensorTypes;
        if (complete) {
            this.driver.controllerLog.logNode(node.id, {
                endpoint: this.endpointIndex,
                message: "querying supported sensor types...",
                direction: "outbound",
            });
            supportedSensorTypes = await api.getSupportedSensorTypes();
            if (supportedSensorTypes) {
                const logMessage = `received supported sensor types: ${supportedSensorTypes
                    .map((type) => shared_1.getEnumMemberName(AlarmSensorType, type))
                    .map((name) => `\n· ${name}`)
                    .join("")}`;
                this.driver.controllerLog.logNode(node.id, {
                    endpoint: this.endpointIndex,
                    message: logMessage,
                    direction: "inbound",
                });
            }
            else {
                this.driver.controllerLog.logNode(node.id, {
                    endpoint: this.endpointIndex,
                    message: "Querying supported sensor types timed out, skipping interview...",
                    level: "warn",
                });
                return;
            }
        }
        else {
            supportedSensorTypes = (_a = this.getValueDB().getValue(getSupportedSensorTypesValueId(this.endpointIndex))) !== null && _a !== void 0 ? _a : [];
        }
        // Always query (all of) the sensor's current value(s)
        for (const type of supportedSensorTypes) {
            const sensorName = shared_1.getEnumMemberName(AlarmSensorType, type);
            this.driver.controllerLog.logNode(node.id, {
                endpoint: this.endpointIndex,
                message: `querying current value for ${sensorName}...`,
                direction: "outbound",
            });
            const currentValue = await api.get(type);
            if (currentValue) {
                let message = `received current value for ${sensorName}: 
state:    ${currentValue.state}`;
                if (currentValue.severity != undefined) {
                    message += `
severity: ${currentValue.severity}`;
                }
                if (currentValue.duration != undefined) {
                    message += `
duration: ${currentValue.duration}`;
                }
                this.driver.controllerLog.logNode(node.id, {
                    endpoint: this.endpointIndex,
                    message,
                    direction: "inbound",
                });
            }
        }
        // Remember that the interview is complete
        this.interviewComplete = true;
    }
    createMetadataForSensorType(sensorType) {
        const stateValueId = getAlarmSensorStateValueId(this.endpointIndex, sensorType);
        const severityValueId = getAlarmSensorSeverityValueId(this.endpointIndex, sensorType);
        const durationValueId = getAlarmSensorDurationValueId(this.endpointIndex, sensorType);
        const valueDB = this.getValueDB();
        const alarmName = shared_1.getEnumMemberName(AlarmSensorType, sensorType);
        // Always create metadata if it does not exist
        if (!valueDB.hasMetadata(stateValueId)) {
            valueDB.setMetadata(stateValueId, {
                ...core_1.ValueMetadata.ReadOnlyBoolean,
                label: `${alarmName} state`,
                description: "Whether the alarm is active",
                ccSpecific: { sensorType },
            });
        }
        if (!valueDB.hasMetadata(severityValueId)) {
            valueDB.setMetadata(severityValueId, {
                ...core_1.ValueMetadata.ReadOnlyNumber,
                min: 1,
                max: 100,
                unit: "%",
                label: `${alarmName} severity`,
                ccSpecific: { sensorType },
            });
        }
        if (!valueDB.hasMetadata(durationValueId)) {
            valueDB.setMetadata(durationValueId, {
                ...core_1.ValueMetadata.ReadOnlyNumber,
                unit: "s",
                label: `${alarmName} duration`,
                description: "For how long the alarm should be active",
                ccSpecific: { sensorType },
            });
        }
    }
};
AlarmSensorCC = __decorate([
    CommandClass_1.commandClass(core_1.CommandClasses["Alarm Sensor"]),
    CommandClass_1.implementedVersion(1)
], AlarmSensorCC);
exports.AlarmSensorCC = AlarmSensorCC;
let AlarmSensorCCReport = class AlarmSensorCCReport extends AlarmSensorCC {
    constructor(driver, options) {
        super(driver, options);
        core_1.validatePayload(this.payload.length >= 5, this.payload[1] !== 0xff);
        // Alarm Sensor reports may be forwarded by a different node, in this case
        // (and only then!) the payload contains the original node ID
        const sourceNodeId = this.payload[0];
        if (sourceNodeId !== 0) {
            this.nodeId = sourceNodeId;
        }
        this.sensorType = this.payload[1];
        // Any positive value gets interpreted as alarm
        this.state = this.payload[2] > 0;
        // Severity only ranges from 1 to 100
        if (this.payload[2] > 0 && this.payload[2] <= 0x64) {
            this.severity = this.payload[2];
        }
        // ignore zero durations
        this.duration = this.payload.readUInt16BE(3) || undefined;
        this.persistValues();
    }
    toLogEntry() {
        const message = {
            "sensor type": shared_1.getEnumMemberName(AlarmSensorType, this.sensorType),
            "alarm state": this.state,
        };
        if (this.severity != undefined) {
            message.severity = this.severity;
        }
        if (this.duration != undefined) {
            message.duration = `${this.duration} seconds`;
        }
        return {
            ...super.toLogEntry(),
            message,
        };
    }
    persistValues() {
        if (!super.persistValues())
            return false;
        // Create metadata if it does not exist
        this.createMetadataForSensorType(this.sensorType);
        const stateValueId = getAlarmSensorStateValueId(this.endpointIndex, this.sensorType);
        const severityValueId = getAlarmSensorSeverityValueId(this.endpointIndex, this.sensorType);
        const durationValueId = getAlarmSensorDurationValueId(this.endpointIndex, this.sensorType);
        const valueDB = this.getValueDB();
        valueDB.setValue(stateValueId, this.state);
        valueDB.setValue(severityValueId, this.severity);
        valueDB.setValue(durationValueId, this.duration);
        return true;
    }
};
AlarmSensorCCReport = __decorate([
    CommandClass_1.CCCommand(AlarmSensorCommand.Report)
], AlarmSensorCCReport);
exports.AlarmSensorCCReport = AlarmSensorCCReport;
function testResponseForAlarmSensorGet(sent, received) {
    // We expect a Alarm Sensor Report that matches the requested sensor type (if a type was requested)
    return (sent.sensorType === AlarmSensorType.Any ||
        received.sensorType === sent.sensorType);
}
let AlarmSensorCCGet = class AlarmSensorCCGet extends AlarmSensorCC {
    constructor(driver, options) {
        var _a;
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            // TODO: Deserialize payload
            throw new core_1.ZWaveError(`${this.constructor.name}: deserialization not implemented`, core_1.ZWaveErrorCodes.Deserialization_NotImplemented);
        }
        else {
            this.sensorType = (_a = options.sensorType) !== null && _a !== void 0 ? _a : AlarmSensorType.Any;
        }
    }
    serialize() {
        this.payload = Buffer.from([this.sensorType]);
        return super.serialize();
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                "sensor type": shared_1.getEnumMemberName(AlarmSensorType, this.sensorType),
            },
        };
    }
};
AlarmSensorCCGet = __decorate([
    CommandClass_1.CCCommand(AlarmSensorCommand.Get),
    CommandClass_1.expectedCCResponse(AlarmSensorCCReport, testResponseForAlarmSensorGet)
], AlarmSensorCCGet);
exports.AlarmSensorCCGet = AlarmSensorCCGet;
let AlarmSensorCCSupportedReport = class AlarmSensorCCSupportedReport extends AlarmSensorCC {
    constructor(driver, options) {
        super(driver, options);
        core_1.validatePayload(this.payload.length >= 1);
        const bitMaskLength = this.payload[0];
        core_1.validatePayload(this.payload.length >= 1 + bitMaskLength);
        this._supportedSensorTypes = core_1.parseBitMask(this.payload.slice(1, 1 + bitMaskLength), AlarmSensorType["General Purpose"]);
        this.persistValues();
    }
    get supportedSensorTypes() {
        return this._supportedSensorTypes;
    }
    persistValues() {
        if (!super.persistValues())
            return false;
        // Create metadata for each sensor type
        for (const type of this._supportedSensorTypes) {
            this.createMetadataForSensorType(type);
        }
        return true;
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                "supported sensor types": this._supportedSensorTypes
                    .map((t) => shared_1.getEnumMemberName(AlarmSensorType, t))
                    .join(", "),
            },
        };
    }
};
__decorate([
    CommandClass_1.ccValue({ internal: true })
], AlarmSensorCCSupportedReport.prototype, "supportedSensorTypes", null);
AlarmSensorCCSupportedReport = __decorate([
    CommandClass_1.CCCommand(AlarmSensorCommand.SupportedReport)
], AlarmSensorCCSupportedReport);
exports.AlarmSensorCCSupportedReport = AlarmSensorCCSupportedReport;
let AlarmSensorCCSupportedGet = class AlarmSensorCCSupportedGet extends AlarmSensorCC {
};
AlarmSensorCCSupportedGet = __decorate([
    CommandClass_1.CCCommand(AlarmSensorCommand.SupportedGet),
    CommandClass_1.expectedCCResponse(AlarmSensorCCSupportedReport)
], AlarmSensorCCSupportedGet);
exports.AlarmSensorCCSupportedGet = AlarmSensorCCSupportedGet;

//# sourceMappingURL=AlarmSensorCC.js.map
