"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BatteryCCHealthGet = exports.BatteryCCHealthReport = exports.BatteryCCGet = exports.BatteryCCReport = exports.BatteryCC = exports.BatteryCCAPI = exports.BatteryCommand = exports.BatteryReplacementStatus = exports.BatteryChargingStatus = void 0;
const core_1 = require("@zwave-js/core");
const shared_1 = require("@zwave-js/shared");
const Constants_1 = require("../message/Constants");
const API_1 = require("./API");
const CommandClass_1 = require("./CommandClass");
// @noSetValueAPI This CC is read-only
/**
 * @publicAPI
 */
var BatteryChargingStatus;
(function (BatteryChargingStatus) {
    BatteryChargingStatus[BatteryChargingStatus["Discharging"] = 0] = "Discharging";
    BatteryChargingStatus[BatteryChargingStatus["Charging"] = 1] = "Charging";
    BatteryChargingStatus[BatteryChargingStatus["Maintaining"] = 2] = "Maintaining";
})(BatteryChargingStatus = exports.BatteryChargingStatus || (exports.BatteryChargingStatus = {}));
/**
 * @publicAPI
 */
var BatteryReplacementStatus;
(function (BatteryReplacementStatus) {
    BatteryReplacementStatus[BatteryReplacementStatus["No"] = 0] = "No";
    BatteryReplacementStatus[BatteryReplacementStatus["Soon"] = 1] = "Soon";
    BatteryReplacementStatus[BatteryReplacementStatus["Now"] = 2] = "Now";
})(BatteryReplacementStatus = exports.BatteryReplacementStatus || (exports.BatteryReplacementStatus = {}));
var BatteryCommand;
(function (BatteryCommand) {
    BatteryCommand[BatteryCommand["Get"] = 2] = "Get";
    BatteryCommand[BatteryCommand["Report"] = 3] = "Report";
    BatteryCommand[BatteryCommand["HealthGet"] = 4] = "HealthGet";
    BatteryCommand[BatteryCommand["HealthReport"] = 5] = "HealthReport";
})(BatteryCommand = exports.BatteryCommand || (exports.BatteryCommand = {}));
let BatteryCCAPI = class BatteryCCAPI extends API_1.PhysicalCCAPI {
    constructor() {
        super(...arguments);
        this[_a] = async ({ property, }) => {
            var _b, _c;
            switch (property) {
                case "level":
                case "isLow":
                case "chargingStatus":
                case "rechargeable":
                case "backup":
                case "overheating":
                case "lowFluid":
                case "rechargeOrReplace":
                case "lowTemperatureStatus":
                case "disconnected":
                    return (_b = (await this.get())) === null || _b === void 0 ? void 0 : _b[property];
                case "maximumCapacity":
                case "temperature":
                    return (_c = (await this.getHealth())) === null || _c === void 0 ? void 0 : _c[property];
                default:
                    API_1.throwUnsupportedProperty(this.ccId, property);
            }
        };
    }
    supportsCommand(cmd) {
        switch (cmd) {
            case BatteryCommand.Get:
                return true; // This is mandatory
            case BatteryCommand.HealthGet:
                return this.version >= 2;
        }
        return super.supportsCommand(cmd);
    }
    // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
    async get() {
        this.assertSupportsCommand(BatteryCommand, BatteryCommand.Get);
        const cc = new BatteryCCGet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
        });
        const response = await this.driver.sendCommand(cc, this.commandOptions);
        if (response) {
            return shared_1.pick(response, [
                "level",
                "isLow",
                "chargingStatus",
                "rechargeable",
                "backup",
                "overheating",
                "lowFluid",
                "rechargeOrReplace",
                "lowTemperatureStatus",
                "disconnected",
            ]);
        }
    }
    // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
    async getHealth() {
        this.assertSupportsCommand(BatteryCommand, BatteryCommand.HealthGet);
        const cc = new BatteryCCHealthGet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
        });
        const response = await this.driver.sendCommand(cc, this.commandOptions);
        if (response) {
            return shared_1.pick(response, ["maximumCapacity", "temperature"]);
        }
    }
};
_a = API_1.POLL_VALUE;
BatteryCCAPI = __decorate([
    CommandClass_1.API(core_1.CommandClasses.Battery)
], BatteryCCAPI);
exports.BatteryCCAPI = BatteryCCAPI;
let BatteryCC = class BatteryCC extends CommandClass_1.CommandClass {
    async interview(complete = true) {
        const node = this.getNode();
        const endpoint = this.getEndpoint();
        const api = endpoint.commandClasses.Battery.withOptions({
            priority: Constants_1.MessagePriority.NodeQuery,
        });
        this.driver.controllerLog.logNode(node.id, {
            endpoint: this.endpointIndex,
            message: `${this.constructor.name}: doing a ${complete ? "complete" : "partial"} interview...`,
            direction: "none",
        });
        // always query the status
        this.driver.controllerLog.logNode(node.id, {
            endpoint: this.endpointIndex,
            message: "querying battery status...",
            direction: "outbound",
        });
        const batteryStatus = await api.get();
        if (batteryStatus) {
            let logMessage = `received response for battery information:
level:                           ${batteryStatus.level}${batteryStatus.isLow ? " (low)" : ""}`;
            if (this.version >= 2) {
                logMessage += `
status:                          ${BatteryChargingStatus[batteryStatus.chargingStatus]}
rechargeable:                    ${batteryStatus.rechargeable}
is backup:                       ${batteryStatus.backup}
is overheating:                  ${batteryStatus.overheating}
fluid is low:                    ${batteryStatus.lowFluid}
needs to be replaced or charged: ${BatteryReplacementStatus[batteryStatus.rechargeOrReplace]}
is low temperature               ${batteryStatus.lowTemperatureStatus}
is disconnected:                 ${batteryStatus.disconnected}`;
            }
            this.driver.controllerLog.logNode(node.id, {
                endpoint: this.endpointIndex,
                message: logMessage,
                direction: "inbound",
            });
        }
        if (this.version >= 2) {
            // always query the health
            this.driver.controllerLog.logNode(node.id, {
                endpoint: this.endpointIndex,
                message: "querying battery health...",
                direction: "outbound",
            });
            const batteryHealth = await api.getHealth();
            if (batteryHealth) {
                const logMessage = `received response for battery health:
max. capacity: ${batteryHealth.maximumCapacity} %
temperature:   ${batteryHealth.temperature} °C`;
                this.driver.controllerLog.logNode(node.id, {
                    endpoint: this.endpointIndex,
                    message: logMessage,
                    direction: "inbound",
                });
            }
        }
        // Remember that the interview is complete
        this.interviewComplete = true;
    }
};
BatteryCC = __decorate([
    CommandClass_1.commandClass(core_1.CommandClasses.Battery),
    CommandClass_1.implementedVersion(3)
], BatteryCC);
exports.BatteryCC = BatteryCC;
let BatteryCCReport = class BatteryCCReport extends BatteryCC {
    constructor(driver, options) {
        super(driver, options);
        core_1.validatePayload(this.payload.length >= 1);
        this._level = this.payload[0];
        if (this._level === 0xff) {
            this._level = 0;
            this._isLow = true;
        }
        else {
            this._isLow = false;
        }
        if (this.payload.length >= 3) {
            // Starting with V2
            this._chargingStatus = this.payload[1] >>> 6;
            this._rechargeable = !!(this.payload[1] & 32);
            this._backup = !!(this.payload[1] & 16);
            this._overheating = !!(this.payload[1] & 0b1000);
            this._lowFluid = !!(this.payload[1] & 0b0100);
            this._rechargeOrReplace = !!(this.payload[1] & 0b10)
                ? BatteryReplacementStatus.Now
                : !!(this.payload[1] & 0b1)
                    ? BatteryReplacementStatus.Soon
                    : BatteryReplacementStatus.No;
            this._lowTemperatureStatus = !!(this.payload[2] & 0b10);
            this._disconnected = !!(this.payload[2] & 0b1);
        }
        this.persistValues();
    }
    get level() {
        return this._level;
    }
    get isLow() {
        return this._isLow;
    }
    get chargingStatus() {
        return this._chargingStatus;
    }
    get rechargeable() {
        return this._rechargeable;
    }
    get backup() {
        return this._backup;
    }
    get overheating() {
        return this._overheating;
    }
    get lowFluid() {
        return this._lowFluid;
    }
    get rechargeOrReplace() {
        return this._rechargeOrReplace;
    }
    get disconnected() {
        return this._disconnected;
    }
    get lowTemperatureStatus() {
        return this._lowTemperatureStatus;
    }
    toLogEntry() {
        const message = {
            level: this._level,
            "is low": this._isLow,
        };
        if (this.chargingStatus != undefined) {
            message["charging status"] = shared_1.getEnumMemberName(BatteryChargingStatus, this.chargingStatus);
        }
        if (this.rechargeable != undefined) {
            message.rechargeable = this.rechargeable;
        }
        if (this.backup != undefined) {
            message.backup = this.backup;
        }
        if (this.overheating != undefined) {
            message.overheating = this.overheating;
        }
        if (this.lowFluid != undefined) {
            message["low fluid"] = this.lowFluid;
        }
        if (this.rechargeOrReplace != undefined) {
            message["recharge or replace"] = shared_1.getEnumMemberName(BatteryReplacementStatus, this.rechargeOrReplace);
        }
        if (this.lowTemperatureStatus != undefined) {
            message.lowTemperatureStatus = this.lowTemperatureStatus;
        }
        if (this.disconnected != undefined) {
            message.disconnected = this.disconnected;
        }
        return {
            ...super.toLogEntry(),
            message,
        };
    }
};
__decorate([
    CommandClass_1.ccValue(),
    CommandClass_1.ccValueMetadata({
        ...core_1.ValueMetadata.ReadOnlyUInt8,
        max: 100,
        unit: "%",
        label: "Battery level",
    })
], BatteryCCReport.prototype, "level", null);
__decorate([
    CommandClass_1.ccValue(),
    CommandClass_1.ccValueMetadata({
        ...core_1.ValueMetadata.ReadOnlyBoolean,
        label: "Low battery level",
    })
], BatteryCCReport.prototype, "isLow", null);
__decorate([
    CommandClass_1.ccValue({ minVersion: 2 }),
    CommandClass_1.ccValueMetadata({
        ...core_1.ValueMetadata.ReadOnlyUInt8,
        label: "Charging status",
        states: core_1.enumValuesToMetadataStates(BatteryChargingStatus),
    })
], BatteryCCReport.prototype, "chargingStatus", null);
__decorate([
    CommandClass_1.ccValue({ minVersion: 2 }),
    CommandClass_1.ccValueMetadata({
        ...core_1.ValueMetadata.ReadOnlyBoolean,
        label: "Rechargeable",
    })
], BatteryCCReport.prototype, "rechargeable", null);
__decorate([
    CommandClass_1.ccValue({ minVersion: 2 }),
    CommandClass_1.ccValueMetadata({
        ...core_1.ValueMetadata.ReadOnlyBoolean,
        label: "Used as backup",
    })
], BatteryCCReport.prototype, "backup", null);
__decorate([
    CommandClass_1.ccValue({ minVersion: 2 }),
    CommandClass_1.ccValueMetadata({
        ...core_1.ValueMetadata.ReadOnlyBoolean,
        label: "Overheating",
    })
], BatteryCCReport.prototype, "overheating", null);
__decorate([
    CommandClass_1.ccValue({ minVersion: 2 }),
    CommandClass_1.ccValueMetadata({
        ...core_1.ValueMetadata.ReadOnlyBoolean,
        label: "Fluid is low",
    })
], BatteryCCReport.prototype, "lowFluid", null);
__decorate([
    CommandClass_1.ccValue({ minVersion: 2 }),
    CommandClass_1.ccValueMetadata({
        ...core_1.ValueMetadata.ReadOnlyUInt8,
        label: "Recharge or replace",
        states: core_1.enumValuesToMetadataStates(BatteryReplacementStatus),
    })
], BatteryCCReport.prototype, "rechargeOrReplace", null);
__decorate([
    CommandClass_1.ccValue({ minVersion: 2 }),
    CommandClass_1.ccValueMetadata({
        ...core_1.ValueMetadata.ReadOnlyBoolean,
        label: "Battery is disconnected",
    })
], BatteryCCReport.prototype, "disconnected", null);
__decorate([
    CommandClass_1.ccValue({ minVersion: 3 }),
    CommandClass_1.ccValueMetadata({
        ...core_1.ValueMetadata.ReadOnlyBoolean,
        label: "Battery temperature is low",
    })
], BatteryCCReport.prototype, "lowTemperatureStatus", null);
BatteryCCReport = __decorate([
    CommandClass_1.CCCommand(BatteryCommand.Report)
], BatteryCCReport);
exports.BatteryCCReport = BatteryCCReport;
let BatteryCCGet = class BatteryCCGet extends BatteryCC {
};
BatteryCCGet = __decorate([
    CommandClass_1.CCCommand(BatteryCommand.Get),
    CommandClass_1.expectedCCResponse(BatteryCCReport)
], BatteryCCGet);
exports.BatteryCCGet = BatteryCCGet;
let BatteryCCHealthReport = class BatteryCCHealthReport extends BatteryCC {
    constructor(driver, options) {
        super(driver, options);
        core_1.validatePayload(this.payload.length >= 2);
        this._maximumCapacity = this.payload[0];
        const { value: temperature, scale } = core_1.parseFloatWithScale(this.payload.slice(1));
        this._temperature = temperature;
        const valueId = {
            commandClass: this.ccId,
            endpoint: this.endpointIndex,
            property: "temperature",
        };
        this.getValueDB().setMetadata(valueId, {
            ...core_1.ValueMetadata.ReadOnlyNumber,
            label: "Temperature",
            unit: scale === 0x00 ? "°C" : undefined,
        });
        this.persistValues();
    }
    get maximumCapacity() {
        return this._maximumCapacity;
    }
    get temperature() {
        return this._temperature;
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                temperature: this.temperature,
                "max capacity": `${this.maximumCapacity} %`,
            },
        };
    }
};
__decorate([
    CommandClass_1.ccValue({ minVersion: 2 }),
    CommandClass_1.ccValueMetadata({
        ...core_1.ValueMetadata.ReadOnlyUInt8,
        max: 100,
        unit: "%",
        label: "Maximum capacity",
    })
], BatteryCCHealthReport.prototype, "maximumCapacity", null);
__decorate([
    CommandClass_1.ccValue({ minVersion: 2 }),
    CommandClass_1.ccValueMetadata({
        ...core_1.ValueMetadata.ReadOnlyUInt8,
        label: "Temperature",
    })
], BatteryCCHealthReport.prototype, "temperature", null);
BatteryCCHealthReport = __decorate([
    CommandClass_1.CCCommand(BatteryCommand.HealthReport)
], BatteryCCHealthReport);
exports.BatteryCCHealthReport = BatteryCCHealthReport;
let BatteryCCHealthGet = class BatteryCCHealthGet extends BatteryCC {
};
BatteryCCHealthGet = __decorate([
    CommandClass_1.CCCommand(BatteryCommand.HealthGet),
    CommandClass_1.expectedCCResponse(BatteryCCHealthReport)
], BatteryCCHealthGet);
exports.BatteryCCHealthGet = BatteryCCHealthGet;

//# sourceMappingURL=BatteryCC.js.map
