"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CentralSceneCCConfigurationSet = exports.CentralSceneCCConfigurationGet = exports.CentralSceneCCConfigurationReport = exports.CentralSceneCCSupportedGet = exports.CentralSceneCCSupportedReport = exports.CentralSceneCCNotification = exports.CentralSceneCC = exports.CentralSceneCCAPI = exports.CentralSceneKeys = exports.CentralSceneCommand = exports.getSceneValueId = void 0;
const core_1 = require("@zwave-js/core");
const shared_1 = require("@zwave-js/shared");
const strings_1 = require("alcalzone-shared/strings");
const Constants_1 = require("../message/Constants");
const API_1 = require("./API");
const AssociationGroupInfoCC_1 = require("./AssociationGroupInfoCC");
const CommandClass_1 = require("./CommandClass");
/** Returns the ValueID used to store the current value of a Central Scene */
function getSceneValueId(sceneNumber) {
    return {
        commandClass: core_1.CommandClasses["Central Scene"],
        property: "scene",
        propertyKey: strings_1.padStart(sceneNumber.toString(), 3, "0"),
    };
}
exports.getSceneValueId = getSceneValueId;
function getSceneLabel(sceneNumber) {
    return `Scene ${strings_1.padStart(sceneNumber.toString(), 3, "0")}`;
}
var CentralSceneCommand;
(function (CentralSceneCommand) {
    CentralSceneCommand[CentralSceneCommand["SupportedGet"] = 1] = "SupportedGet";
    CentralSceneCommand[CentralSceneCommand["SupportedReport"] = 2] = "SupportedReport";
    CentralSceneCommand[CentralSceneCommand["Notification"] = 3] = "Notification";
    CentralSceneCommand[CentralSceneCommand["ConfigurationSet"] = 4] = "ConfigurationSet";
    CentralSceneCommand[CentralSceneCommand["ConfigurationGet"] = 5] = "ConfigurationGet";
    CentralSceneCommand[CentralSceneCommand["ConfigurationReport"] = 6] = "ConfigurationReport";
})(CentralSceneCommand = exports.CentralSceneCommand || (exports.CentralSceneCommand = {}));
/**
 * @publicAPI
 */
var CentralSceneKeys;
(function (CentralSceneKeys) {
    CentralSceneKeys[CentralSceneKeys["KeyPressed"] = 0] = "KeyPressed";
    CentralSceneKeys[CentralSceneKeys["KeyReleased"] = 1] = "KeyReleased";
    CentralSceneKeys[CentralSceneKeys["KeyHeldDown"] = 2] = "KeyHeldDown";
    CentralSceneKeys[CentralSceneKeys["KeyPressed2x"] = 3] = "KeyPressed2x";
    CentralSceneKeys[CentralSceneKeys["KeyPressed3x"] = 4] = "KeyPressed3x";
    CentralSceneKeys[CentralSceneKeys["KeyPressed4x"] = 5] = "KeyPressed4x";
    CentralSceneKeys[CentralSceneKeys["KeyPressed5x"] = 6] = "KeyPressed5x";
})(CentralSceneKeys = exports.CentralSceneKeys || (exports.CentralSceneKeys = {}));
let CentralSceneCCAPI = class CentralSceneCCAPI extends API_1.CCAPI {
    constructor() {
        super(...arguments);
        this[_a] = async ({ property }, value) => {
            if (property !== "slowRefresh") {
                API_1.throwUnsupportedProperty(this.ccId, property);
            }
            if (typeof value !== "boolean") {
                API_1.throwWrongValueType(this.ccId, property, "boolean", typeof value);
            }
            await this.setConfiguration(value);
        };
        this[_b] = async ({ property, }) => {
            var _c;
            if (property === "slowRefresh") {
                return (_c = (await this.getConfiguration())) === null || _c === void 0 ? void 0 : _c[property];
            }
            API_1.throwUnsupportedProperty(this.ccId, property);
        };
    }
    supportsCommand(cmd) {
        switch (cmd) {
            case CentralSceneCommand.SupportedGet:
                return this.isSinglecast(); // this is mandatory
            case CentralSceneCommand.ConfigurationGet:
                return this.version >= 3 && this.isSinglecast();
            case CentralSceneCommand.ConfigurationSet:
                return this.version >= 3;
        }
        return super.supportsCommand(cmd);
    }
    // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
    async getSupported() {
        this.assertSupportsCommand(CentralSceneCommand, CentralSceneCommand.SupportedGet);
        const cc = new CentralSceneCCSupportedGet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
        });
        const response = await this.driver.sendCommand(cc, this.commandOptions);
        if (response) {
            return shared_1.pick(response, [
                "sceneCount",
                "supportsSlowRefresh",
                "supportedKeyAttributes",
            ]);
        }
    }
    // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
    async getConfiguration() {
        this.assertSupportsCommand(CentralSceneCommand, CentralSceneCommand.ConfigurationGet);
        const cc = new CentralSceneCCConfigurationGet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
        });
        const response = await this.driver.sendCommand(cc, this.commandOptions);
        if (response) {
            return shared_1.pick(response, ["slowRefresh"]);
        }
    }
    async setConfiguration(slowRefresh) {
        this.assertSupportsCommand(CentralSceneCommand, CentralSceneCommand.ConfigurationSet);
        const cc = new CentralSceneCCConfigurationSet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
            slowRefresh,
        });
        await this.driver.sendCommand(cc, this.commandOptions);
    }
};
_a = API_1.SET_VALUE, _b = API_1.POLL_VALUE;
CentralSceneCCAPI = __decorate([
    CommandClass_1.API(core_1.CommandClasses["Central Scene"])
], CentralSceneCCAPI);
exports.CentralSceneCCAPI = CentralSceneCCAPI;
let CentralSceneCC = class CentralSceneCC extends CommandClass_1.CommandClass {
    determineRequiredCCInterviews() {
        return [
            ...super.determineRequiredCCInterviews(),
            core_1.CommandClasses.Association,
            core_1.CommandClasses["Multi Channel Association"],
            core_1.CommandClasses["Association Group Information"],
        ];
    }
    skipEndpointInterview() {
        // Central scene notifications are issued by the root device
        return true;
    }
    async interview(complete = true) {
        var _c;
        const node = this.getNode();
        const endpoint = this.getEndpoint();
        const api = endpoint.commandClasses["Central Scene"].withOptions({
            priority: Constants_1.MessagePriority.NodeQuery,
        });
        this.driver.controllerLog.logNode(node.id, {
            endpoint: this.endpointIndex,
            message: `${this.constructor.name}: doing a ${complete ? "complete" : "partial"} interview...`,
            direction: "none",
        });
        if (complete) {
            // If one Association group issues CentralScene notifications,
            // we need to associate ourselves with that channel
            if (node.supportsCC(core_1.CommandClasses["Association Group Information"]) &&
                (node.supportsCC(core_1.CommandClasses.Association) ||
                    node.supportsCC(core_1.CommandClasses["Multi Channel Association"]))) {
                const groupsIssueingNotifications = node
                    .createCCInstance(AssociationGroupInfoCC_1.AssociationGroupInfoCC)
                    .findGroupsForIssuedCommand(this.ccId, CentralSceneCommand.Notification);
                if (groupsIssueingNotifications.length > 0) {
                    // We always grab the first group - usually it should be the lifeline
                    const groupId = groupsIssueingNotifications[0];
                    const existingAssociations = (_c = this.driver.controller
                        .getAssociations(node.id)
                        .get(groupId)) !== null && _c !== void 0 ? _c : [];
                    if (!existingAssociations.some((a) => a.nodeId === this.driver.controller.ownNodeId)) {
                        this.driver.controllerLog.logNode(node.id, {
                            endpoint: this.endpointIndex,
                            message: "Configuring associations to receive Central Scene notifications...",
                            direction: "outbound",
                        });
                        await this.driver.controller.addAssociations(node.id, groupId, [{ nodeId: this.driver.controller.ownNodeId }]);
                    }
                }
            }
            this.driver.controllerLog.logNode(node.id, {
                endpoint: this.endpointIndex,
                message: "Querying supported scenes...",
                direction: "outbound",
            });
            const ccSupported = await api.getSupported();
            if (ccSupported) {
                const logMessage = `received supported scenes:
# of scenes:           ${ccSupported.sceneCount}
supports slow refresh: ${ccSupported.supportsSlowRefresh}`;
                this.driver.controllerLog.logNode(node.id, {
                    endpoint: this.endpointIndex,
                    message: logMessage,
                    direction: "inbound",
                });
            }
            else {
                this.driver.controllerLog.logNode(node.id, {
                    endpoint: this.endpointIndex,
                    message: "Querying supported scenes timed out, skipping interview...",
                    level: "warn",
                });
                return;
            }
            // The slow refresh capability should be enabled whenever possible
            if (this.version >= 3 && (ccSupported === null || ccSupported === void 0 ? void 0 : ccSupported.supportsSlowRefresh)) {
                this.driver.controllerLog.logNode(node.id, {
                    endpoint: this.endpointIndex,
                    message: "Enabling slow refresh capability...",
                    direction: "outbound",
                });
                await api.setConfiguration(true);
            }
        }
        // Remember that the interview is complete
        this.interviewComplete = true;
    }
};
CentralSceneCC = __decorate([
    CommandClass_1.commandClass(core_1.CommandClasses["Central Scene"]),
    CommandClass_1.implementedVersion(3)
], CentralSceneCC);
exports.CentralSceneCC = CentralSceneCC;
let CentralSceneCCNotification = class CentralSceneCCNotification extends CentralSceneCC {
    constructor(driver, options) {
        super(driver, options);
        core_1.validatePayload(this.payload.length >= 3);
        this._sequenceNumber = this.payload[0];
        this._keyAttribute = this.payload[1] & 0b111;
        this._sceneNumber = this.payload[2];
        if (this._keyAttribute === CentralSceneKeys.KeyHeldDown) {
            // A receiving node MUST ignore this field if the command is not
            // carrying the Key Held Down key attribute.
            this._slowRefresh = !!(this.payload[1] & 128);
        }
        // The described behavior is pretty complicated, so we cannot just store
        // the value and call it a day. Handling of these notifications will
        // happen in the receiving node class
        // In case the interview is not yet completed, we still create some basic metadata
        const valueId = getSceneValueId(this._sceneNumber);
        const valueDB = this.getValueDB();
        if (!valueDB.hasMetadata(valueId)) {
            this.getValueDB().setMetadata(valueId, {
                ...core_1.ValueMetadata.ReadOnlyUInt8,
                label: getSceneLabel(this._sceneNumber),
            });
        }
    }
    get sequenceNumber() {
        return this._sequenceNumber;
    }
    get keyAttribute() {
        return this._keyAttribute;
    }
    get sceneNumber() {
        return this._sceneNumber;
    }
    get slowRefresh() {
        return this._slowRefresh;
    }
    toLogEntry() {
        const message = {
            "sequence number": this.sequenceNumber,
            "key attribute": shared_1.getEnumMemberName(CentralSceneKeys, this.keyAttribute),
            "scene number": this.sceneNumber,
        };
        if (this.slowRefresh != undefined) {
            message["slow refresh"] = this.slowRefresh;
        }
        return {
            ...super.toLogEntry(),
            message,
        };
    }
};
CentralSceneCCNotification = __decorate([
    CommandClass_1.CCCommand(CentralSceneCommand.Notification)
], CentralSceneCCNotification);
exports.CentralSceneCCNotification = CentralSceneCCNotification;
let CentralSceneCCSupportedReport = class CentralSceneCCSupportedReport extends CentralSceneCC {
    constructor(driver, options) {
        super(driver, options);
        this._supportedKeyAttributes = new Map();
        core_1.validatePayload(this.payload.length >= 2);
        this._sceneCount = this.payload[0];
        this._supportsSlowRefresh = !!(this.payload[1] & 128);
        const bitMaskBytes = (this.payload[1] & 0b110) >>> 1;
        const identicalKeyAttributes = !!(this.payload[1] & 0b1);
        const numEntries = identicalKeyAttributes ? 1 : this.sceneCount;
        core_1.validatePayload(this.payload.length >= 2 + bitMaskBytes * numEntries);
        for (let i = 0; i < numEntries; i++) {
            const mask = this.payload.slice(2 + i * bitMaskBytes, 2 + (i + 1) * bitMaskBytes);
            this._supportedKeyAttributes.set(i + 1, core_1.parseBitMask(mask, CentralSceneKeys.KeyPressed));
        }
        if (identicalKeyAttributes) {
            // The key attributes are only transmitted for scene 1, copy them to the others
            for (let i = 2; i <= this._sceneCount; i++) {
                this._supportedKeyAttributes.set(i, this._supportedKeyAttributes.get(1));
            }
        }
        // Create metadata for all scenes
        for (let i = 1; i <= this._sceneCount; i++) {
            const valueId = getSceneValueId(i);
            this.getValueDB().setMetadata(valueId, {
                ...core_1.ValueMetadata.ReadOnlyUInt8,
                label: getSceneLabel(i),
                states: core_1.enumValuesToMetadataStates(CentralSceneKeys, this._supportedKeyAttributes.get(i)),
            });
        }
        this.persistValues();
    }
    get sceneCount() {
        return this._sceneCount;
    }
    get supportsSlowRefresh() {
        return this._supportsSlowRefresh;
    }
    get supportedKeyAttributes() {
        return this._supportedKeyAttributes;
    }
    toLogEntry() {
        const message = {
            "scene count": this.sceneCount,
            "supports slow refresh": this.supportsSlowRefresh,
        };
        for (const [scene, keys] of this.supportedKeyAttributes) {
            message[`supported attributes (scene #${scene})`] = keys
                .map((k) => `\n· ${shared_1.getEnumMemberName(CentralSceneKeys, k)}`)
                .join("");
        }
        return {
            ...super.toLogEntry(),
            message,
        };
    }
};
__decorate([
    CommandClass_1.ccValue({ internal: true })
], CentralSceneCCSupportedReport.prototype, "sceneCount", null);
__decorate([
    CommandClass_1.ccValue({ internal: true })
], CentralSceneCCSupportedReport.prototype, "supportsSlowRefresh", null);
__decorate([
    CommandClass_1.ccValue({ internal: true })
], CentralSceneCCSupportedReport.prototype, "supportedKeyAttributes", null);
CentralSceneCCSupportedReport = __decorate([
    CommandClass_1.CCCommand(CentralSceneCommand.SupportedReport)
], CentralSceneCCSupportedReport);
exports.CentralSceneCCSupportedReport = CentralSceneCCSupportedReport;
let CentralSceneCCSupportedGet = class CentralSceneCCSupportedGet extends CentralSceneCC {
};
CentralSceneCCSupportedGet = __decorate([
    CommandClass_1.CCCommand(CentralSceneCommand.SupportedGet),
    CommandClass_1.expectedCCResponse(CentralSceneCCSupportedReport)
], CentralSceneCCSupportedGet);
exports.CentralSceneCCSupportedGet = CentralSceneCCSupportedGet;
let CentralSceneCCConfigurationReport = class CentralSceneCCConfigurationReport extends CentralSceneCC {
    constructor(driver, options) {
        super(driver, options);
        core_1.validatePayload(this.payload.length >= 1);
        this._slowRefresh = !!(this.payload[0] & 128);
        this.persistValues();
    }
    get slowRefresh() {
        return this._slowRefresh;
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: { "slow refresh": this._slowRefresh },
        };
    }
};
__decorate([
    CommandClass_1.ccValue(),
    CommandClass_1.ccValueMetadata({
        ...core_1.ValueMetadata.Boolean,
        label: "Send held down notifications at a slow rate",
        description: "When this is true, KeyHeldDown notifications are sent every 55s. " +
            "When this is false, the notifications are sent every 200ms.",
    })
], CentralSceneCCConfigurationReport.prototype, "slowRefresh", null);
CentralSceneCCConfigurationReport = __decorate([
    CommandClass_1.CCCommand(CentralSceneCommand.ConfigurationReport)
], CentralSceneCCConfigurationReport);
exports.CentralSceneCCConfigurationReport = CentralSceneCCConfigurationReport;
let CentralSceneCCConfigurationGet = class CentralSceneCCConfigurationGet extends CentralSceneCC {
};
CentralSceneCCConfigurationGet = __decorate([
    CommandClass_1.CCCommand(CentralSceneCommand.ConfigurationGet),
    CommandClass_1.expectedCCResponse(CentralSceneCCConfigurationReport)
], CentralSceneCCConfigurationGet);
exports.CentralSceneCCConfigurationGet = CentralSceneCCConfigurationGet;
let CentralSceneCCConfigurationSet = class CentralSceneCCConfigurationSet extends CentralSceneCC {
    constructor(driver, options) {
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            throw new core_1.ZWaveError(`${this.constructor.name}: deserialization not implemented`, core_1.ZWaveErrorCodes.Deserialization_NotImplemented);
        }
        else {
            this.slowRefresh = options.slowRefresh;
        }
    }
    serialize() {
        this.payload = Buffer.from([this.slowRefresh ? 128 : 0]);
        return super.serialize();
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: { "slow refresh": this.slowRefresh },
        };
    }
};
CentralSceneCCConfigurationSet = __decorate([
    CommandClass_1.CCCommand(CentralSceneCommand.ConfigurationSet)
], CentralSceneCCConfigurationSet);
exports.CentralSceneCCConfigurationSet = CentralSceneCCConfigurationSet;

//# sourceMappingURL=CentralSceneCC.js.map
