"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FirmwareUpdateMetaDataCCPrepareGet = exports.FirmwareUpdateMetaDataCCPrepareReport = exports.FirmwareUpdateMetaDataCCActivationSet = exports.FirmwareUpdateMetaDataCCActivationReport = exports.FirmwareUpdateMetaDataCCStatusReport = exports.FirmwareUpdateMetaDataCCReport = exports.FirmwareUpdateMetaDataCCGet = exports.FirmwareUpdateMetaDataCCRequestGet = exports.FirmwareUpdateMetaDataCCRequestReport = exports.FirmwareUpdateMetaDataCCMetaDataGet = exports.FirmwareUpdateMetaDataCCMetaDataReport = exports.FirmwareUpdateMetaDataCC = exports.FirmwareUpdateMetaDataCCAPI = exports.FirmwareDownloadStatus = exports.FirmwareUpdateActivationStatus = exports.FirmwareUpdateStatus = exports.FirmwareUpdateRequestStatus = exports.FirmwareUpdateMetaDataCommand = void 0;
const core_1 = require("@zwave-js/core");
const shared_1 = require("@zwave-js/shared");
const API_1 = require("./API");
const CommandClass_1 = require("./CommandClass");
// All the supported commands
var FirmwareUpdateMetaDataCommand;
(function (FirmwareUpdateMetaDataCommand) {
    FirmwareUpdateMetaDataCommand[FirmwareUpdateMetaDataCommand["MetaDataGet"] = 1] = "MetaDataGet";
    FirmwareUpdateMetaDataCommand[FirmwareUpdateMetaDataCommand["MetaDataReport"] = 2] = "MetaDataReport";
    FirmwareUpdateMetaDataCommand[FirmwareUpdateMetaDataCommand["RequestGet"] = 3] = "RequestGet";
    FirmwareUpdateMetaDataCommand[FirmwareUpdateMetaDataCommand["RequestReport"] = 4] = "RequestReport";
    FirmwareUpdateMetaDataCommand[FirmwareUpdateMetaDataCommand["Get"] = 5] = "Get";
    FirmwareUpdateMetaDataCommand[FirmwareUpdateMetaDataCommand["Report"] = 6] = "Report";
    FirmwareUpdateMetaDataCommand[FirmwareUpdateMetaDataCommand["StatusReport"] = 7] = "StatusReport";
    FirmwareUpdateMetaDataCommand[FirmwareUpdateMetaDataCommand["ActivationSet"] = 8] = "ActivationSet";
    FirmwareUpdateMetaDataCommand[FirmwareUpdateMetaDataCommand["ActivationReport"] = 9] = "ActivationReport";
    FirmwareUpdateMetaDataCommand[FirmwareUpdateMetaDataCommand["PrepareGet"] = 10] = "PrepareGet";
    FirmwareUpdateMetaDataCommand[FirmwareUpdateMetaDataCommand["PrepareReport"] = 11] = "PrepareReport";
})(FirmwareUpdateMetaDataCommand = exports.FirmwareUpdateMetaDataCommand || (exports.FirmwareUpdateMetaDataCommand = {}));
// @noSetValueAPI There are no values to set here
// @noInterview   The "interview" is part of the update process
// @publicAPI
var FirmwareUpdateRequestStatus;
(function (FirmwareUpdateRequestStatus) {
    FirmwareUpdateRequestStatus[FirmwareUpdateRequestStatus["Error_InvalidManufacturerOrFirmwareID"] = 0] = "Error_InvalidManufacturerOrFirmwareID";
    FirmwareUpdateRequestStatus[FirmwareUpdateRequestStatus["Error_AuthenticationExpected"] = 1] = "Error_AuthenticationExpected";
    FirmwareUpdateRequestStatus[FirmwareUpdateRequestStatus["Error_FragmentSizeTooLarge"] = 2] = "Error_FragmentSizeTooLarge";
    FirmwareUpdateRequestStatus[FirmwareUpdateRequestStatus["Error_NotUpgradable"] = 3] = "Error_NotUpgradable";
    FirmwareUpdateRequestStatus[FirmwareUpdateRequestStatus["Error_InvalidHardwareVersion"] = 4] = "Error_InvalidHardwareVersion";
    FirmwareUpdateRequestStatus[FirmwareUpdateRequestStatus["Error_FirmwareUpgradeInProgress"] = 5] = "Error_FirmwareUpgradeInProgress";
    FirmwareUpdateRequestStatus[FirmwareUpdateRequestStatus["Error_BatteryLow"] = 6] = "Error_BatteryLow";
    FirmwareUpdateRequestStatus[FirmwareUpdateRequestStatus["OK"] = 255] = "OK";
})(FirmwareUpdateRequestStatus = exports.FirmwareUpdateRequestStatus || (exports.FirmwareUpdateRequestStatus = {}));
// @publicAPI
var FirmwareUpdateStatus;
(function (FirmwareUpdateStatus) {
    // Error_Timeout is not part of the Z-Wave standard, but we use it to report
    // that no status report was received
    FirmwareUpdateStatus[FirmwareUpdateStatus["Error_Timeout"] = -1] = "Error_Timeout";
    FirmwareUpdateStatus[FirmwareUpdateStatus["Error_Checksum"] = 0] = "Error_Checksum";
    FirmwareUpdateStatus[FirmwareUpdateStatus["Error_TransmissionFailed"] = 1] = "Error_TransmissionFailed";
    FirmwareUpdateStatus[FirmwareUpdateStatus["Error_InvalidManufacturerID"] = 2] = "Error_InvalidManufacturerID";
    FirmwareUpdateStatus[FirmwareUpdateStatus["Error_InvalidFirmwareID"] = 3] = "Error_InvalidFirmwareID";
    FirmwareUpdateStatus[FirmwareUpdateStatus["Error_InvalidFirmwareTarget"] = 4] = "Error_InvalidFirmwareTarget";
    FirmwareUpdateStatus[FirmwareUpdateStatus["Error_InvalidHeaderInformation"] = 5] = "Error_InvalidHeaderInformation";
    FirmwareUpdateStatus[FirmwareUpdateStatus["Error_InvalidHeaderFormat"] = 6] = "Error_InvalidHeaderFormat";
    FirmwareUpdateStatus[FirmwareUpdateStatus["Error_InsufficientMemory"] = 7] = "Error_InsufficientMemory";
    FirmwareUpdateStatus[FirmwareUpdateStatus["Error_InvalidHardwareVersion"] = 8] = "Error_InvalidHardwareVersion";
    // When adding more OK statuses, change the check in Node::finishFirmwareUpdate
    FirmwareUpdateStatus[FirmwareUpdateStatus["OK_WaitingForActivation"] = 253] = "OK_WaitingForActivation";
    FirmwareUpdateStatus[FirmwareUpdateStatus["OK_NoRestart"] = 254] = "OK_NoRestart";
    FirmwareUpdateStatus[FirmwareUpdateStatus["OK_RestartPending"] = 255] = "OK_RestartPending";
})(FirmwareUpdateStatus = exports.FirmwareUpdateStatus || (exports.FirmwareUpdateStatus = {}));
// @publicAPI
var FirmwareUpdateActivationStatus;
(function (FirmwareUpdateActivationStatus) {
    FirmwareUpdateActivationStatus[FirmwareUpdateActivationStatus["Error_InvalidFirmware"] = 0] = "Error_InvalidFirmware";
    FirmwareUpdateActivationStatus[FirmwareUpdateActivationStatus["Error_ActivationFailed"] = 1] = "Error_ActivationFailed";
    FirmwareUpdateActivationStatus[FirmwareUpdateActivationStatus["OK"] = 255] = "OK";
})(FirmwareUpdateActivationStatus = exports.FirmwareUpdateActivationStatus || (exports.FirmwareUpdateActivationStatus = {}));
// @publicAPI
var FirmwareDownloadStatus;
(function (FirmwareDownloadStatus) {
    FirmwareDownloadStatus[FirmwareDownloadStatus["Error_InvalidManufacturerOrFirmwareID"] = 0] = "Error_InvalidManufacturerOrFirmwareID";
    FirmwareDownloadStatus[FirmwareDownloadStatus["Error_AuthenticationExpected"] = 1] = "Error_AuthenticationExpected";
    FirmwareDownloadStatus[FirmwareDownloadStatus["Error_FragmentSizeTooLarge"] = 2] = "Error_FragmentSizeTooLarge";
    FirmwareDownloadStatus[FirmwareDownloadStatus["Error_NotDownloadable"] = 3] = "Error_NotDownloadable";
    FirmwareDownloadStatus[FirmwareDownloadStatus["Error_InvalidHardwareVersion"] = 4] = "Error_InvalidHardwareVersion";
    FirmwareDownloadStatus[FirmwareDownloadStatus["OK"] = 255] = "OK";
})(FirmwareDownloadStatus = exports.FirmwareDownloadStatus || (exports.FirmwareDownloadStatus = {}));
function getSupportsActivationValueId() {
    return {
        commandClass: core_1.CommandClasses["Firmware Update Meta Data"],
        property: "supportsActivation",
    };
}
let FirmwareUpdateMetaDataCCAPI = class FirmwareUpdateMetaDataCCAPI extends API_1.PhysicalCCAPI {
    supportsCommand(cmd) {
        var _a;
        switch (cmd) {
            case FirmwareUpdateMetaDataCommand.MetaDataGet:
            case FirmwareUpdateMetaDataCommand.RequestGet:
            case FirmwareUpdateMetaDataCommand.Report:
            case FirmwareUpdateMetaDataCommand.StatusReport:
                return true;
            case FirmwareUpdateMetaDataCommand.ActivationSet:
                return (this.version >= 4 &&
                    (this.version < 7 ||
                        ((_a = this.endpoint
                            .getNodeUnsafe()) === null || _a === void 0 ? void 0 : _a.getValue(getSupportsActivationValueId())) === true));
            case FirmwareUpdateMetaDataCommand.PrepareGet:
                return this.version >= 5;
        }
        return super.supportsCommand(cmd);
    }
    /**
     * Requests information about the current firmware on the device
     */
    // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
    async getMetaData() {
        this.assertSupportsCommand(FirmwareUpdateMetaDataCommand, FirmwareUpdateMetaDataCommand.MetaDataGet);
        const cc = new FirmwareUpdateMetaDataCCMetaDataGet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
        });
        const response = await this.driver.sendCommand(cc, this.commandOptions);
        if (response) {
            return shared_1.pick(response, [
                "manufacturerId",
                "firmwareId",
                "checksum",
                "firmwareUpgradable",
                "maxFragmentSize",
                "additionalFirmwareIDs",
                "hardwareVersion",
                "continuesToFunction",
                "supportsActivation",
            ]);
        }
    }
    /**
     * Requests the device to start the firmware update process.
     * WARNING: This method may wait up to 60 seconds for a reply.
     */
    async requestUpdate(options) {
        this.assertSupportsCommand(FirmwareUpdateMetaDataCommand, FirmwareUpdateMetaDataCommand.RequestGet);
        const cc = new FirmwareUpdateMetaDataCCRequestGet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
            ...options,
        });
        // Since the response may take longer than with other commands,
        // we do not use the built-in waiting functionality, which would block
        // all other communication
        await this.driver.sendCommand(cc, this.commandOptions);
        const { status, } = await this.driver.waitForCommand((cc) => cc instanceof FirmwareUpdateMetaDataCCRequestReport &&
            cc.nodeId === this.endpoint.nodeId, 60000);
        return status;
    }
    /**
     * Sends a fragment of the new firmware to the device
     */
    async sendFirmwareFragment(fragmentNumber, isLastFragment, data) {
        this.assertSupportsCommand(FirmwareUpdateMetaDataCommand, FirmwareUpdateMetaDataCommand.Report);
        const cc = new FirmwareUpdateMetaDataCCReport(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
            reportNumber: fragmentNumber,
            isLast: isLastFragment,
            firmwareData: data,
        });
        await this.driver.sendCommand(cc, this.commandOptions);
    }
};
FirmwareUpdateMetaDataCCAPI = __decorate([
    CommandClass_1.API(core_1.CommandClasses["Firmware Update Meta Data"])
], FirmwareUpdateMetaDataCCAPI);
exports.FirmwareUpdateMetaDataCCAPI = FirmwareUpdateMetaDataCCAPI;
let FirmwareUpdateMetaDataCC = class FirmwareUpdateMetaDataCC extends CommandClass_1.CommandClass {
};
FirmwareUpdateMetaDataCC = __decorate([
    CommandClass_1.commandClass(core_1.CommandClasses["Firmware Update Meta Data"]),
    CommandClass_1.implementedVersion(7)
], FirmwareUpdateMetaDataCC);
exports.FirmwareUpdateMetaDataCC = FirmwareUpdateMetaDataCC;
let FirmwareUpdateMetaDataCCMetaDataReport = class FirmwareUpdateMetaDataCCMetaDataReport extends FirmwareUpdateMetaDataCC {
    constructor(driver, options) {
        super(driver, options);
        this.additionalFirmwareIDs = [];
        this.continuesToFunction = core_1.unknownBoolean;
        this.supportsActivation = core_1.unknownBoolean;
        core_1.validatePayload(this.payload.length >= 6);
        this.manufacturerId = this.payload.readUInt16BE(0);
        this.firmwareId = this.payload.readUInt16BE(2);
        this.checksum = this.payload.readUInt16BE(4);
        // V1/V2 only have a single firmware which must be upgradable
        this.firmwareUpgradable =
            this.payload[6] === 0xff || this.payload[6] == undefined;
        if (this.version >= 3 && this.payload.length >= 10) {
            this.maxFragmentSize = this.payload.readUInt16BE(8);
            // Read variable length list of additional firmwares
            const numAdditionalFirmwares = this.payload[7];
            const additionalFirmwareIDs = [];
            core_1.validatePayload(this.payload.length >= 10 + 2 * numAdditionalFirmwares);
            for (let i = 0; i < numAdditionalFirmwares; i++) {
                additionalFirmwareIDs.push(this.payload.readUInt16BE(10 + 2 * i));
            }
            this.additionalFirmwareIDs = additionalFirmwareIDs;
            // Read hardware version (if it exists)
            let offset = 10 + 2 * numAdditionalFirmwares;
            if (this.version >= 5 && this.payload.length >= offset + 1) {
                this.hardwareVersion = this.payload[offset];
                offset++;
                if (this.version >= 6 && this.payload.length >= offset + 1) {
                    const capabilities = this.payload[offset];
                    offset++;
                    this.continuesToFunction = !!(capabilities & 0b1);
                    if (this.version >= 7)
                        this.supportsActivation = !!(capabilities & 0b10);
                }
            }
        }
        this.persistValues();
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                "manufacturer id": this.manufacturerId,
                "firmware id": this.firmwareId,
                checksum: this.checksum,
                "firmware upgradable": this.firmwareUpgradable,
                "max fragment size": this.maxFragmentSize,
                "additional firmware IDs": JSON.stringify(this.additionalFirmwareIDs),
                "hardware version": this.hardwareVersion,
                "continues to function": this.continuesToFunction,
                "supports activation": this.supportsActivation,
            },
        };
    }
};
__decorate([
    CommandClass_1.ccValue({ internal: true })
], FirmwareUpdateMetaDataCCMetaDataReport.prototype, "continuesToFunction", void 0);
__decorate([
    CommandClass_1.ccValue({ internal: true })
], FirmwareUpdateMetaDataCCMetaDataReport.prototype, "supportsActivation", void 0);
FirmwareUpdateMetaDataCCMetaDataReport = __decorate([
    CommandClass_1.CCCommand(FirmwareUpdateMetaDataCommand.MetaDataReport)
], FirmwareUpdateMetaDataCCMetaDataReport);
exports.FirmwareUpdateMetaDataCCMetaDataReport = FirmwareUpdateMetaDataCCMetaDataReport;
let FirmwareUpdateMetaDataCCMetaDataGet = class FirmwareUpdateMetaDataCCMetaDataGet extends FirmwareUpdateMetaDataCC {
};
FirmwareUpdateMetaDataCCMetaDataGet = __decorate([
    CommandClass_1.CCCommand(FirmwareUpdateMetaDataCommand.MetaDataGet),
    CommandClass_1.expectedCCResponse(FirmwareUpdateMetaDataCCMetaDataReport)
], FirmwareUpdateMetaDataCCMetaDataGet);
exports.FirmwareUpdateMetaDataCCMetaDataGet = FirmwareUpdateMetaDataCCMetaDataGet;
let FirmwareUpdateMetaDataCCRequestReport = class FirmwareUpdateMetaDataCCRequestReport extends FirmwareUpdateMetaDataCC {
    constructor(driver, options) {
        super(driver, options);
        core_1.validatePayload(this.payload.length >= 1);
        this.status = this.payload[0];
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                status: shared_1.getEnumMemberName(FirmwareUpdateRequestStatus, this.status),
            },
        };
    }
};
FirmwareUpdateMetaDataCCRequestReport = __decorate([
    CommandClass_1.CCCommand(FirmwareUpdateMetaDataCommand.RequestReport)
], FirmwareUpdateMetaDataCCRequestReport);
exports.FirmwareUpdateMetaDataCCRequestReport = FirmwareUpdateMetaDataCCRequestReport;
let FirmwareUpdateMetaDataCCRequestGet = 
// This would expect a FirmwareUpdateMetaDataCCRequestReport, but the response may take
// a while to come. We don't want to block communication, so we don't expect a response here
class FirmwareUpdateMetaDataCCRequestGet extends FirmwareUpdateMetaDataCC {
    constructor(driver, options) {
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            // TODO: Deserialize payload
            throw new core_1.ZWaveError(`${this.constructor.name}: deserialization not implemented`, core_1.ZWaveErrorCodes.Deserialization_NotImplemented);
        }
        else {
            this.manufacturerId = options.manufacturerId;
            this.firmwareId = options.firmwareId;
            this.checksum = options.checksum;
            if ("firmwareTarget" in options) {
                this.firmwareTarget = options.firmwareTarget;
                this.fragmentSize = options.fragmentSize;
                this.activation = options.activation;
                this.hardwareVersion = options.hardwareVersion;
            }
        }
    }
    serialize() {
        const isV3 = this.version >= 3 &&
            this.firmwareTarget != undefined &&
            this.fragmentSize != undefined;
        const isV4 = isV3 && this.version >= 4 && this.activation != undefined;
        const isV5 = isV4 && this.version >= 5 && this.hardwareVersion != undefined;
        this.payload = Buffer.allocUnsafe(6 + (isV3 ? 3 : 0) + (isV4 ? 1 : 0) + (isV5 ? 1 : 0));
        this.payload.writeUInt16BE(this.manufacturerId, 0);
        this.payload.writeUInt16BE(this.firmwareId, 2);
        this.payload.writeUInt16BE(this.checksum, 4);
        if (isV3) {
            this.payload[6] = this.firmwareTarget;
            this.payload.writeUInt16BE(this.fragmentSize, 7);
        }
        if (isV4) {
            this.payload[9] = this.activation ? 1 : 0;
        }
        if (isV5) {
            this.payload[10] = this.hardwareVersion;
        }
        return super.serialize();
    }
    toLogEntry() {
        const message = {
            "manufacturer id": shared_1.num2hex(this.manufacturerId),
            "firmware id": shared_1.num2hex(this.firmwareId),
            checksum: shared_1.num2hex(this.checksum),
        };
        if (this.firmwareTarget != undefined) {
            message["firmware target"] = this.firmwareTarget;
        }
        if (this.fragmentSize != undefined) {
            message["fragment size"] = this.fragmentSize;
        }
        if (this.activation != undefined) {
            message.activation = this.activation;
        }
        if (this.hardwareVersion != undefined) {
            message["hardware version"] = this.hardwareVersion;
        }
        return {
            ...super.toLogEntry(),
            message,
        };
    }
};
FirmwareUpdateMetaDataCCRequestGet = __decorate([
    CommandClass_1.CCCommand(FirmwareUpdateMetaDataCommand.RequestGet)
    // This would expect a FirmwareUpdateMetaDataCCRequestReport, but the response may take
    // a while to come. We don't want to block communication, so we don't expect a response here
], FirmwareUpdateMetaDataCCRequestGet);
exports.FirmwareUpdateMetaDataCCRequestGet = FirmwareUpdateMetaDataCCRequestGet;
let FirmwareUpdateMetaDataCCGet = 
// This is sent to us from the node, so we expect no response
class FirmwareUpdateMetaDataCCGet extends FirmwareUpdateMetaDataCC {
    constructor(driver, options) {
        super(driver, options);
        core_1.validatePayload(this.payload.length >= 3);
        this.numReports = this.payload[0];
        this.reportNumber = this.payload.readUInt16BE(1) & 0x7fff;
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                "total # of reports": this.numReports,
                "report number": this.reportNumber,
            },
        };
    }
};
FirmwareUpdateMetaDataCCGet = __decorate([
    CommandClass_1.CCCommand(FirmwareUpdateMetaDataCommand.Get)
    // This is sent to us from the node, so we expect no response
], FirmwareUpdateMetaDataCCGet);
exports.FirmwareUpdateMetaDataCCGet = FirmwareUpdateMetaDataCCGet;
let FirmwareUpdateMetaDataCCReport = 
// We send this in reply to the Get command and expect no response
class FirmwareUpdateMetaDataCCReport extends FirmwareUpdateMetaDataCC {
    constructor(driver, options) {
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            // TODO: Deserialize payload
            throw new core_1.ZWaveError(`${this.constructor.name}: deserialization not implemented`, core_1.ZWaveErrorCodes.Deserialization_NotImplemented);
        }
        else {
            this.reportNumber = options.reportNumber;
            this.firmwareData = options.firmwareData;
            this.isLast = options.isLast;
        }
    }
    serialize() {
        const commandBuffer = Buffer.concat([
            Buffer.allocUnsafe(2),
            this.firmwareData,
        ]);
        commandBuffer.writeUInt16BE((this.reportNumber & 0x7fff) | (this.isLast ? 0x8000 : 0), 0);
        if (this.version >= 2) {
            // Compute and save the CRC16 in the payload
            // The CC header is included in the CRC computation
            let crc = core_1.CRC16_CCITT(Buffer.from([this.ccId, this.ccCommand]));
            crc = core_1.CRC16_CCITT(commandBuffer, crc);
            this.payload = Buffer.concat([
                commandBuffer,
                Buffer.allocUnsafe(2),
            ]);
            this.payload.writeUInt16BE(crc, this.payload.length - 2);
        }
        else {
            this.payload = commandBuffer;
        }
        return super.serialize();
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                "report #": this.reportNumber,
                "is last": this.isLast,
            },
        };
    }
};
FirmwareUpdateMetaDataCCReport = __decorate([
    CommandClass_1.CCCommand(FirmwareUpdateMetaDataCommand.Report)
    // We send this in reply to the Get command and expect no response
], FirmwareUpdateMetaDataCCReport);
exports.FirmwareUpdateMetaDataCCReport = FirmwareUpdateMetaDataCCReport;
let FirmwareUpdateMetaDataCCStatusReport = class FirmwareUpdateMetaDataCCStatusReport extends FirmwareUpdateMetaDataCC {
    constructor(driver, options) {
        super(driver, options);
        core_1.validatePayload(this.payload.length >= 1);
        this.status = this.payload[0];
        if (this.payload.length >= 3) {
            this.waitTime = this.payload.readUInt16BE(1);
        }
    }
    toLogEntry() {
        const message = {
            status: shared_1.getEnumMemberName(FirmwareUpdateStatus, this.status),
        };
        if (this.waitTime != undefined) {
            message["wait time"] = `${this.waitTime} seconds`;
        }
        return {
            ...super.toLogEntry(),
            message,
        };
    }
};
FirmwareUpdateMetaDataCCStatusReport = __decorate([
    CommandClass_1.CCCommand(FirmwareUpdateMetaDataCommand.StatusReport)
], FirmwareUpdateMetaDataCCStatusReport);
exports.FirmwareUpdateMetaDataCCStatusReport = FirmwareUpdateMetaDataCCStatusReport;
let FirmwareUpdateMetaDataCCActivationReport = class FirmwareUpdateMetaDataCCActivationReport extends FirmwareUpdateMetaDataCC {
    constructor(driver, options) {
        super(driver, options);
        core_1.validatePayload(this.payload.length >= 8);
        this.manufacturerId = this.payload.readUInt16BE(0);
        this.firmwareId = this.payload.readUInt16BE(2);
        this.checksum = this.payload.readUInt16BE(4);
        this.firmwareTarget = this.payload[6];
        this.activationStatus = this.payload[7];
        if (this.version >= 5 && this.payload.length >= 9) {
            this.hardwareVersion = this.payload[8];
        }
    }
    toLogEntry() {
        const message = {
            "manufacturer id": shared_1.num2hex(this.manufacturerId),
            "firmware id": shared_1.num2hex(this.firmwareId),
            checksum: shared_1.num2hex(this.checksum),
            "firmware target": this.firmwareTarget,
            "activation status": shared_1.getEnumMemberName(FirmwareUpdateActivationStatus, this.activationStatus),
        };
        if (this.hardwareVersion != undefined) {
            message.hardwareVersion = this.hardwareVersion;
        }
        return {
            ...super.toLogEntry(),
            message,
        };
    }
};
FirmwareUpdateMetaDataCCActivationReport = __decorate([
    CommandClass_1.CCCommand(FirmwareUpdateMetaDataCommand.ActivationReport)
], FirmwareUpdateMetaDataCCActivationReport);
exports.FirmwareUpdateMetaDataCCActivationReport = FirmwareUpdateMetaDataCCActivationReport;
let FirmwareUpdateMetaDataCCActivationSet = class FirmwareUpdateMetaDataCCActivationSet extends FirmwareUpdateMetaDataCC {
    constructor(driver, options) {
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            // TODO: Deserialize payload
            throw new core_1.ZWaveError(`${this.constructor.name}: deserialization not implemented`, core_1.ZWaveErrorCodes.Deserialization_NotImplemented);
        }
        else {
            this.manufacturerId = options.manufacturerId;
            this.firmwareId = options.firmwareId;
            this.checksum = options.checksum;
            this.firmwareTarget = options.firmwareTarget;
            this.hardwareVersion = options.hardwareVersion;
        }
    }
    serialize() {
        const isV5 = this.version >= 5 && this.hardwareVersion != undefined;
        this.payload = Buffer.allocUnsafe(7 + (isV5 ? 1 : 0));
        this.payload.writeUInt16BE(this.manufacturerId, 0);
        this.payload.writeUInt16BE(this.firmwareId, 2);
        this.payload.writeUInt16BE(this.checksum, 4);
        this.payload[6] = this.firmwareTarget;
        if (isV5) {
            this.payload[7] = this.hardwareVersion;
        }
        return super.serialize();
    }
    toLogEntry() {
        const message = {
            "manufacturer id": shared_1.num2hex(this.manufacturerId),
            "firmware id": shared_1.num2hex(this.firmwareId),
            checksum: shared_1.num2hex(this.checksum),
            "firmware target": this.firmwareTarget,
        };
        if (this.hardwareVersion != undefined) {
            message["hardware version"] = this.hardwareVersion;
        }
        return {
            ...super.toLogEntry(),
            message,
        };
    }
};
FirmwareUpdateMetaDataCCActivationSet = __decorate([
    CommandClass_1.CCCommand(FirmwareUpdateMetaDataCommand.ActivationSet),
    CommandClass_1.expectedCCResponse(FirmwareUpdateMetaDataCCActivationReport)
], FirmwareUpdateMetaDataCCActivationSet);
exports.FirmwareUpdateMetaDataCCActivationSet = FirmwareUpdateMetaDataCCActivationSet;
let FirmwareUpdateMetaDataCCPrepareReport = class FirmwareUpdateMetaDataCCPrepareReport extends FirmwareUpdateMetaDataCC {
    constructor(driver, options) {
        super(driver, options);
        core_1.validatePayload(this.payload.length >= 3);
        this.status = this.payload[0];
        this.checksum = this.payload.readUInt16BE(1);
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                status: shared_1.getEnumMemberName(FirmwareDownloadStatus, this.status),
                checksum: shared_1.num2hex(this.checksum),
            },
        };
    }
};
FirmwareUpdateMetaDataCCPrepareReport = __decorate([
    CommandClass_1.CCCommand(FirmwareUpdateMetaDataCommand.PrepareReport)
], FirmwareUpdateMetaDataCCPrepareReport);
exports.FirmwareUpdateMetaDataCCPrepareReport = FirmwareUpdateMetaDataCCPrepareReport;
let FirmwareUpdateMetaDataCCPrepareGet = class FirmwareUpdateMetaDataCCPrepareGet extends FirmwareUpdateMetaDataCC {
    constructor(driver, options) {
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            // TODO: Deserialize payload
            throw new core_1.ZWaveError(`${this.constructor.name}: deserialization not implemented`, core_1.ZWaveErrorCodes.Deserialization_NotImplemented);
        }
        else {
            this.manufacturerId = options.manufacturerId;
            this.firmwareId = options.firmwareId;
            this.firmwareTarget = options.firmwareTarget;
            this.fragmentSize = options.fragmentSize;
            this.hardwareVersion = options.hardwareVersion;
        }
    }
    serialize() {
        this.payload = Buffer.allocUnsafe(8);
        this.payload.writeUInt16BE(this.manufacturerId, 0);
        this.payload.writeUInt16BE(this.firmwareId, 2);
        this.payload[4] = this.firmwareTarget;
        this.payload.writeUInt16BE(this.fragmentSize, 5);
        this.payload[7] = this.hardwareVersion;
        return super.serialize();
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                "manufacturer id": shared_1.num2hex(this.manufacturerId),
                "firmware id": shared_1.num2hex(this.firmwareId),
                "firmware target": this.firmwareTarget,
                "fragment size": this.fragmentSize,
                "hardware version": this.hardwareVersion,
            },
        };
    }
};
FirmwareUpdateMetaDataCCPrepareGet = __decorate([
    CommandClass_1.CCCommand(FirmwareUpdateMetaDataCommand.PrepareGet),
    CommandClass_1.expectedCCResponse(FirmwareUpdateMetaDataCCReport)
], FirmwareUpdateMetaDataCCPrepareGet);
exports.FirmwareUpdateMetaDataCCPrepareGet = FirmwareUpdateMetaDataCCPrepareGet;

//# sourceMappingURL=FirmwareUpdateMetaDataCC.js.map
