"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ManufacturerProprietaryCC = exports.ManufacturerProprietaryCCAPI = void 0;
const core_1 = require("@zwave-js/core");
const shared_1 = require("@zwave-js/shared");
const typeguards_1 = require("alcalzone-shared/typeguards");
const API_1 = require("./API");
const CommandClass_1 = require("./CommandClass");
const Constants_1 = require("./manufacturerProprietary/Constants");
const ManufacturerSpecificCC_1 = require("./ManufacturerSpecificCC");
let ManufacturerProprietaryCCAPI = class ManufacturerProprietaryCCAPI extends API_1.CCAPI {
    constructor() {
        super(...arguments);
        this[_a] = async ({ property, propertyKey }, value) => {
            // TODO: This is pretty hardcoded, can we make this more flexible?
            if (property !== "fibaro") {
                API_1.throwUnsupportedProperty(this.ccId, property);
            }
            if (propertyKey === "venetianBlindsPosition") {
                if (typeof value !== "number") {
                    API_1.throwWrongValueType(this.ccId, property, "number", typeof value);
                }
                await this.fibaroVenetianBlindsSetPosition(value);
            }
            else if (propertyKey === "venetianBlindsTilt") {
                if (typeof value !== "number") {
                    API_1.throwWrongValueType(this.ccId, property, "number", typeof value);
                }
                await this.fibaroVenetianBlindsSetTilt(value);
            }
            else {
                // unsupported property key, ignore...
                return;
            }
            // Verify the current value after a delay
            this.schedulePoll({ property });
        };
        this[_b] = async ({ property, }) => {
            var _c;
            switch (property) {
                case "position":
                case "tilt":
                    return (_c = (await this.fibaroVenetianBlindsGet())) === null || _c === void 0 ? void 0 : _c[property];
                default:
                    API_1.throwUnsupportedProperty(this.ccId, property);
            }
        };
    }
    async sendData(manufacturerId, data) {
        const cc = new ManufacturerProprietaryCC(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
        });
        cc.manufacturerId = manufacturerId;
        cc.payload = data !== null && data !== void 0 ? data : Buffer.allocUnsafe(0);
        await this.driver.sendCommand(cc, this.commandOptions);
    }
    // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
    async fibaroVenetianBlindsGet() {
        const { FibaroVenetianBlindCCGet, } = require("./manufacturerProprietary/Fibaro");
        const cc = new FibaroVenetianBlindCCGet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
        });
        const response = await this.driver.sendCommand(cc, this.commandOptions);
        if (response) {
            return shared_1.pick(response, ["position", "tilt"]);
        }
    }
    async fibaroVenetianBlindsSetPosition(value) {
        const { FibaroVenetianBlindCCSet, } = require("./manufacturerProprietary/Fibaro");
        const cc = new FibaroVenetianBlindCCSet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
            position: value,
        });
        await this.driver.sendCommand(cc, this.commandOptions);
    }
    async fibaroVenetianBlindsSetTilt(value) {
        const { FibaroVenetianBlindCCSet, } = require("./manufacturerProprietary/Fibaro");
        const cc = new FibaroVenetianBlindCCSet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
            tilt: value,
        });
        await this.driver.sendCommand(cc, this.commandOptions);
    }
};
_a = API_1.SET_VALUE, _b = API_1.POLL_VALUE;
ManufacturerProprietaryCCAPI = __decorate([
    CommandClass_1.API(core_1.CommandClasses["Manufacturer Proprietary"])
], ManufacturerProprietaryCCAPI);
exports.ManufacturerProprietaryCCAPI = ManufacturerProprietaryCCAPI;
let ManufacturerProprietaryCC = 
// TODO: Add a way to specify the expected response
class ManufacturerProprietaryCC extends CommandClass_1.CommandClass {
    // @noCCValues
    constructor(driver, options) {
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            core_1.validatePayload(this.payload.length >= 1);
            // ManufacturerProprietaryCC has no CC command, so the first byte is stored in ccCommand.
            this.manufacturerId =
                (this.ccCommand << 8) +
                    this.payload[0];
            this.payload = this.payload.slice(1);
            // Try to parse the proprietary command
            const PCConstructor = getProprietaryCCConstructor(this.manufacturerId);
            if (PCConstructor &&
                new.target !== PCConstructor &&
                !shared_1.staticExtends(new.target, PCConstructor)) {
                return new PCConstructor(driver, options);
            }
        }
        else {
            this.manufacturerId = this.getValueDB().getValue(ManufacturerSpecificCC_1.getManufacturerIdValueId());
            // To use this CC, a manufacturer ID must exist in the value DB
            // If it doesn't, the interview procedure will throw.
        }
    }
    assertManufacturerIdIsSet() {
        // wotan-disable-next-line
        if (this.manufacturerId == undefined) {
            throw new core_1.ZWaveError(`To use an instance of ManufacturerProprietaryCC, the manufacturer ID must be stored in the value DB`, core_1.ZWaveErrorCodes.ManufacturerProprietaryCC_NoManufacturerId);
        }
    }
    serialize() {
        this.assertManufacturerIdIsSet();
        // ManufacturerProprietaryCC has no CC command, so the first byte
        // is stored in ccCommand
        super.ccCommand = (this.manufacturerId >>> 8) & 0xff;
        // The 2nd byte is in the payload
        this.payload = Buffer.concat([
            Buffer.from([
                // 2nd byte of manufacturerId
                this.manufacturerId & 0xff,
            ]),
            this.payload,
        ]);
        return super.serialize();
    }
    async interview(complete = true) {
        var _c;
        this.assertManufacturerIdIsSet();
        const node = this.getNode();
        // TODO: Can this be refactored?
        const proprietaryConfig = (_c = node.deviceConfig) === null || _c === void 0 ? void 0 : _c.proprietary;
        if (this.manufacturerId === 0x010f /* Fibaro */ &&
            proprietaryConfig &&
            typeguards_1.isArray(proprietaryConfig.fibaroCCs) &&
            proprietaryConfig.fibaroCCs.includes(0x26 /* Venetian Blinds */)) {
            // eslint-disable-next-line @typescript-eslint/no-var-requires
            const FibaroVenetianBlindCC = require("./manufacturerProprietary/Fibaro")
                .FibaroVenetianBlindCC;
            await new FibaroVenetianBlindCC(this.driver, {
                nodeId: this.nodeId,
                endpoint: this.endpointIndex,
            }).interview(complete);
        }
        else {
            this.driver.controllerLog.logNode(node.id, {
                message: `${this.constructor.name}: skipping interview because none of the implemented proprietary CCs are supported...`,
                direction: "none",
            });
        }
        // Remember that the interview is complete
        this.interviewComplete = true;
    }
};
ManufacturerProprietaryCC = __decorate([
    CommandClass_1.commandClass(core_1.CommandClasses["Manufacturer Proprietary"]),
    CommandClass_1.implementedVersion(1)
    // TODO: Add a way to specify the expected response
], ManufacturerProprietaryCC);
exports.ManufacturerProprietaryCC = ManufacturerProprietaryCC;
function getProprietaryCCConstructor(manufacturerId) {
    switch (manufacturerId) {
        case Constants_1.MANUFACTURERID_FIBARO:
            // eslint-disable-next-line @typescript-eslint/no-var-requires
            return require("./manufacturerProprietary/Fibaro").FibaroCC;
    }
}

//# sourceMappingURL=ManufacturerProprietaryCC.js.map
