"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MultiChannelAssociationCCSupportedGroupingsGet = exports.MultiChannelAssociationCCSupportedGroupingsReport = exports.MultiChannelAssociationCCGet = exports.MultiChannelAssociationCCReport = exports.MultiChannelAssociationCCRemove = exports.MultiChannelAssociationCCSet = exports.MultiChannelAssociationCC = exports.MultiChannelAssociationCCAPI = exports.MultiChannelAssociationCommand = exports.getGroupCountValueId = exports.getEndpointsValueId = exports.getNodeIdsValueId = exports.getMaxNodesValueId = void 0;
const core_1 = require("@zwave-js/core");
const shared_1 = require("@zwave-js/shared");
const API_1 = require("./API");
const AssociationCC_1 = require("./AssociationCC");
const CommandClass_1 = require("./CommandClass");
/** Returns the ValueID used to store the maximum number of nodes of an association group */
function getMaxNodesValueId(groupId) {
    return {
        commandClass: core_1.CommandClasses["Multi Channel Association"],
        property: "maxNodes",
        propertyKey: groupId,
    };
}
exports.getMaxNodesValueId = getMaxNodesValueId;
/** Returns the ValueID used to store the node IDs of a multi channel association group */
function getNodeIdsValueId(groupId) {
    return {
        commandClass: core_1.CommandClasses["Multi Channel Association"],
        property: "nodeIds",
        propertyKey: groupId,
    };
}
exports.getNodeIdsValueId = getNodeIdsValueId;
/** Returns the ValueID used to store the endpoint addresses of a multi channel association group */
function getEndpointsValueId(groupId) {
    return {
        commandClass: core_1.CommandClasses["Multi Channel Association"],
        property: "endpoints",
        propertyKey: groupId,
    };
}
exports.getEndpointsValueId = getEndpointsValueId;
/** Returns the ValueID used to store the number of multi channel association group */
function getGroupCountValueId() {
    return {
        commandClass: core_1.CommandClasses["Multi Channel Association"],
        property: "groupCount",
    };
}
exports.getGroupCountValueId = getGroupCountValueId;
function endpointAddressesToString(endpoints) {
    return endpoints
        .map(({ nodeId, endpoint }) => {
        if (typeof endpoint === "number") {
            return `${nodeId}:${endpoint}`;
        }
        else {
            return `${nodeId}:[${endpoint.map(String).join(", ")}]`;
        }
    })
        .join(", ");
}
const MULTI_CHANNEL_ASSOCIATION_MARKER = 0x00;
function serializeMultiChannelAssociationDestination(nodeIds, endpoints) {
    const nodeAddressBytes = nodeIds.length;
    const endpointAddressBytes = endpoints.length * 2;
    const payload = Buffer.allocUnsafe(
    // node addresses
    nodeAddressBytes +
        // endpoint marker
        (endpointAddressBytes > 0 ? 1 : 0) +
        // endpoints
        endpointAddressBytes);
    // write node addresses
    for (let i = 0; i < nodeIds.length; i++) {
        payload[i] = nodeIds[i];
    }
    // write endpoint addresses
    if (endpointAddressBytes > 0) {
        let offset = nodeIds.length;
        payload[offset] = MULTI_CHANNEL_ASSOCIATION_MARKER;
        offset += 1;
        for (let i = 0; i < endpoints.length; i++) {
            const endpoint = endpoints[i];
            const destination = typeof endpoint.endpoint === "number"
                ? // The destination is a single number
                    endpoint.endpoint & 127
                : // The destination is a bit mask
                    core_1.encodeBitMask(endpoint.endpoint, 7)[0] | 128;
            payload[offset + 2 * i] = endpoint.nodeId;
            payload[offset + 2 * i + 1] = destination;
        }
    }
    return payload;
}
function deserializeMultiChannelAssociationDestination(data) {
    const nodeIds = [];
    let endpointOffset = data.length;
    // Scan node ids until we find the marker
    for (let i = 0; i < data.length; i++) {
        if (data[i] === MULTI_CHANNEL_ASSOCIATION_MARKER) {
            endpointOffset = i + 1;
            break;
        }
        nodeIds.push(data[i]);
    }
    const endpoints = [];
    for (let i = endpointOffset; i < data.length; i += 2) {
        const nodeId = data[i];
        const isBitMask = !!(data[i + 1] & 128);
        const destination = data[i + 1] & 127;
        const endpoint = isBitMask
            ? core_1.parseBitMask(Buffer.from([destination]))
            : destination;
        endpoints.push({ nodeId, endpoint });
    }
    return { nodeIds, endpoints };
}
// All the supported commands
var MultiChannelAssociationCommand;
(function (MultiChannelAssociationCommand) {
    MultiChannelAssociationCommand[MultiChannelAssociationCommand["Set"] = 1] = "Set";
    MultiChannelAssociationCommand[MultiChannelAssociationCommand["Get"] = 2] = "Get";
    MultiChannelAssociationCommand[MultiChannelAssociationCommand["Report"] = 3] = "Report";
    MultiChannelAssociationCommand[MultiChannelAssociationCommand["Remove"] = 4] = "Remove";
    MultiChannelAssociationCommand[MultiChannelAssociationCommand["SupportedGroupingsGet"] = 5] = "SupportedGroupingsGet";
    MultiChannelAssociationCommand[MultiChannelAssociationCommand["SupportedGroupingsReport"] = 6] = "SupportedGroupingsReport";
})(MultiChannelAssociationCommand = exports.MultiChannelAssociationCommand || (exports.MultiChannelAssociationCommand = {}));
// @noSetValueAPI
let MultiChannelAssociationCCAPI = class MultiChannelAssociationCCAPI extends API_1.PhysicalCCAPI {
    supportsCommand(cmd) {
        switch (cmd) {
            case MultiChannelAssociationCommand.Get:
            case MultiChannelAssociationCommand.Set:
            case MultiChannelAssociationCommand.Remove:
            case MultiChannelAssociationCommand.SupportedGroupingsGet:
                return true; // This is mandatory
        }
        return super.supportsCommand(cmd);
    }
    /**
     * Returns the number of association groups a node supports.
     * Association groups are consecutive, starting at 1.
     */
    async getGroupCount() {
        this.assertSupportsCommand(MultiChannelAssociationCommand, MultiChannelAssociationCommand.SupportedGroupingsGet);
        const cc = new MultiChannelAssociationCCSupportedGroupingsGet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
        });
        const response = await this.driver.sendCommand(cc, this.commandOptions);
        return response === null || response === void 0 ? void 0 : response.groupCount;
    }
    /**
     * Returns information about an association group.
     */
    // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
    async getGroup(groupId) {
        this.assertSupportsCommand(MultiChannelAssociationCommand, MultiChannelAssociationCommand.Get);
        const cc = new MultiChannelAssociationCCGet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
            groupId,
        });
        const response = await this.driver.sendCommand(cc, this.commandOptions);
        if (response) {
            return shared_1.pick(response, ["maxNodes", "nodeIds", "endpoints"]);
        }
    }
    /**
     * Adds new nodes or endpoints to an association group
     */
    async addDestinations(options) {
        this.assertSupportsCommand(MultiChannelAssociationCommand, MultiChannelAssociationCommand.Set);
        const cc = new MultiChannelAssociationCCSet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
            ...options,
        });
        await this.driver.sendCommand(cc, this.commandOptions);
    }
    /**
     * Removes nodes or endpoints from an association group
     */
    async removeDestinations(options) {
        this.assertSupportsCommand(MultiChannelAssociationCommand, MultiChannelAssociationCommand.Remove);
        if (!options.groupId && this.version === 1) {
            // V1 does not support omitting the group, manually remove the destination from all groups
            // We don't want to do too much work, so find out which groups the destination is in
            const currentDestinations = this.endpoint
                .createCCInstanceInternal(MultiChannelAssociationCC)
                .getAllDestinationsCached();
            for (const [group, destinations] of currentDestinations) {
                const cc = new MultiChannelAssociationCCRemove(this.driver, {
                    nodeId: this.endpoint.nodeId,
                    endpoint: this.endpoint.index,
                    groupId: group,
                    nodeIds: destinations
                        .filter((d) => !d.endpoint)
                        .map((d) => d.nodeId),
                    endpoints: destinations.filter((d) => !!d.endpoint),
                });
                await this.driver.sendCommand(cc, this.commandOptions);
            }
        }
        else {
            const cc = new MultiChannelAssociationCCRemove(this.driver, {
                nodeId: this.endpoint.nodeId,
                endpoint: this.endpoint.index,
                ...options,
            });
            await this.driver.sendCommand(cc, this.commandOptions);
        }
    }
};
MultiChannelAssociationCCAPI = __decorate([
    CommandClass_1.API(core_1.CommandClasses["Multi Channel Association"])
], MultiChannelAssociationCCAPI);
exports.MultiChannelAssociationCCAPI = MultiChannelAssociationCCAPI;
let MultiChannelAssociationCC = class MultiChannelAssociationCC extends CommandClass_1.CommandClass {
    constructor(driver, options) {
        super(driver, options);
        // Make valueIDs internal
        this.registerValue(getMaxNodesValueId(0).property, true);
        this.registerValue(getNodeIdsValueId(0).property, true);
        this.registerValue(getEndpointsValueId(0).property, true);
    }
    determineRequiredCCInterviews() {
        // MultiChannelAssociationCC must be interviewed after Z-Wave+ if that is supported
        return [
            ...super.determineRequiredCCInterviews(),
            core_1.CommandClasses["Z-Wave Plus Info"],
            // AssociationCC will short-circuit if this CC is supported
            core_1.CommandClasses.Association,
        ];
    }
    skipEndpointInterview() {
        // The associations are managed on the root device
        return true;
    }
    /**
     * Returns the number of association groups reported by the node.
     * This only works AFTER the interview process
     */
    getGroupCountCached() {
        return this.getValueDB().getValue(getGroupCountValueId()) || 0;
    }
    /**
     * Returns the number of nodes an association group supports.
     * This only works AFTER the interview process
     */
    getMaxNodesCached(groupId) {
        return this.getValueDB().getValue(getMaxNodesValueId(groupId)) || 0;
    }
    /**
     * Returns all the destinations of all association groups reported by the node.
     * This only works AFTER the interview process
     */
    getAllDestinationsCached() {
        var _a, _b;
        const ret = new Map();
        const groupCount = this.getGroupCountCached();
        const valueDB = this.getValueDB();
        for (let i = 1; i <= groupCount; i++) {
            const groupDestinations = [];
            // Add all node destinations
            const nodes = (_a = valueDB.getValue(getNodeIdsValueId(i))) !== null && _a !== void 0 ? _a : [];
            groupDestinations.push(...nodes.map((nodeId) => ({ nodeId })));
            // And all endpoint destinations
            const endpoints = (_b = valueDB.getValue(getEndpointsValueId(i))) !== null && _b !== void 0 ? _b : [];
            for (const ep of endpoints) {
                if (typeof ep.endpoint === "number") {
                    groupDestinations.push({
                        nodeId: ep.nodeId,
                        endpoint: ep.endpoint,
                    });
                }
                else {
                    groupDestinations.push(...ep.endpoint.map((e) => ({
                        nodeId: ep.nodeId,
                        endpoint: e,
                    })));
                }
            }
            ret.set(i, 
            // Filter out duplicates
            groupDestinations.filter((addr, index) => index ===
                groupDestinations.findIndex(({ nodeId, endpoint }) => nodeId === addr.nodeId &&
                    endpoint === addr.endpoint)));
        }
        return ret;
    }
    async interview(complete = true) {
        var _a, _b, _c, _d, _e;
        const node = this.getNode();
        const endpoint = this.getEndpoint();
        const mcAPI = endpoint.commandClasses["Multi Channel Association"];
        const assocAPI = endpoint.commandClasses.Association;
        this.driver.controllerLog.logNode(node.id, {
            endpoint: this.endpointIndex,
            message: `${this.constructor.name}: doing a ${complete ? "complete" : "partial"} interview...`,
            direction: "none",
        });
        let mcGroupCount;
        if (complete) {
            // First find out how many groups are supported as multi channel
            this.driver.controllerLog.logNode(node.id, {
                endpoint: this.endpointIndex,
                message: "querying number of multi channel association groups...",
                direction: "outbound",
            });
            mcGroupCount = await mcAPI.getGroupCount();
            if (mcGroupCount != undefined) {
                this.driver.controllerLog.logNode(node.id, {
                    endpoint: this.endpointIndex,
                    message: `supports ${mcGroupCount} multi channel association groups`,
                    direction: "inbound",
                });
            }
            else {
                this.driver.controllerLog.logNode(node.id, {
                    endpoint: this.endpointIndex,
                    message: "Querying multi channel association groups timed out, skipping interview...",
                    level: "warn",
                });
                return;
            }
        }
        else {
            // Partial interview, read the information from cache
            mcGroupCount =
                this.getValueDB().getValue(getGroupCountValueId()) || 0;
        }
        // Some devices report more association groups than multi channel association groups, so we need this info here
        const assocGroupCount = this.getValueDB().getValue(AssociationCC_1.getGroupCountValueId()) || mcGroupCount;
        // Then query each multi channel association group
        for (let groupId = 1; groupId <= mcGroupCount; groupId++) {
            this.driver.controllerLog.logNode(node.id, {
                endpoint: this.endpointIndex,
                message: `querying multi channel association group #${groupId}...`,
                direction: "outbound",
            });
            const group = await mcAPI.getGroup(groupId);
            if (!group)
                continue;
            const logMessage = `received information for multi channel association group #${groupId}:
maximum # of nodes:           ${group.maxNodes}
currently assigned nodes:     ${group.nodeIds.map(String).join(", ")}
currently assigned endpoints: ${group.endpoints
                .map(({ nodeId, endpoint }) => {
                if (typeof endpoint === "number") {
                    return `${nodeId}:${endpoint}`;
                }
                else {
                    return `${nodeId}:[${endpoint.map(String).join(", ")}]`;
                }
            })
                .join("")}`;
            this.driver.controllerLog.logNode(node.id, {
                endpoint: this.endpointIndex,
                message: logMessage,
                direction: "inbound",
            });
        }
        // Check if there are more non-multi-channel association groups we haven't queried yet
        if (assocGroupCount > mcGroupCount) {
            this.driver.controllerLog.logNode(node.id, {
                endpoint: this.endpointIndex,
                message: `querying additional non-multi-channel association groups...`,
                direction: "outbound",
            });
            for (let groupId = mcGroupCount + 1; groupId <= assocGroupCount; groupId++) {
                this.driver.controllerLog.logNode(node.id, {
                    endpoint: this.endpointIndex,
                    message: `querying association group #${groupId}...`,
                    direction: "outbound",
                });
                const group = await assocAPI.getGroup(groupId);
                if (!group)
                    continue;
                const logMessage = `received information for association group #${groupId}:
maximum # of nodes:           ${group.maxNodes}
currently assigned nodes:     ${group.nodeIds.map(String).join(", ")}`;
                this.driver.controllerLog.logNode(node.id, {
                    endpoint: this.endpointIndex,
                    message: logMessage,
                    direction: "inbound",
                });
            }
        }
        // Assign the controller to all lifeline groups
        const lifelineGroups = AssociationCC_1.getLifelineGroupIds(node);
        const ownNodeId = this.driver.controller.ownNodeId;
        const valueDB = this.getValueDB();
        // We check if a node supports Multi Channel CC before creating Multi Channel Lifeline Associations (#1109)
        const supportsMultiChannel = node.supportsCC(core_1.CommandClasses["Multi Channel"]);
        if (lifelineGroups.length) {
            for (const group of lifelineGroups) {
                const groupSupportsMultiChannel = group <= mcGroupCount;
                const mustUseNodeAssociation = !supportsMultiChannel || ((_c = (_b = (_a = node.deviceConfig) === null || _a === void 0 ? void 0 : _a.associations) === null || _b === void 0 ? void 0 : _b.get(group)) === null || _c === void 0 ? void 0 : _c.noEndpoint);
                const nodeIdsValueId = groupSupportsMultiChannel
                    ? getNodeIdsValueId(group)
                    : AssociationCC_1.getNodeIdsValueId(group);
                const endpointsValueId = getEndpointsValueId(group);
                const lifelineNodeIds = (_d = this.getValueDB().getValue(nodeIdsValueId)) !== null && _d !== void 0 ? _d : [];
                const lifelineDestinations = (_e = this.getValueDB().getValue(endpointsValueId)) !== null && _e !== void 0 ? _e : [];
                const isAssignedAsNodeAssociation = lifelineNodeIds.includes(ownNodeId);
                const isAssignedAsEndpointAssociation = lifelineDestinations.some((addr) => addr.nodeId === ownNodeId && addr.endpoint === 0);
                let didMCAssignmentWork = true;
                if (!groupSupportsMultiChannel &&
                    !isAssignedAsNodeAssociation) {
                    // Use normal association if this is not a multi channel association group
                    this.driver.controllerLog.logNode(node.id, {
                        endpoint: this.endpointIndex,
                        message: `Lifeline group #${group} does not support multi channel - assigning controller with Association CC...`,
                        direction: "outbound",
                    });
                    await assocAPI.addNodeIds(group, ownNodeId);
                    // refresh the associations - don't trust that it worked
                    await assocAPI.getGroup(group);
                }
                else if ((this.version < 3 || mustUseNodeAssociation) &&
                    !isAssignedAsNodeAssociation) {
                    // Use node id associations for V1 and V2 and if a multi channel lifeline is forbidden
                    this.driver.controllerLog.logNode(node.id, {
                        endpoint: this.endpointIndex,
                        message: `Lifeline group #${group} is configured to use node association - assigning controller...`,
                        direction: "outbound",
                    });
                    // Remove endpoint associations first, we want a node association
                    if (isAssignedAsEndpointAssociation) {
                        await mcAPI.removeDestinations({
                            groupId: group,
                            endpoints: [{ nodeId: ownNodeId, endpoint: 0 }],
                        });
                    }
                    await mcAPI.addDestinations({
                        groupId: group,
                        nodeIds: [ownNodeId],
                    });
                    // refresh the associations - don't trust that it worked
                    const groupReport = await mcAPI.getGroup(group);
                    didMCAssignmentWork = !!(groupReport === null || groupReport === void 0 ? void 0 : groupReport.nodeIds.includes(ownNodeId));
                }
                else if (this.version >= 3 &&
                    !mustUseNodeAssociation &&
                    !isAssignedAsEndpointAssociation) {
                    this.driver.controllerLog.logNode(node.id, {
                        endpoint: this.endpointIndex,
                        message: `Lifeline group #${group}: assigning controller with multi channel association...`,
                        direction: "outbound",
                    });
                    // Starting with V3, the endpoint address must be used
                    // Remove node associations first, we want an endpoint association
                    if (isAssignedAsNodeAssociation) {
                        await mcAPI.removeDestinations({
                            groupId: group,
                            nodeIds: [ownNodeId],
                        });
                    }
                    await mcAPI.addDestinations({
                        groupId: group,
                        endpoints: [{ nodeId: ownNodeId, endpoint: 0 }],
                    });
                    // and refresh the associations - don't trust that it worked
                    const groupReport = await mcAPI.getGroup(group);
                    didMCAssignmentWork = !!(groupReport === null || groupReport === void 0 ? void 0 : groupReport.endpoints.some((a) => a.nodeId === ownNodeId && a.endpoint === 0));
                }
                // Fallback to Association CC if endpoint association didn't work
                if (!didMCAssignmentWork) {
                    this.driver.controllerLog.logNode(node.id, {
                        endpoint: this.endpointIndex,
                        message: `Lifeline group #${group}: Multi Channel Association assignment failed, falling back to Association CC`,
                        direction: "none",
                        level: "warn",
                    });
                    await assocAPI.addNodeIds(group, ownNodeId);
                    // and refresh the associations - don't trust that it worked
                    await assocAPI.getGroup(group);
                }
            }
            // Remember that we have a lifeline association
            valueDB.setValue(AssociationCC_1.getHasLifelineValueId(), true);
        }
        else {
            this.driver.controllerLog.logNode(node.id, {
                endpoint: this.endpointIndex,
                message: "No information about Lifeline associations, cannot assign ourselves!",
                direction: "outbound",
                level: "warn",
            });
            // Remember that we have NO lifeline association
            valueDB.setValue(AssociationCC_1.getHasLifelineValueId(), false);
        }
        // Remember that the interview is complete
        this.interviewComplete = true;
    }
};
MultiChannelAssociationCC = __decorate([
    CommandClass_1.commandClass(core_1.CommandClasses["Multi Channel Association"]),
    CommandClass_1.implementedVersion(4)
], MultiChannelAssociationCC);
exports.MultiChannelAssociationCC = MultiChannelAssociationCC;
let MultiChannelAssociationCCSet = class MultiChannelAssociationCCSet extends MultiChannelAssociationCC {
    constructor(driver, options) {
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            // TODO: Deserialize payload
            throw new core_1.ZWaveError(`${this.constructor.name}: deserialization not implemented`, core_1.ZWaveErrorCodes.Deserialization_NotImplemented);
        }
        else {
            if (options.groupId < 1) {
                throw new core_1.ZWaveError("The group id must be positive!", core_1.ZWaveErrorCodes.Argument_Invalid);
            }
            this.groupId = options.groupId;
            this.nodeIds = ("nodeIds" in options && options.nodeIds) || [];
            if (this.nodeIds.some((n) => n < 1 || n > core_1.MAX_NODES)) {
                throw new core_1.ZWaveError(`All node IDs must be between 1 and ${core_1.MAX_NODES}!`, core_1.ZWaveErrorCodes.Argument_Invalid);
            }
            this.endpoints =
                ("endpoints" in options && options.endpoints) || [];
        }
    }
    serialize() {
        this.payload = Buffer.concat([
            Buffer.from([this.groupId]),
            serializeMultiChannelAssociationDestination(this.nodeIds, this.endpoints),
        ]);
        return super.serialize();
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                "group id": this.groupId,
                "node ids": this.nodeIds.join(", "),
                endpoints: endpointAddressesToString(this.endpoints),
            },
        };
    }
};
MultiChannelAssociationCCSet = __decorate([
    CommandClass_1.CCCommand(MultiChannelAssociationCommand.Set)
], MultiChannelAssociationCCSet);
exports.MultiChannelAssociationCCSet = MultiChannelAssociationCCSet;
let MultiChannelAssociationCCRemove = class MultiChannelAssociationCCRemove extends MultiChannelAssociationCC {
    constructor(driver, options) {
        var _a;
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            // TODO: Deserialize payload
            throw new core_1.ZWaveError(`${this.constructor.name}: deserialization not implemented`, core_1.ZWaveErrorCodes.Deserialization_NotImplemented);
        }
        else {
            // Validate options
            if (!options.groupId) {
                if (this.version === 1) {
                    throw new core_1.ZWaveError(`Node ${this.nodeId} only supports MultiChannelAssociationCC V1 which requires the group Id to be set`, core_1.ZWaveErrorCodes.Argument_Invalid);
                }
            }
            else if (options.groupId < 0) {
                throw new core_1.ZWaveError("The group id must be positive!", core_1.ZWaveErrorCodes.Argument_Invalid);
            }
            if ((_a = options.nodeIds) === null || _a === void 0 ? void 0 : _a.some((n) => n < 1 || n > core_1.MAX_NODES)) {
                throw new core_1.ZWaveError(`All node IDs must be between 1 and ${core_1.MAX_NODES}!`, core_1.ZWaveErrorCodes.Argument_Invalid);
            }
            this.groupId = options.groupId;
            this.nodeIds = options.nodeIds;
            this.endpoints = options.endpoints;
        }
    }
    serialize() {
        this.payload = Buffer.concat([
            Buffer.from([this.groupId || 0]),
            serializeMultiChannelAssociationDestination(this.nodeIds || [], this.endpoints || []),
        ]);
        return super.serialize();
    }
    toLogEntry() {
        const message = { "group id": this.groupId };
        if (this.nodeIds) {
            message["node ids"] = this.nodeIds.join(", ");
        }
        if (this.endpoints) {
            message.endpoints = endpointAddressesToString(this.endpoints);
        }
        return {
            ...super.toLogEntry(),
            message,
        };
    }
};
MultiChannelAssociationCCRemove = __decorate([
    CommandClass_1.CCCommand(MultiChannelAssociationCommand.Remove)
], MultiChannelAssociationCCRemove);
exports.MultiChannelAssociationCCRemove = MultiChannelAssociationCCRemove;
let MultiChannelAssociationCCReport = class MultiChannelAssociationCCReport extends MultiChannelAssociationCC {
    constructor(driver, options) {
        super(driver, options);
        core_1.validatePayload(this.payload.length >= 3);
        this._groupId = this.payload[0];
        this._maxNodes = this.payload[1];
        this._reportsToFollow = this.payload[2];
        ({
            nodeIds: this._nodeIds,
            endpoints: this._endpoints,
        } = deserializeMultiChannelAssociationDestination(this.payload.slice(3)));
    }
    get groupId() {
        return this._groupId;
    }
    get maxNodes() {
        return this._maxNodes;
    }
    get nodeIds() {
        return this._nodeIds;
    }
    get endpoints() {
        return this._endpoints;
    }
    get reportsToFollow() {
        return this._reportsToFollow;
    }
    getPartialCCSessionId() {
        // Distinguish sessions by the association group ID
        return { groupId: this._groupId };
    }
    expectMoreMessages() {
        return this._reportsToFollow > 0;
    }
    mergePartialCCs(partials) {
        // Concat the list of nodes
        this._nodeIds = [...partials, this]
            .map((report) => report._nodeIds)
            .reduce((prev, cur) => prev.concat(...cur), []);
        // Concat the list of endpoints
        this._endpoints = [...partials, this]
            .map((report) => report._endpoints)
            .reduce((prev, cur) => prev.concat(...cur), []);
        // Persist values
        this.getValueDB().setValue(getMaxNodesValueId(this._groupId), this._maxNodes);
        this.getValueDB().setValue(getNodeIdsValueId(this._groupId), this._nodeIds);
        this.getValueDB().setValue(getEndpointsValueId(this._groupId), this._endpoints);
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                "group id": this.groupId,
                "maximum # of nodes": this.maxNodes,
                "node ids": this.nodeIds.join(", "),
                endpoints: endpointAddressesToString(this.endpoints),
            },
        };
    }
};
MultiChannelAssociationCCReport = __decorate([
    CommandClass_1.CCCommand(MultiChannelAssociationCommand.Report)
], MultiChannelAssociationCCReport);
exports.MultiChannelAssociationCCReport = MultiChannelAssociationCCReport;
let MultiChannelAssociationCCGet = class MultiChannelAssociationCCGet extends MultiChannelAssociationCC {
    constructor(driver, options) {
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            // TODO: Deserialize payload
            throw new core_1.ZWaveError(`${this.constructor.name}: deserialization not implemented`, core_1.ZWaveErrorCodes.Deserialization_NotImplemented);
        }
        else {
            if (options.groupId < 1) {
                throw new core_1.ZWaveError("The group id must be positive!", core_1.ZWaveErrorCodes.Argument_Invalid);
            }
            this.groupId = options.groupId;
        }
    }
    serialize() {
        this.payload = Buffer.from([this.groupId]);
        return super.serialize();
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: { "group id": this.groupId },
        };
    }
};
MultiChannelAssociationCCGet = __decorate([
    CommandClass_1.CCCommand(MultiChannelAssociationCommand.Get),
    CommandClass_1.expectedCCResponse(MultiChannelAssociationCCReport)
], MultiChannelAssociationCCGet);
exports.MultiChannelAssociationCCGet = MultiChannelAssociationCCGet;
let MultiChannelAssociationCCSupportedGroupingsReport = class MultiChannelAssociationCCSupportedGroupingsReport extends MultiChannelAssociationCC {
    constructor(driver, options) {
        super(driver, options);
        core_1.validatePayload(this.payload.length >= 1);
        this._groupCount = this.payload[0];
        this.persistValues();
    }
    get groupCount() {
        return this._groupCount;
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: { "group count": this.groupCount },
        };
    }
};
__decorate([
    CommandClass_1.ccValue({ internal: true })
], MultiChannelAssociationCCSupportedGroupingsReport.prototype, "groupCount", null);
MultiChannelAssociationCCSupportedGroupingsReport = __decorate([
    CommandClass_1.CCCommand(MultiChannelAssociationCommand.SupportedGroupingsReport)
], MultiChannelAssociationCCSupportedGroupingsReport);
exports.MultiChannelAssociationCCSupportedGroupingsReport = MultiChannelAssociationCCSupportedGroupingsReport;
let MultiChannelAssociationCCSupportedGroupingsGet = class MultiChannelAssociationCCSupportedGroupingsGet extends MultiChannelAssociationCC {
};
MultiChannelAssociationCCSupportedGroupingsGet = __decorate([
    CommandClass_1.CCCommand(MultiChannelAssociationCommand.SupportedGroupingsGet),
    CommandClass_1.expectedCCResponse(MultiChannelAssociationCCSupportedGroupingsReport)
], MultiChannelAssociationCCSupportedGroupingsGet);
exports.MultiChannelAssociationCCSupportedGroupingsGet = MultiChannelAssociationCCSupportedGroupingsGet;

//# sourceMappingURL=MultiChannelAssociationCC.js.map
