/// <reference types="node" />
import type { Maybe, MessageOrCCLogEntry } from "@zwave-js/core";
import type { Driver } from "../driver/Driver";
import { CCAPI } from "./API";
import { CCCommandOptions, CommandClass, CommandClassDeserializationOptions } from "./CommandClass";
export declare enum MultiCommandCommand {
    CommandEncapsulation = 1
}
export declare class MultiCommandCCAPI extends CCAPI {
    supportsCommand(_cmd: MultiCommandCommand): Maybe<boolean>;
    send(commands: CommandClass[]): Promise<void>;
}
export declare class MultiCommandCC extends CommandClass {
    ccCommand: MultiCommandCommand;
    /** Tests if a command targets a specific endpoint and thus requires encapsulation */
    static requiresEncapsulation(cc: CommandClass): boolean;
    /** Encapsulates a command that targets a specific endpoint */
    static encapsulate(driver: Driver, CCs: CommandClass[]): MultiCommandCCCommandEncapsulation;
}
interface MultiCommandCCCommandEncapsulationOptions extends CCCommandOptions {
    encapsulated: CommandClass[];
}
export declare class MultiCommandCCCommandEncapsulation extends MultiCommandCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | MultiCommandCCCommandEncapsulationOptions);
    encapsulated: CommandClass[];
    serialize(): Buffer;
    toLogEntry(): MessageOrCCLogEntry;
}
export {};
