import type { Maybe, MessageOrCCLogEntry } from "@zwave-js/core";
import type { Driver } from "../driver/Driver";
import { PhysicalCCAPI, PollValueImplementation, POLL_VALUE } from "./API";
import { CommandClass, CommandClassDeserializationOptions } from "./CommandClass";
export declare enum ThermostatOperatingStateCommand {
    Get = 2,
    Report = 3
}
/**
 * @publicAPI
 */
export declare enum ThermostatOperatingState {
    "Idle" = 0,
    "Heating" = 1,
    "Cooling" = 2,
    "Fan Only" = 3,
    "Pending Heat" = 4,
    "Pending Cool" = 5,
    "Vent/Economizer" = 6,
    "Aux Heating" = 7,
    "2nd Stage Heating" = 8,
    "2nd Stage Cooling" = 9,
    "2nd Stage Aux Heat" = 10,
    "3rd Stage Aux Heat" = 11
}
export declare class ThermostatOperatingStateCCAPI extends PhysicalCCAPI {
    supportsCommand(cmd: ThermostatOperatingStateCommand): Maybe<boolean>;
    protected [POLL_VALUE]: PollValueImplementation;
    get(): Promise<ThermostatOperatingState | undefined>;
}
export declare class ThermostatOperatingStateCC extends CommandClass {
    ccCommand: ThermostatOperatingStateCommand;
    interview(complete?: boolean): Promise<void>;
}
export declare class ThermostatOperatingStateCCReport extends ThermostatOperatingStateCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    private _state;
    get state(): ThermostatOperatingState;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class ThermostatOperatingStateCCGet extends ThermostatOperatingStateCC {
}
