"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.GetNodeProtocolInfoResponse = exports.GetNodeProtocolInfoRequest = void 0;
const Constants_1 = require("../message/Constants");
const Message_1 = require("../message/Message");
const DeviceClass_1 = require("../node/DeviceClass");
var NodeCapabilityFlags;
(function (NodeCapabilityFlags) {
    NodeCapabilityFlags[NodeCapabilityFlags["Listening"] = 128] = "Listening";
    NodeCapabilityFlags[NodeCapabilityFlags["Routing"] = 64] = "Routing";
    NodeCapabilityFlags[NodeCapabilityFlags["Baudrate_100k"] = 24] = "Baudrate_100k";
    NodeCapabilityFlags[NodeCapabilityFlags["Baudrate_40k"] = 16] = "Baudrate_40k";
    NodeCapabilityFlags[NodeCapabilityFlags["Baudrate_9k6"] = 8] = "Baudrate_9k6";
    NodeCapabilityFlags[NodeCapabilityFlags["BaudrateMask"] = 56] = "BaudrateMask";
    NodeCapabilityFlags[NodeCapabilityFlags["VersionMask"] = 7] = "VersionMask";
})(NodeCapabilityFlags || (NodeCapabilityFlags = {}));
var SecurityFlags;
(function (SecurityFlags) {
    SecurityFlags[SecurityFlags["Security"] = 1] = "Security";
    SecurityFlags[SecurityFlags["Controller"] = 2] = "Controller";
    SecurityFlags[SecurityFlags["SpecificDevice"] = 4] = "SpecificDevice";
    SecurityFlags[SecurityFlags["RoutingSlave"] = 8] = "RoutingSlave";
    SecurityFlags[SecurityFlags["BeamCapability"] = 16] = "BeamCapability";
    SecurityFlags[SecurityFlags["Sensor250ms"] = 32] = "Sensor250ms";
    SecurityFlags[SecurityFlags["Sensor1000ms"] = 64] = "Sensor1000ms";
    SecurityFlags[SecurityFlags["OptionalFunctionality"] = 128] = "OptionalFunctionality";
})(SecurityFlags || (SecurityFlags = {}));
let GetNodeProtocolInfoRequest = class GetNodeProtocolInfoRequest extends Message_1.Message {
    constructor(driver, options) {
        super(driver, options);
        this.requestedNodeId = options.requestedNodeId;
    }
    serialize() {
        this.payload = Buffer.from([this.requestedNodeId]);
        return super.serialize();
    }
    toJSON() {
        return super.toJSONInherited({
            nodeId: this.requestedNodeId,
        });
    }
};
GetNodeProtocolInfoRequest = __decorate([
    Message_1.messageTypes(Constants_1.MessageType.Request, Constants_1.FunctionType.GetNodeProtocolInfo),
    Message_1.expectedResponse(Constants_1.FunctionType.GetNodeProtocolInfo),
    Message_1.priority(Constants_1.MessagePriority.Controller)
], GetNodeProtocolInfoRequest);
exports.GetNodeProtocolInfoRequest = GetNodeProtocolInfoRequest;
let GetNodeProtocolInfoResponse = class GetNodeProtocolInfoResponse extends Message_1.Message {
    constructor(driver, options) {
        super(driver, options);
        const capabilities = this.payload[0];
        this._isListening =
            (capabilities & NodeCapabilityFlags.Listening) !== 0;
        this._isRouting = (capabilities & NodeCapabilityFlags.Routing) !== 0;
        // This is an educated guess. OZW only checks for the 40k flag
        switch (capabilities & NodeCapabilityFlags.BaudrateMask) {
            case NodeCapabilityFlags.Baudrate_100k:
                this._maxBaudRate = 100000;
                break;
            case NodeCapabilityFlags.Baudrate_40k:
                this._maxBaudRate = 40000;
                break;
            case NodeCapabilityFlags.Baudrate_9k6:
                this._maxBaudRate = 9600;
                break;
            default:
                // We don't know this baudrate yet, encode it as 0
                this._maxBaudRate = 0;
        }
        this._version = (capabilities & NodeCapabilityFlags.VersionMask) + 1;
        const security = this.payload[1];
        this._isSecure = (security & SecurityFlags.Security) !== 0;
        this._isFrequentListening =
            (security &
                (SecurityFlags.Sensor1000ms | SecurityFlags.Sensor250ms)) !==
                0;
        this._isBeaming = (security & SecurityFlags.BeamCapability) !== 0;
        // parse the device class
        const basic = this.payload[3];
        const generic = this.payload[4];
        const specific = this.payload[5];
        this._deviceClass = new DeviceClass_1.DeviceClass(this.driver.configManager, basic, generic, specific);
    }
    get isListening() {
        return this._isListening;
    }
    get isFrequentListening() {
        return this._isFrequentListening;
    }
    get isRouting() {
        return this._isRouting;
    }
    get maxBaudRate() {
        return this._maxBaudRate;
    }
    get isSecure() {
        return this._isSecure;
    }
    get version() {
        return this._version;
    }
    get isBeaming() {
        return this._isBeaming;
    }
    get deviceClass() {
        return this._deviceClass;
    }
    toJSON() {
        return super.toJSONInherited({
            isListening: this.isListening,
            isFrequentListening: this.isFrequentListening,
            isRouting: this.isRouting,
            maxBaudRate: this.maxBaudRate,
            isSecure: this.isSecure,
            version: this.version,
            isBeaming: this.isBeaming,
            deviceClass: this.deviceClass,
        });
    }
};
GetNodeProtocolInfoResponse = __decorate([
    Message_1.messageTypes(Constants_1.MessageType.Response, Constants_1.FunctionType.GetNodeProtocolInfo)
], GetNodeProtocolInfoResponse);
exports.GetNodeProtocolInfoResponse = GetNodeProtocolInfoResponse;

//# sourceMappingURL=GetNodeProtocolInfoMessages.js.map
