import { SortedList } from "alcalzone-shared/sorted-list";
import { Interpreter, StateMachine } from "xstate";
import type { Message } from "../message/Message";
import { SerialAPICommandDoneData, SerialAPICommandMachineParams } from "./SerialAPICommandMachine";
import { ServiceImplementations } from "./StateMachineShared";
import type { Transaction } from "./Transaction";
export interface CommandQueueStateSchema {
    states: {
        idle: {};
        execute: {};
        abortSendData: {};
        executeDone: {};
    };
}
export interface CommandQueueContext {
    queue: SortedList<Transaction>;
    currentTransaction?: Transaction;
}
export declare type CommandQueueEvent = {
    type: "trigger";
} | {
    type: "add";
    transaction: Transaction;
} | {
    type: "message";
    message: Message;
} | {
    type: "reset";
} | {
    type: "command_error";
    error: Error;
} | ({
    type: "command_success";
} & Omit<CommandQueueDoneData & {
    type: "success";
}, "type">) | ({
    type: "command_failure";
} & Omit<CommandQueueDoneData & {
    type: "failure";
}, "type">);
export declare type CommandQueueDoneData = SerialAPICommandDoneData & {
    transaction: Transaction;
};
export declare type CommandQueueMachine = StateMachine<CommandQueueContext, CommandQueueStateSchema, CommandQueueEvent>;
export declare type CommandQueueInterpreter = Interpreter<CommandQueueContext, CommandQueueStateSchema, CommandQueueEvent>;
export declare function createCommandQueueMachine(implementations: ServiceImplementations, params: SerialAPICommandMachineParams): CommandQueueMachine;
