import { DataDirection, ZWaveLogContainer, ZWaveLoggerBase } from "@zwave-js/core";
import type { SortedList } from "alcalzone-shared/sorted-list";
import type { Transaction } from "../driver/Transaction";
import type { Message, ResponseRole } from "../message/Message";
export declare const DRIVER_LABEL = "DRIVER";
export declare class DriverLogger extends ZWaveLoggerBase {
    constructor(loggers: ZWaveLogContainer);
    private _isDriverLogVisible;
    private isDriverLogVisible;
    private _isSendQueueLogVisible;
    private isSendQueueLogVisible;
    /**
     * Logs a message
     * @param msg The message to output
     */
    print(message: string, level?: "debug" | "verbose" | "warn" | "error" | "info"): void;
    /**
     * Serializes a message that starts a transaction, i.e. a message that is sent and may expect a response
     */
    transaction(transaction: Transaction): void;
    /** Logs information about a message that is received as a response to a transaction */
    transactionResponse(message: Message, originalTransaction: Transaction | undefined, role: ResponseRole): void;
    logMessage(message: Message, { nodeId, secondaryTags, direction, }?: {
        nodeId?: number;
        secondaryTags?: string[];
        direction?: DataDirection;
    }): void;
    /** Logs whats currently in the driver's send queue */
    sendQueue(queue: SortedList<Transaction>): void;
}
