"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createEmptyMockDriver = exports.mockDriverDummyCallbackId = exports.MockResponseMessage = exports.MockRequestMessageWithoutExpectation = exports.MockRequestMessageWithExpectation = void 0;
const config_1 = require("@zwave-js/config");
const CommandClass_1 = require("../commandclass/CommandClass");
const SendDataMessages_1 = require("../controller/SendDataMessages");
const Constants_1 = require("../message/Constants");
const Message_1 = require("../message/Message");
const MockRequestMessageWithExpectation_FunctionType = 0xfa;
const MockRequestMessageWithoutExpectation_FunctionType = 0xfb;
const MockResponseMessage_FunctionType = 0xff;
let MockRequestMessageWithExpectation = class MockRequestMessageWithExpectation extends Message_1.Message {
};
MockRequestMessageWithExpectation = __decorate([
    Message_1.messageTypes(Constants_1.MessageType.Request, MockRequestMessageWithExpectation_FunctionType),
    Message_1.expectedResponse(MockResponseMessage_FunctionType),
    Message_1.priority(Constants_1.MessagePriority.Normal)
], MockRequestMessageWithExpectation);
exports.MockRequestMessageWithExpectation = MockRequestMessageWithExpectation;
let MockRequestMessageWithoutExpectation = class MockRequestMessageWithoutExpectation extends Message_1.Message {
};
MockRequestMessageWithoutExpectation = __decorate([
    Message_1.messageTypes(Constants_1.MessageType.Request, MockRequestMessageWithoutExpectation_FunctionType),
    Message_1.priority(Constants_1.MessagePriority.Normal)
], MockRequestMessageWithoutExpectation);
exports.MockRequestMessageWithoutExpectation = MockRequestMessageWithoutExpectation;
let MockResponseMessage = class MockResponseMessage extends Message_1.Message {
};
MockResponseMessage = __decorate([
    Message_1.messageTypes(Constants_1.MessageType.Response, MockResponseMessage_FunctionType)
], MockResponseMessage);
exports.MockResponseMessage = MockResponseMessage;
exports.mockDriverDummyCallbackId = 0xfe;
// eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
function createEmptyMockDriver() {
    const ret = {
        sendMessage: jest.fn().mockImplementation(() => Promise.resolve()),
        sendCommand: jest.fn(),
        saveNetworkToCache: jest
            .fn()
            .mockImplementation(() => Promise.resolve()),
        getSafeCCVersionForNode: jest
            .fn()
            .mockImplementation((ccId, nodeId, endpointIndex = 0) => {
            var _a;
            if (
            // wotan-disable-next-line no-useless-predicate
            ((_a = ret.controller) === null || _a === void 0 ? void 0 : _a.nodes) instanceof Map &&
                ret.controller.nodes.has(nodeId)) {
                const node = ret.controller.nodes.get(nodeId);
                const ccVersion = node
                    .getEndpoint(endpointIndex)
                    .getCCVersion(ccId);
                if (ccVersion > 0)
                    return ccVersion;
            }
            // default to the implemented version
            return CommandClass_1.getImplementedVersion(ccId);
        }),
        getNextCallbackId: jest
            .fn()
            .mockImplementation(() => exports.mockDriverDummyCallbackId),
        controller: {
            nodes: new Map(),
            ownNodeId: 1,
        },
        valueDB: new Map(),
        metadataDB: new Map(),
        options: {
            timeouts: {
                ack: 1000,
                byte: 150,
                response: 1600,
                report: 1600,
                nonce: 5000,
                sendDataCallback: 65000,
            },
            attempts: {
                sendData: 3,
                controller: 3,
            },
        },
        driverLog: new Proxy({}, {
            get() {
                return () => {
                    /* intentionally empty */
                };
            },
        }),
        controllerLog: new Proxy({}, {
            get() {
                return () => {
                    /* intentionally empty */
                };
            },
        }),
        configManager: new config_1.ConfigManager(),
    };
    ret.sendCommand.mockImplementation(async (command, options) => {
        const msg = new SendDataMessages_1.SendDataRequest(ret, {
            command,
        });
        const resp = await ret.sendMessage(msg, options);
        return resp === null || resp === void 0 ? void 0 : resp.command;
    });
    return ret;
}
exports.createEmptyMockDriver = createEmptyMockDriver;

//# sourceMappingURL=mocks.js.map
