/// <reference types="node" />
import type { Maybe, MessageOrCCLogEntry } from "@zwave-js/core";
import type { Driver } from "../driver/Driver";
import { SetbackState } from "../values/SetbackState";
import { Switchpoint } from "../values/Switchpoint";
import { CCAPI } from "./API";
import { Weekday } from "./ClockCC";
import { CCCommandOptions, CommandClass, CommandClassDeserializationOptions } from "./CommandClass";
export declare enum ClimateControlScheduleCommand {
    Set = 1,
    Get = 2,
    Report = 3,
    ChangedGet = 4,
    ChangedReport = 5,
    OverrideSet = 6,
    OverrideGet = 7,
    OverrideReport = 8
}
/**
 * @publicAPI
 */
export declare enum ScheduleOverrideType {
    None = 0,
    Temporary = 1,
    Permanent = 2
}
export declare class ClimateControlScheduleCCAPI extends CCAPI {
    supportsCommand(cmd: ClimateControlScheduleCommand): Maybe<boolean>;
    set(weekday: Weekday, switchPoints: Switchpoint[]): Promise<void>;
    get(weekday: Weekday): Promise<readonly Switchpoint[] | undefined>;
    getChangeCounter(): Promise<number | undefined>;
    getOverride(): Promise<{
        type: ScheduleOverrideType;
        state: SetbackState;
    } | undefined>;
    setOverride(type: ScheduleOverrideType, state: SetbackState): Promise<void>;
}
export declare class ClimateControlScheduleCC extends CommandClass {
    ccCommand: ClimateControlScheduleCommand;
}
interface ClimateControlScheduleCCSetOptions extends CCCommandOptions {
    weekday: Weekday;
    switchPoints: Switchpoint[];
}
export declare class ClimateControlScheduleCCSet extends ClimateControlScheduleCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | ClimateControlScheduleCCSetOptions);
    switchPoints: Switchpoint[];
    weekday: Weekday;
    serialize(): Buffer;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class ClimateControlScheduleCCReport extends ClimateControlScheduleCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    private schedule;
    get switchPoints(): readonly Switchpoint[];
    get weekday(): Weekday;
    toLogEntry(): MessageOrCCLogEntry;
}
interface ClimateControlScheduleCCGetOptions extends CCCommandOptions {
    weekday: Weekday;
}
export declare class ClimateControlScheduleCCGet extends ClimateControlScheduleCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | ClimateControlScheduleCCGetOptions);
    weekday: Weekday;
    serialize(): Buffer;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class ClimateControlScheduleCCChangedReport extends ClimateControlScheduleCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    private _changeCounter;
    get changeCounter(): number;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class ClimateControlScheduleCCChangedGet extends ClimateControlScheduleCC {
}
export declare class ClimateControlScheduleCCOverrideReport extends ClimateControlScheduleCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    private _overrideType;
    get overrideType(): ScheduleOverrideType;
    private _overrideState;
    get overrideState(): SetbackState;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class ClimateControlScheduleCCOverrideGet extends ClimateControlScheduleCC {
}
interface ClimateControlScheduleCCOverrideSetOptions extends CCCommandOptions {
    overrideType: ScheduleOverrideType;
    overrideState: SetbackState;
}
export declare class ClimateControlScheduleCCOverrideSet extends ClimateControlScheduleCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | ClimateControlScheduleCCOverrideSetOptions);
    overrideType: ScheduleOverrideType;
    overrideState: SetbackState;
    serialize(): Buffer;
    toLogEntry(): MessageOrCCLogEntry;
}
export {};
