/// <reference types="node" />
import type { Maybe, MessageOrCCLogEntry } from "@zwave-js/core";
import type { Driver } from "../driver/Driver";
import { CCAPI } from "./API";
import { CCCommandOptions, CommandClass, CommandClassDeserializationOptions } from "./CommandClass";
export declare enum ClockCommand {
    Set = 4,
    Get = 5,
    Report = 6
}
/**
 * @publicAPI
 */
export declare enum Weekday {
    Unknown = 0,
    Monday = 1,
    Tuesday = 2,
    Wednesday = 3,
    Thursday = 4,
    Friday = 5,
    Saturday = 6,
    Sunday = 7
}
export declare class ClockCCAPI extends CCAPI {
    supportsCommand(cmd: ClockCommand): Maybe<boolean>;
    get(): Promise<Pick<ClockCCReport, "weekday" | "hour" | "minute"> | undefined>;
    set(hour: number, minute: number, weekday?: Weekday): Promise<void>;
}
export declare class ClockCC extends CommandClass {
    ccCommand: ClockCommand;
    interview(complete?: boolean): Promise<void>;
}
interface ClockCCSetOptions extends CCCommandOptions {
    weekday: Weekday;
    hour: number;
    minute: number;
}
export declare class ClockCCSet extends ClockCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | ClockCCSetOptions);
    weekday: Weekday;
    hour: number;
    minute: number;
    serialize(): Buffer;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class ClockCCReport extends ClockCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    readonly weekday: Weekday;
    readonly hour: number;
    readonly minute: number;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class ClockCCGet extends ClockCC {
}
export {};
