/// <reference types="node" />
import type { Driver } from "../driver/Driver";
import { CCAPI, PollValueImplementation, POLL_VALUE, SetValueImplementation, SET_VALUE } from "./API";
import { CCCommandOptions, CommandClass, CommandClassDeserializationOptions } from "./CommandClass";
import type { FibaroVenetianBlindCCReport } from "./manufacturerProprietary/Fibaro";
export declare class ManufacturerProprietaryCCAPI extends CCAPI {
    sendData(manufacturerId: number, data?: Buffer): Promise<void>;
    fibaroVenetianBlindsGet(): Promise<Pick<FibaroVenetianBlindCCReport, "position" | "tilt"> | undefined>;
    fibaroVenetianBlindsSetPosition(value: number): Promise<void>;
    fibaroVenetianBlindsSetTilt(value: number): Promise<void>;
    protected [SET_VALUE]: SetValueImplementation;
    protected [POLL_VALUE]: PollValueImplementation;
}
export declare class ManufacturerProprietaryCC extends CommandClass {
    ccCommand: undefined;
    constructor(driver: Driver, options: CommandClassDeserializationOptions | CCCommandOptions);
    manufacturerId: number;
    private assertManufacturerIdIsSet;
    serialize(): Buffer;
    interview(complete?: boolean): Promise<void>;
}
