"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MultilevelSwitchCCSupportedGet = exports.MultilevelSwitchCCSupportedReport = exports.MultilevelSwitchCCStopLevelChange = exports.MultilevelSwitchCCStartLevelChange = exports.MultilevelSwitchCCGet = exports.MultilevelSwitchCCReport = exports.MultilevelSwitchCCSet = exports.MultilevelSwitchCC = exports.MultilevelSwitchCCAPI = exports.SwitchType = exports.LevelChangeDirection = exports.MultilevelSwitchCommand = void 0;
const core_1 = require("@zwave-js/core");
const shared_1 = require("@zwave-js/shared");
const Constants_1 = require("../message/Constants");
const API_1 = require("./API");
const CommandClass_1 = require("./CommandClass");
const SupervisionCC_1 = require("./SupervisionCC");
var MultilevelSwitchCommand;
(function (MultilevelSwitchCommand) {
    MultilevelSwitchCommand[MultilevelSwitchCommand["Set"] = 1] = "Set";
    MultilevelSwitchCommand[MultilevelSwitchCommand["Get"] = 2] = "Get";
    MultilevelSwitchCommand[MultilevelSwitchCommand["Report"] = 3] = "Report";
    MultilevelSwitchCommand[MultilevelSwitchCommand["StartLevelChange"] = 4] = "StartLevelChange";
    MultilevelSwitchCommand[MultilevelSwitchCommand["StopLevelChange"] = 5] = "StopLevelChange";
    MultilevelSwitchCommand[MultilevelSwitchCommand["SupportedGet"] = 6] = "SupportedGet";
    MultilevelSwitchCommand[MultilevelSwitchCommand["SupportedReport"] = 7] = "SupportedReport";
})(MultilevelSwitchCommand = exports.MultilevelSwitchCommand || (exports.MultilevelSwitchCommand = {}));
/**
 * @publicAPI
 */
var LevelChangeDirection;
(function (LevelChangeDirection) {
    LevelChangeDirection[LevelChangeDirection["up"] = 0] = "up";
    LevelChangeDirection[LevelChangeDirection["down"] = 1] = "down";
    // "none" = 0b11,
})(LevelChangeDirection = exports.LevelChangeDirection || (exports.LevelChangeDirection = {}));
/**
 * @publicAPI
 */
var SwitchType;
(function (SwitchType) {
    SwitchType[SwitchType["not supported"] = 0] = "not supported";
    SwitchType[SwitchType["Off/On"] = 1] = "Off/On";
    SwitchType[SwitchType["Down/Up"] = 2] = "Down/Up";
    SwitchType[SwitchType["Close/Open"] = 3] = "Close/Open";
    SwitchType[SwitchType["CCW/CW"] = 4] = "CCW/CW";
    SwitchType[SwitchType["Left/Right"] = 5] = "Left/Right";
    SwitchType[SwitchType["Reverse/Forward"] = 6] = "Reverse/Forward";
    SwitchType[SwitchType["Pull/Push"] = 7] = "Pull/Push";
})(SwitchType = exports.SwitchType || (exports.SwitchType = {}));
/**
 * Translates a switch type into two actions that may be performed. Unknown types default to Down/Up
 */
function switchTypeToActions(switchType) {
    if (!switchType.includes("/"))
        switchType = SwitchType[0x02]; // Down/Up
    return switchType.split("/", 2);
}
const switchTypeProperties = Object.keys(SwitchType)
    .filter((key) => key.indexOf("/") > -1)
    .map((key) => switchTypeToActions(key))
    .reduce((acc, cur) => acc.concat(...cur), []);
function getCurrentValueValueId(endpoint) {
    return {
        commandClass: core_1.CommandClasses["Multilevel Switch"],
        endpoint,
        property: "currentValue",
    };
}
/** Returns the ValueID used to remember whether a node supports supervision on the start/stop level change commands*/
function getSuperviseStartStopLevelChangeValueId() {
    return {
        commandClass: core_1.CommandClasses["Multilevel Switch"],
        property: "superviseStartStopLevelChange",
    };
}
let MultilevelSwitchCCAPI = class MultilevelSwitchCCAPI extends API_1.CCAPI {
    constructor() {
        super(...arguments);
        this[_a] = async ({ property }, value) => {
            var _c, _d, _e;
            if (property === "targetValue") {
                if (typeof value !== "number") {
                    API_1.throwWrongValueType(this.ccId, property, "number", typeof value);
                }
                const completed = await this.set(value);
                // If the command did not fail, assume that it succeeded and update the currentValue accordingly
                // so UIs have immediate feedback
                if (this.isSinglecast() && completed) {
                    const valueDB = (_c = this.endpoint.getNodeUnsafe()) === null || _c === void 0 ? void 0 : _c.valueDB;
                    valueDB === null || valueDB === void 0 ? void 0 : valueDB.setValue(getCurrentValueValueId(this.endpoint.index), value);
                    // Verify the current value after a delay if the node does not support Supervision
                    if (!((_d = this.endpoint
                        .getNodeUnsafe()) === null || _d === void 0 ? void 0 : _d.supportsCC(core_1.CommandClasses.Supervision))) {
                        // TODO: #1321
                        const duration = undefined;
                        this.schedulePoll({ property }, duration === null || duration === void 0 ? void 0 : duration.toMilliseconds());
                    }
                }
            }
            else if (switchTypeProperties.includes(property)) {
                // Since the switch only supports one of the switch types, we would
                // need to check if the correct one is used. But since the names are
                // purely cosmetic, we just accept all of them
                if (typeof value !== "boolean") {
                    API_1.throwWrongValueType(this.ccId, property, "number", typeof value);
                }
                if (value) {
                    // The property names are organized so that positive motions are
                    // at odd indices and negative motions at even indices
                    const direction = switchTypeProperties.indexOf(property) % 2 === 0
                        ? "down"
                        : "up";
                    // Try to retrieve the current value to use as the start level,
                    // even if the target node is going to ignore it. There might
                    // be some bugged devices that ignore the ignore start level flag.
                    const startLevel = (_e = this.endpoint
                        .getNodeUnsafe()) === null || _e === void 0 ? void 0 : _e.getValue(getCurrentValueValueId(this.endpoint.index));
                    // And perform the level change
                    await this.startLevelChange({
                        direction,
                        ignoreStartLevel: true,
                        startLevel,
                    });
                }
                else {
                    await this.stopLevelChange();
                }
            }
            else {
                API_1.throwUnsupportedProperty(this.ccId, property);
            }
        };
        this[_b] = async ({ property, }) => {
            var _c;
            switch (property) {
                case "currentValue":
                case "targetValue":
                case "duration":
                    return (_c = (await this.get())) === null || _c === void 0 ? void 0 : _c[property];
                default:
                    API_1.throwUnsupportedProperty(this.ccId, property);
            }
        };
    }
    supportsCommand(cmd) {
        switch (cmd) {
            case MultilevelSwitchCommand.Get:
                return this.isSinglecast();
            case MultilevelSwitchCommand.Set:
            case MultilevelSwitchCommand.StartLevelChange:
            case MultilevelSwitchCommand.StopLevelChange:
                return true; // This is mandatory
            case MultilevelSwitchCommand.SupportedGet:
                return this.version >= 3 && this.isSinglecast();
        }
        return super.supportsCommand(cmd);
    }
    // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
    async get() {
        this.assertSupportsCommand(MultilevelSwitchCommand, MultilevelSwitchCommand.Get);
        const cc = new MultilevelSwitchCCGet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
        });
        const response = await this.driver.sendCommand(cc, this.commandOptions);
        if (response) {
            return shared_1.pick(response, ["currentValue", "targetValue", "duration"]);
        }
    }
    /**
     * Sets the switch to a new value
     * @param targetValue The new target value for the switch
     * @param duration The optional duration to reach the target value. Available in V2+
     * @returns A promise indicating whether the command was completed
     */
    async set(targetValue, duration) {
        this.assertSupportsCommand(MultilevelSwitchCommand, MultilevelSwitchCommand.Set);
        const cc = new MultilevelSwitchCCSet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
            targetValue,
            duration,
        });
        // Multilevel Switch commands may take some time to be executed.
        // Therefore we try to supervise the command execution
        const supervisionResult = await this.driver.trySendCommandSupervised(cc, {
            requestStatusUpdates: true,
            onUpdate: (status) => {
                if (status === SupervisionCC_1.SupervisionStatus.Working ||
                    status === SupervisionCC_1.SupervisionStatus.Success) {
                    void this.get().catch(() => {
                        /* ignore */
                    });
                }
            },
        });
        return (!supervisionResult ||
            supervisionResult.status === SupervisionCC_1.SupervisionStatus.Success);
    }
    async startLevelChange(options) {
        this.assertSupportsCommand(MultilevelSwitchCommand, MultilevelSwitchCommand.StartLevelChange);
        const cc = new MultilevelSwitchCCStartLevelChange(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
            ...options,
        });
        const superviseValueId = getSuperviseStartStopLevelChangeValueId();
        const node = this.endpoint.getNodeUnsafe();
        // Assume supervision is supported until we know it is not
        let mayUseSupervision = node.getValue(superviseValueId) !== false;
        if (mayUseSupervision) {
            // Try to supervise the command execution
            const supervisionResult = await this.driver.trySendCommandSupervised(cc);
            if ((supervisionResult === null || supervisionResult === void 0 ? void 0 : supervisionResult.status) === SupervisionCC_1.SupervisionStatus.Fail) {
                throw new core_1.ZWaveError("startLevelChange failed", core_1.ZWaveErrorCodes.SupervisionCC_CommandFailed);
            }
            else if ((supervisionResult === null || supervisionResult === void 0 ? void 0 : supervisionResult.status) === SupervisionCC_1.SupervisionStatus.NoSupport) {
                // Remember that we shouldn't use supervision for that
                node.valueDB.setValue(superviseValueId, false);
                mayUseSupervision = false;
            }
        }
        // In order to support a fallback to no supervision, we must not use else-if here
        if (!mayUseSupervision) {
            await this.driver.sendCommand(cc);
        }
    }
    async stopLevelChange() {
        this.assertSupportsCommand(MultilevelSwitchCommand, MultilevelSwitchCommand.StopLevelChange);
        const cc = new MultilevelSwitchCCStopLevelChange(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
        });
        const superviseValueId = getSuperviseStartStopLevelChangeValueId();
        const node = this.endpoint.getNodeUnsafe();
        // Assume supervision is supported until we know it is not
        let mayUseSupervision = node.getValue(superviseValueId) !== false;
        if (mayUseSupervision) {
            // Try to supervise the command execution
            const supervisionResult = await this.driver.trySendCommandSupervised(cc);
            if ((supervisionResult === null || supervisionResult === void 0 ? void 0 : supervisionResult.status) === SupervisionCC_1.SupervisionStatus.Fail) {
                throw new core_1.ZWaveError("stopLevelChange failed", core_1.ZWaveErrorCodes.SupervisionCC_CommandFailed);
            }
            else if ((supervisionResult === null || supervisionResult === void 0 ? void 0 : supervisionResult.status) === SupervisionCC_1.SupervisionStatus.NoSupport) {
                // Remember that we shouldn't use supervision for that
                node.valueDB.setValue(superviseValueId, false);
                mayUseSupervision = false;
            }
        }
        // In order to support a fallback to no supervision, we must not use else-if here
        if (!mayUseSupervision) {
            await this.driver.sendCommand(cc);
        }
    }
    async getSupported() {
        this.assertSupportsCommand(MultilevelSwitchCommand, MultilevelSwitchCommand.SupportedGet);
        const cc = new MultilevelSwitchCCSupportedGet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
        });
        const response = await this.driver.sendCommand(cc, this.commandOptions);
        return response === null || response === void 0 ? void 0 : response.switchType;
    }
};
_a = API_1.SET_VALUE, _b = API_1.POLL_VALUE;
MultilevelSwitchCCAPI = __decorate([
    CommandClass_1.API(core_1.CommandClasses["Multilevel Switch"])
], MultilevelSwitchCCAPI);
exports.MultilevelSwitchCCAPI = MultilevelSwitchCCAPI;
let MultilevelSwitchCC = class MultilevelSwitchCC extends CommandClass_1.CommandClass {
    constructor(driver, options) {
        super(driver, options);
        this.registerValue(getSuperviseStartStopLevelChangeValueId().property, true);
    }
    async interview(complete = true) {
        const node = this.getNode();
        const endpoint = this.getEndpoint();
        const api = endpoint.commandClasses["Multilevel Switch"].withOptions({
            priority: Constants_1.MessagePriority.NodeQuery,
        });
        this.driver.controllerLog.logNode(node.id, {
            endpoint: this.endpointIndex,
            message: `${this.constructor.name}: doing a ${complete ? "complete" : "partial"} interview...`,
            direction: "none",
        });
        if (complete) {
            if (this.version >= 3) {
                // Find out which kind of switch this is
                this.driver.controllerLog.logNode(node.id, {
                    endpoint: this.endpointIndex,
                    message: "requesting switch type...",
                    direction: "outbound",
                });
                const switchType = await api.getSupported();
                if (switchType != undefined) {
                    this.driver.controllerLog.logNode(node.id, {
                        endpoint: this.endpointIndex,
                        message: `has switch type ${shared_1.getEnumMemberName(SwitchType, switchType)}`,
                        direction: "inbound",
                    });
                }
            }
            else {
                // requesting the switch type automatically creates the up/down actions
                // We need to do this manually for V1 and V2
                this.createMetadataForLevelChangeActions();
            }
        }
        this.driver.controllerLog.logNode(node.id, {
            endpoint: this.endpointIndex,
            message: "requesting current switch state...",
            direction: "outbound",
        });
        await api.get();
        // Remember that the interview is complete
        this.interviewComplete = true;
    }
    setMappedBasicValue(value) {
        this.getValueDB().setValue({
            commandClass: this.ccId,
            endpoint: this.endpointIndex,
            property: "currentValue",
        }, value);
        return true;
    }
    createMetadataForLevelChangeActions(
    // SDS13781: The Primary Switch Type SHOULD be 0x02 (Up/Down)
    switchType = SwitchType["Down/Up"]) {
        const valueDb = this.getValueDB();
        // Create metadata for the control values if necessary
        const switchTypeName = shared_1.getEnumMemberName(SwitchType, switchType);
        const [down, up] = switchTypeToActions(switchTypeName);
        const upValueId = {
            commandClass: this.ccId,
            endpoint: this.endpointIndex,
            property: up,
        };
        const downValueId = {
            commandClass: this.ccId,
            endpoint: this.endpointIndex,
            property: down,
        };
        if (!valueDb.hasMetadata(upValueId)) {
            this.getValueDB().setMetadata(upValueId, {
                ...core_1.ValueMetadata.Boolean,
                label: `Perform a level change (${up})`,
                ccSpecific: { switchType },
            });
        }
        if (!valueDb.hasMetadata(downValueId)) {
            this.getValueDB().setMetadata(downValueId, {
                ...core_1.ValueMetadata.Boolean,
                label: `Perform a level change (${down})`,
                ccSpecific: { switchType },
            });
        }
    }
};
MultilevelSwitchCC = __decorate([
    CommandClass_1.commandClass(core_1.CommandClasses["Multilevel Switch"]),
    CommandClass_1.implementedVersion(4)
], MultilevelSwitchCC);
exports.MultilevelSwitchCC = MultilevelSwitchCC;
let MultilevelSwitchCCSet = class MultilevelSwitchCCSet extends MultilevelSwitchCC {
    constructor(driver, options) {
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            // TODO: Deserialize payload
            throw new core_1.ZWaveError(`${this.constructor.name}: deserialization not implemented`, core_1.ZWaveErrorCodes.Deserialization_NotImplemented);
        }
        else {
            this.targetValue = options.targetValue;
            this.duration = options.duration;
        }
    }
    serialize() {
        const payload = [this.targetValue];
        if (this.version >= 2 && this.duration) {
            payload.push(this.duration.serializeSet());
        }
        this.payload = Buffer.from(payload);
        return super.serialize();
    }
    toLogEntry() {
        const message = {
            "target value": this.targetValue,
        };
        if (this.duration) {
            message.duration = this.duration.toString();
        }
        return {
            ...super.toLogEntry(),
            message,
        };
    }
};
MultilevelSwitchCCSet = __decorate([
    CommandClass_1.CCCommand(MultilevelSwitchCommand.Set)
], MultilevelSwitchCCSet);
exports.MultilevelSwitchCCSet = MultilevelSwitchCCSet;
let MultilevelSwitchCCReport = class MultilevelSwitchCCReport extends MultilevelSwitchCC {
    constructor(driver, options) {
        super(driver, options);
        core_1.validatePayload(this.payload.length >= 1);
        // if the payload contains a reserved value, return the actual value
        // instead of undefined
        this._currentValue =
            core_1.parseMaybeNumber(this.payload[0]) || this.payload[0];
        if (this.version >= 4 && this.payload.length >= 3) {
            this._targetValue = core_1.parseNumber(this.payload[1]);
            this._duration = core_1.Duration.parseReport(this.payload[2]);
        }
        this.persistValues();
    }
    get targetValue() {
        return this._targetValue;
    }
    get duration() {
        return this._duration;
    }
    get currentValue() {
        return this._currentValue;
    }
    toLogEntry() {
        const message = {
            "current value": this._currentValue,
        };
        if (this._targetValue != undefined && this._duration) {
            message["target value"] = this._targetValue;
            message.duration = this._duration.toString();
        }
        return {
            ...super.toLogEntry(),
            message,
        };
    }
};
__decorate([
    CommandClass_1.ccValue({ forceCreation: true }),
    CommandClass_1.ccValueMetadata({
        ...core_1.ValueMetadata.Level,
        label: "Target value",
    })
], MultilevelSwitchCCReport.prototype, "targetValue", null);
__decorate([
    CommandClass_1.ccValue(),
    CommandClass_1.ccValueMetadata({
        ...core_1.ValueMetadata.Duration,
        label: "Transition duration",
    })
], MultilevelSwitchCCReport.prototype, "duration", null);
__decorate([
    CommandClass_1.ccValue(),
    CommandClass_1.ccValueMetadata({
        ...core_1.ValueMetadata.ReadOnlyLevel,
        label: "Current value",
    })
], MultilevelSwitchCCReport.prototype, "currentValue", null);
MultilevelSwitchCCReport = __decorate([
    CommandClass_1.CCCommand(MultilevelSwitchCommand.Report)
], MultilevelSwitchCCReport);
exports.MultilevelSwitchCCReport = MultilevelSwitchCCReport;
let MultilevelSwitchCCGet = class MultilevelSwitchCCGet extends MultilevelSwitchCC {
};
MultilevelSwitchCCGet = __decorate([
    CommandClass_1.CCCommand(MultilevelSwitchCommand.Get),
    CommandClass_1.expectedCCResponse(MultilevelSwitchCCReport)
], MultilevelSwitchCCGet);
exports.MultilevelSwitchCCGet = MultilevelSwitchCCGet;
let MultilevelSwitchCCStartLevelChange = class MultilevelSwitchCCStartLevelChange extends MultilevelSwitchCC {
    constructor(driver, options) {
        var _c;
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            // TODO: Deserialize payload
            throw new core_1.ZWaveError(`${this.constructor.name}: deserialization not implemented`, core_1.ZWaveErrorCodes.Deserialization_NotImplemented);
        }
        else {
            this.duration = options.duration;
            this.ignoreStartLevel = options.ignoreStartLevel;
            this.startLevel = (_c = options.startLevel) !== null && _c !== void 0 ? _c : 0;
            this.direction = options.direction;
        }
    }
    serialize() {
        const controlByte = (LevelChangeDirection[this.direction] << 6) |
            (this.ignoreStartLevel ? 32 : 0);
        const payload = [controlByte, this.startLevel];
        if (this.version >= 2 && this.duration) {
            payload.push(this.duration.serializeSet());
        }
        this.payload = Buffer.from(payload);
        return super.serialize();
    }
    toLogEntry() {
        const message = {
            startLevel: `${this.startLevel}${this.ignoreStartLevel ? " (ignored)" : ""}`,
            direction: this.direction,
        };
        if (this.duration) {
            message.duration = this.duration.toString();
        }
        return {
            ...super.toLogEntry(),
            message,
        };
    }
};
MultilevelSwitchCCStartLevelChange = __decorate([
    CommandClass_1.CCCommand(MultilevelSwitchCommand.StartLevelChange)
], MultilevelSwitchCCStartLevelChange);
exports.MultilevelSwitchCCStartLevelChange = MultilevelSwitchCCStartLevelChange;
let MultilevelSwitchCCStopLevelChange = class MultilevelSwitchCCStopLevelChange extends MultilevelSwitchCC {
};
MultilevelSwitchCCStopLevelChange = __decorate([
    CommandClass_1.CCCommand(MultilevelSwitchCommand.StopLevelChange)
], MultilevelSwitchCCStopLevelChange);
exports.MultilevelSwitchCCStopLevelChange = MultilevelSwitchCCStopLevelChange;
let MultilevelSwitchCCSupportedReport = class MultilevelSwitchCCSupportedReport extends MultilevelSwitchCC {
    constructor(driver, options) {
        super(driver, options);
        core_1.validatePayload(this.payload.length >= 2);
        this._switchType = this.payload[0] & 0b11111;
        this.persistValues();
    }
    get switchType() {
        return this._switchType;
    }
    persistValues() {
        if (!super.persistValues())
            return false;
        this.createMetadataForLevelChangeActions(this._switchType);
        return true;
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                "switch type": shared_1.getEnumMemberName(SwitchType, this.switchType),
            },
        };
    }
};
__decorate([
    CommandClass_1.ccValue({ internal: true })
], MultilevelSwitchCCSupportedReport.prototype, "switchType", null);
MultilevelSwitchCCSupportedReport = __decorate([
    CommandClass_1.CCCommand(MultilevelSwitchCommand.SupportedReport)
], MultilevelSwitchCCSupportedReport);
exports.MultilevelSwitchCCSupportedReport = MultilevelSwitchCCSupportedReport;
let MultilevelSwitchCCSupportedGet = class MultilevelSwitchCCSupportedGet extends MultilevelSwitchCC {
};
MultilevelSwitchCCSupportedGet = __decorate([
    CommandClass_1.CCCommand(MultilevelSwitchCommand.SupportedGet),
    CommandClass_1.expectedCCResponse(MultilevelSwitchCCSupportedReport)
], MultilevelSwitchCCSupportedGet);
exports.MultilevelSwitchCCSupportedGet = MultilevelSwitchCCSupportedGet;

//# sourceMappingURL=MultilevelSwitchCC.js.map
