/// <reference types="node" />
import type { Maybe, MessageOrCCLogEntry, ValueID } from "@zwave-js/core";
import { Duration } from "@zwave-js/core";
import type { Driver } from "../driver/Driver";
import { CCAPI, SetValueImplementation, SET_VALUE } from "./API";
import { CCCommandOptions, CommandClass, CommandClassDeserializationOptions } from "./CommandClass";
export declare function getSceneIdValueID(endpoint: number): ValueID;
export declare function getDimmingDurationValueID(endpoint: number): ValueID;
export declare enum SceneActivationCommand {
    Set = 1
}
export declare class SceneActivationCCAPI extends CCAPI {
    supportsCommand(_cmd: SceneActivationCommand): Maybe<boolean>;
    protected [SET_VALUE]: SetValueImplementation;
    set(sceneId: number, dimmingDuration?: Duration): Promise<void>;
}
export declare class SceneActivationCC extends CommandClass {
    ccCommand: SceneActivationCommand;
}
interface SceneActivationCCSetOptions extends CCCommandOptions {
    sceneId: number;
    dimmingDuration?: Duration;
}
export declare class SceneActivationCCSet extends SceneActivationCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | SceneActivationCCSetOptions);
    sceneId: number;
    dimmingDuration: Duration | undefined;
    serialize(): Buffer;
    toLogEntry(): MessageOrCCLogEntry;
}
export {};
