"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var _a, _b;
var WakeUpCC_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WakeUpCCIntervalCapabilitiesGet = exports.WakeUpCCIntervalCapabilitiesReport = exports.WakeUpCCNoMoreInformation = exports.WakeUpCCWakeUpNotification = exports.WakeUpCCIntervalGet = exports.WakeUpCCIntervalReport = exports.WakeUpCCIntervalSet = exports.WakeUpCC = exports.WakeUpCCAPI = exports.WakeUpCommand = exports.getWakeUpIntervalValueId = void 0;
const core_1 = require("@zwave-js/core");
const shared_1 = require("@zwave-js/shared");
const Constants_1 = require("../message/Constants");
const Types_1 = require("../node/Types");
const API_1 = require("./API");
const CommandClass_1 = require("./CommandClass");
function getWakeUpIntervalValueId() {
    return {
        commandClass: core_1.CommandClasses["Wake Up"],
        property: "wakeUpInterval",
    };
}
exports.getWakeUpIntervalValueId = getWakeUpIntervalValueId;
var WakeUpCommand;
(function (WakeUpCommand) {
    WakeUpCommand[WakeUpCommand["IntervalSet"] = 4] = "IntervalSet";
    WakeUpCommand[WakeUpCommand["IntervalGet"] = 5] = "IntervalGet";
    WakeUpCommand[WakeUpCommand["IntervalReport"] = 6] = "IntervalReport";
    WakeUpCommand[WakeUpCommand["WakeUpNotification"] = 7] = "WakeUpNotification";
    WakeUpCommand[WakeUpCommand["NoMoreInformation"] = 8] = "NoMoreInformation";
    WakeUpCommand[WakeUpCommand["IntervalCapabilitiesGet"] = 9] = "IntervalCapabilitiesGet";
    WakeUpCommand[WakeUpCommand["IntervalCapabilitiesReport"] = 10] = "IntervalCapabilitiesReport";
})(WakeUpCommand = exports.WakeUpCommand || (exports.WakeUpCommand = {}));
let WakeUpCCAPI = class WakeUpCCAPI extends API_1.CCAPI {
    constructor() {
        super(...arguments);
        this[_a] = async ({ property }, value) => {
            var _c;
            if (property !== "wakeUpInterval") {
                API_1.throwUnsupportedProperty(this.ccId, property);
            }
            if (typeof value !== "number") {
                API_1.throwWrongValueType(this.ccId, property, "number", typeof value);
            }
            await this.setInterval(value, (_c = this.driver.controller.ownNodeId) !== null && _c !== void 0 ? _c : 1);
            if (this.isSinglecast()) {
                // Verify the current value after a delay
                this.schedulePoll({ property });
            }
        };
        this[_b] = async ({ property, }) => {
            var _c;
            switch (property) {
                case "wakeUpInterval":
                    return (_c = (await this.getInterval())) === null || _c === void 0 ? void 0 : _c[property];
                default:
                    API_1.throwUnsupportedProperty(this.ccId, property);
            }
        };
    }
    supportsCommand(cmd) {
        switch (cmd) {
            case WakeUpCommand.IntervalGet:
                return this.isSinglecast();
            case WakeUpCommand.IntervalSet:
            case WakeUpCommand.NoMoreInformation:
                return true; // This is mandatory
            case WakeUpCommand.IntervalCapabilitiesGet:
                return this.version >= 2 && this.isSinglecast();
        }
        return super.supportsCommand(cmd);
    }
    // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
    async getInterval() {
        this.assertSupportsCommand(WakeUpCommand, WakeUpCommand.IntervalGet);
        const cc = new WakeUpCCIntervalGet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
        });
        const response = await this.driver.sendCommand(cc, this.commandOptions);
        if (response) {
            return shared_1.pick(response, ["wakeUpInterval", "controllerNodeId"]);
        }
    }
    // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
    async getIntervalCapabilities() {
        this.assertSupportsCommand(WakeUpCommand, WakeUpCommand.IntervalCapabilitiesGet);
        const cc = new WakeUpCCIntervalCapabilitiesGet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
        });
        const response = await this.driver.sendCommand(cc, this.commandOptions);
        if (response) {
            return shared_1.pick(response, [
                "defaultWakeUpInterval",
                "minWakeUpInterval",
                "maxWakeUpInterval",
                "wakeUpIntervalSteps",
            ]);
        }
    }
    async setInterval(wakeUpInterval, controllerNodeId) {
        this.assertSupportsCommand(WakeUpCommand, WakeUpCommand.IntervalSet);
        const cc = new WakeUpCCIntervalSet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
            wakeUpInterval,
            controllerNodeId,
        });
        await this.driver.sendCommand(cc, this.commandOptions);
    }
    async sendNoMoreInformation() {
        this.assertSupportsCommand(WakeUpCommand, WakeUpCommand.NoMoreInformation);
        const cc = new WakeUpCCNoMoreInformation(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
        });
        await this.driver.sendCommand(cc, {
            ...this.commandOptions,
            // This command must be sent as part of the wake up queue
            priority: Constants_1.MessagePriority.WakeUp,
            // Don't try to resend this - if we get no response, the node is most likely asleep
            maxSendAttempts: 1,
        });
    }
};
_a = API_1.SET_VALUE, _b = API_1.POLL_VALUE;
WakeUpCCAPI = __decorate([
    CommandClass_1.API(core_1.CommandClasses["Wake Up"])
], WakeUpCCAPI);
exports.WakeUpCCAPI = WakeUpCCAPI;
let WakeUpCC = WakeUpCC_1 = class WakeUpCC extends CommandClass_1.CommandClass {
    isAwake() {
        return WakeUpCC_1.isAwake(this.getNode());
    }
    static isAwake(node) {
        switch (node.status) {
            case Types_1.NodeStatus.Asleep:
            case Types_1.NodeStatus.Dead:
                return false;
            case Types_1.NodeStatus.Unknown:
            // We assume all nodes to be awake - we'll find out soon enough if they are
            case Types_1.NodeStatus.Alive:
            case Types_1.NodeStatus.Awake:
                return true;
        }
    }
    async interview(complete = true) {
        const node = this.getNode();
        const endpoint = this.getEndpoint();
        const api = endpoint.commandClasses["Wake Up"].withOptions({
            priority: Constants_1.MessagePriority.NodeQuery,
        });
        this.driver.controllerLog.logNode(node.id, {
            endpoint: this.endpointIndex,
            message: `${this.constructor.name}: doing a ${complete ? "complete" : "partial"} interview...`,
            direction: "none",
        });
        // We need to do some queries after a potential timeout
        // In this case, do now mark this CC as interviewed completely
        let hadCriticalTimeout = false;
        if (node.isControllerNode()) {
            this.driver.controllerLog.logNode(node.id, `skipping wakeup configuration for the controller`);
        }
        else if (node.isFrequentListening) {
            this.driver.controllerLog.logNode(node.id, `skipping wakeup configuration for frequent listening device`);
        }
        else {
            // Retrieve the allowed wake up intervals if possible
            if (complete) {
                // This information does not change
                if (this.version >= 2) {
                    this.driver.controllerLog.logNode(node.id, {
                        endpoint: this.endpointIndex,
                        message: "retrieving wakeup capabilities from the device...",
                        direction: "outbound",
                    });
                    const wakeupCaps = await api.getIntervalCapabilities();
                    if (wakeupCaps) {
                        const logMessage = `received wakeup capabilities:
default wakeup interval: ${wakeupCaps.defaultWakeUpInterval} seconds
minimum wakeup interval: ${wakeupCaps.minWakeUpInterval} seconds
maximum wakeup interval: ${wakeupCaps.maxWakeUpInterval} seconds
wakeup interval steps:   ${wakeupCaps.wakeUpIntervalSteps} seconds`;
                        this.driver.controllerLog.logNode(node.id, {
                            endpoint: this.endpointIndex,
                            message: logMessage,
                            direction: "inbound",
                        });
                    }
                    else {
                        hadCriticalTimeout = true;
                    }
                }
            }
            // SDS14223 prescribes a IntervalSet followed by a check
            // We have no intention of changing the interval (maybe some time in the future)
            // So for now get the current interval and just set the controller ID
            this.driver.controllerLog.logNode(node.id, {
                endpoint: this.endpointIndex,
                message: "retrieving wakeup interval from the device...",
                direction: "outbound",
            });
            const wakeupResp = await api.getInterval();
            if (wakeupResp) {
                const logMessage = `received wakeup configuration:
wakeup interval: ${wakeupResp.wakeUpInterval} seconds
controller node: ${wakeupResp.controllerNodeId}`;
                this.driver.controllerLog.logNode(node.id, {
                    endpoint: this.endpointIndex,
                    message: logMessage,
                    direction: "inbound",
                });
                const ownNodeId = this.driver.controller.ownNodeId;
                // Only change the destination if necessary
                if (wakeupResp.controllerNodeId !== ownNodeId) {
                    this.driver.controllerLog.logNode(node.id, {
                        endpoint: this.endpointIndex,
                        message: "configuring wakeup destination node",
                        direction: "outbound",
                    });
                    await api.setInterval(wakeupResp.wakeUpInterval, ownNodeId);
                    this.driver.controllerLog.logNode(node.id, "wakeup destination node changed!");
                }
            }
            else {
                // TODO: Change destination as the first thing during bootstrapping a node
                // and make it non-critical here
                hadCriticalTimeout = true;
            }
        }
        // Remember that the interview is complete
        if (!hadCriticalTimeout)
            this.interviewComplete = true;
    }
};
WakeUpCC = WakeUpCC_1 = __decorate([
    CommandClass_1.commandClass(core_1.CommandClasses["Wake Up"]),
    CommandClass_1.implementedVersion(2)
], WakeUpCC);
exports.WakeUpCC = WakeUpCC;
let WakeUpCCIntervalSet = class WakeUpCCIntervalSet extends WakeUpCC {
    constructor(driver, options) {
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            // TODO: Deserialize payload
            // This error is used to test the driver!
            // When implementing this branch, update the corresponding driver test
            throw new core_1.ZWaveError(`${this.constructor.name}: deserialization not implemented`, core_1.ZWaveErrorCodes.Deserialization_NotImplemented);
        }
        else {
            this.wakeUpInterval = options.wakeUpInterval;
            this.controllerNodeId = options.controllerNodeId;
        }
    }
    serialize() {
        this.payload = Buffer.from([
            0,
            0,
            0,
            this.controllerNodeId,
        ]);
        this.payload.writeUIntBE(this.wakeUpInterval, 0, 3);
        return super.serialize();
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                "wake-up interval": `${this.wakeUpInterval} seconds`,
                "controller node id": this.controllerNodeId,
            },
        };
    }
};
WakeUpCCIntervalSet = __decorate([
    CommandClass_1.CCCommand(WakeUpCommand.IntervalSet)
], WakeUpCCIntervalSet);
exports.WakeUpCCIntervalSet = WakeUpCCIntervalSet;
let WakeUpCCIntervalReport = class WakeUpCCIntervalReport extends WakeUpCC {
    constructor(driver, options) {
        super(driver, options);
        core_1.validatePayload(this.payload.length >= 4);
        this._wakeUpInterval = this.payload.readUIntBE(0, 3);
        this._controllerNodeId = this.payload[3];
        this.persistValues();
    }
    get wakeUpInterval() {
        return this._wakeUpInterval;
    }
    get controllerNodeId() {
        return this._controllerNodeId;
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                "wake-up interval": `${this.wakeUpInterval} seconds`,
                "controller node id": this._controllerNodeId,
            },
        };
    }
};
__decorate([
    CommandClass_1.ccValue(),
    CommandClass_1.ccValueMetadata({
        ...core_1.ValueMetadata.UInt24,
        label: "Wake Up interval",
    })
], WakeUpCCIntervalReport.prototype, "wakeUpInterval", null);
__decorate([
    CommandClass_1.ccValue(),
    CommandClass_1.ccValueMetadata({
        ...core_1.ValueMetadata.ReadOnly,
        label: "Node ID of the controller",
    })
], WakeUpCCIntervalReport.prototype, "controllerNodeId", null);
WakeUpCCIntervalReport = __decorate([
    CommandClass_1.CCCommand(WakeUpCommand.IntervalReport)
], WakeUpCCIntervalReport);
exports.WakeUpCCIntervalReport = WakeUpCCIntervalReport;
let WakeUpCCIntervalGet = class WakeUpCCIntervalGet extends WakeUpCC {
};
WakeUpCCIntervalGet = __decorate([
    CommandClass_1.CCCommand(WakeUpCommand.IntervalGet),
    CommandClass_1.expectedCCResponse(WakeUpCCIntervalReport)
], WakeUpCCIntervalGet);
exports.WakeUpCCIntervalGet = WakeUpCCIntervalGet;
let WakeUpCCWakeUpNotification = class WakeUpCCWakeUpNotification extends WakeUpCC {
};
WakeUpCCWakeUpNotification = __decorate([
    CommandClass_1.CCCommand(WakeUpCommand.WakeUpNotification)
], WakeUpCCWakeUpNotification);
exports.WakeUpCCWakeUpNotification = WakeUpCCWakeUpNotification;
let WakeUpCCNoMoreInformation = class WakeUpCCNoMoreInformation extends WakeUpCC {
};
WakeUpCCNoMoreInformation = __decorate([
    CommandClass_1.CCCommand(WakeUpCommand.NoMoreInformation)
], WakeUpCCNoMoreInformation);
exports.WakeUpCCNoMoreInformation = WakeUpCCNoMoreInformation;
let WakeUpCCIntervalCapabilitiesReport = class WakeUpCCIntervalCapabilitiesReport extends WakeUpCC {
    // @noCCValues The values are stored as part of the metadata
    constructor(driver, options) {
        super(driver, options);
        core_1.validatePayload(this.payload.length >= 12);
        this._minWakeUpInterval = this.payload.readUIntBE(0, 3);
        this._maxWakeUpInterval = this.payload.readUIntBE(3, 3);
        this._defaultWakeUpInterval = this.payload.readUIntBE(6, 3);
        this._wakeUpIntervalSteps = this.payload.readUIntBE(9, 3);
        // Store the received information as metadata for the wake up interval
        this.getValueDB().setMetadata({
            commandClass: this.ccId,
            endpoint: this.endpointIndex,
            property: "wakeUpInterval",
        }, {
            ...core_1.ValueMetadata.WriteOnlyUInt24,
            min: this._minWakeUpInterval,
            max: this._maxWakeUpInterval,
            steps: this._wakeUpIntervalSteps,
            default: this._defaultWakeUpInterval,
        });
    }
    get minWakeUpInterval() {
        return this._minWakeUpInterval;
    }
    get maxWakeUpInterval() {
        return this._maxWakeUpInterval;
    }
    get defaultWakeUpInterval() {
        return this._defaultWakeUpInterval;
    }
    get wakeUpIntervalSteps() {
        return this._wakeUpIntervalSteps;
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                "default interval": `${this._defaultWakeUpInterval} seconds`,
                "minimum interval": `${this._minWakeUpInterval} seconds`,
                "maximum interval": `${this._maxWakeUpInterval} seconds`,
                "interval steps": `${this._wakeUpIntervalSteps} seconds`,
            },
        };
    }
};
WakeUpCCIntervalCapabilitiesReport = __decorate([
    CommandClass_1.CCCommand(WakeUpCommand.IntervalCapabilitiesReport)
], WakeUpCCIntervalCapabilitiesReport);
exports.WakeUpCCIntervalCapabilitiesReport = WakeUpCCIntervalCapabilitiesReport;
let WakeUpCCIntervalCapabilitiesGet = class WakeUpCCIntervalCapabilitiesGet extends WakeUpCC {
};
WakeUpCCIntervalCapabilitiesGet = __decorate([
    CommandClass_1.CCCommand(WakeUpCommand.IntervalCapabilitiesGet),
    CommandClass_1.expectedCCResponse(WakeUpCCIntervalCapabilitiesReport)
], WakeUpCCIntervalCapabilitiesGet);
exports.WakeUpCCIntervalCapabilitiesGet = WakeUpCCIntervalCapabilitiesGet;

//# sourceMappingURL=WakeUpCC.js.map
