/// <reference types="node" />
import { CommandClasses } from "@zwave-js/core";
import type { Driver } from "../driver/Driver";
import { Message, MessageBaseOptions, MessageDeserializationOptions } from "../message/Message";
export declare enum AddNodeType {
    Any = 1,
    Controller = 2,
    Slave = 3,
    Existing = 4,
    Stop = 5,
    StopFailed = 6
}
export declare enum AddNodeStatus {
    Ready = 1,
    NodeFound = 2,
    AddingSlave = 3,
    AddingController = 4,
    ProtocolDone = 5,
    Done = 6,
    Failed = 7
}
interface AddNodeToNetworkRequestOptions extends MessageBaseOptions {
    addNodeType?: AddNodeType;
    highPower?: boolean;
    networkWide?: boolean;
}
export declare class AddNodeToNetworkRequest extends Message {
    constructor(driver: Driver, options?: MessageDeserializationOptions | AddNodeToNetworkRequestOptions);
    /** The type of node to add */
    addNodeType: AddNodeType | undefined;
    /** Whether to use high power */
    highPower: boolean;
    /** Whether to include network wide */
    networkWide: boolean;
    private _status;
    get status(): AddNodeStatus | undefined;
    private _statusContext;
    get statusContext(): AddNodeStatusContext | undefined;
    serialize(): Buffer;
}
interface AddNodeStatusContext {
    nodeId: number;
    basic?: number;
    generic?: number;
    specific?: number;
    supportedCCs?: CommandClasses[];
    controlledCCs?: CommandClasses[];
}
export {};
