"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AddNodeToNetworkRequest = exports.AddNodeStatus = exports.AddNodeType = void 0;
const core_1 = require("@zwave-js/core");
const Constants_1 = require("../message/Constants");
const Message_1 = require("../message/Message");
var AddNodeType;
(function (AddNodeType) {
    AddNodeType[AddNodeType["Any"] = 1] = "Any";
    AddNodeType[AddNodeType["Controller"] = 2] = "Controller";
    AddNodeType[AddNodeType["Slave"] = 3] = "Slave";
    AddNodeType[AddNodeType["Existing"] = 4] = "Existing";
    AddNodeType[AddNodeType["Stop"] = 5] = "Stop";
    AddNodeType[AddNodeType["StopFailed"] = 6] = "StopFailed";
})(AddNodeType = exports.AddNodeType || (exports.AddNodeType = {}));
var AddNodeStatus;
(function (AddNodeStatus) {
    AddNodeStatus[AddNodeStatus["Ready"] = 1] = "Ready";
    AddNodeStatus[AddNodeStatus["NodeFound"] = 2] = "NodeFound";
    AddNodeStatus[AddNodeStatus["AddingSlave"] = 3] = "AddingSlave";
    AddNodeStatus[AddNodeStatus["AddingController"] = 4] = "AddingController";
    AddNodeStatus[AddNodeStatus["ProtocolDone"] = 5] = "ProtocolDone";
    AddNodeStatus[AddNodeStatus["Done"] = 6] = "Done";
    AddNodeStatus[AddNodeStatus["Failed"] = 7] = "Failed";
})(AddNodeStatus = exports.AddNodeStatus || (exports.AddNodeStatus = {}));
var AddNodeFlags;
(function (AddNodeFlags) {
    AddNodeFlags[AddNodeFlags["HighPower"] = 128] = "HighPower";
    AddNodeFlags[AddNodeFlags["NetworkWide"] = 64] = "NetworkWide";
})(AddNodeFlags || (AddNodeFlags = {}));
// TODO: Can we differentiate between sent and received here?
// payload length maybe?
let AddNodeToNetworkRequest = class AddNodeToNetworkRequest extends Message_1.Message {
    constructor(driver, options = {}) {
        super(driver, options);
        /** Whether to use high power */
        this.highPower = false;
        /** Whether to include network wide */
        this.networkWide = false;
        if (Message_1.gotDeserializationOptions(options)) {
            // not sure what the value in payload[0] means
            this._status = this.payload[1];
            switch (this._status) {
                case AddNodeStatus.Ready:
                case AddNodeStatus.NodeFound:
                case AddNodeStatus.ProtocolDone:
                case AddNodeStatus.Failed:
                    // no context for the status to parse
                    break;
                case AddNodeStatus.Done:
                    this._statusContext = { nodeId: this.payload[2] };
                    break;
                case AddNodeStatus.AddingController:
                case AddNodeStatus.AddingSlave: {
                    // the payload contains a node information frame
                    this._statusContext = core_1.parseNodeUpdatePayload(this.payload.slice(2));
                    break;
                }
            }
        }
        else {
            this.addNodeType = options.addNodeType;
            this.highPower = !!options.highPower;
            this.networkWide = !!options.networkWide;
        }
    }
    get status() {
        return this._status;
    }
    get statusContext() {
        return this._statusContext;
    }
    serialize() {
        let data = this.addNodeType || AddNodeType.Any;
        if (this.highPower)
            data |= AddNodeFlags.HighPower;
        if (this.networkWide)
            data |= AddNodeFlags.NetworkWide;
        this.payload = Buffer.from([data, this.callbackId]);
        return super.serialize();
    }
};
AddNodeToNetworkRequest = __decorate([
    Message_1.messageTypes(Constants_1.MessageType.Request, Constants_1.FunctionType.AddNodeToNetwork)
    // no expected response, the controller will respond with another AddNodeToNetworkRequest
    ,
    Message_1.priority(Constants_1.MessagePriority.Controller)
], AddNodeToNetworkRequest);
exports.AddNodeToNetworkRequest = AddNodeToNetworkRequest;

//# sourceMappingURL=AddNodeToNetworkRequest.js.map
