/// <reference types="node" />
import type { JSONObject } from "@zwave-js/shared";
import type { Driver } from "../driver/Driver";
import { Message, MessageBaseOptions, MessageDeserializationOptions } from "../message/Message";
import { DeviceClass } from "../node/DeviceClass";
export declare type Baudrate = 9600 | 40000 | 100000;
interface GetNodeProtocolInfoRequestOptions extends MessageBaseOptions {
    requestedNodeId: number;
}
export declare class GetNodeProtocolInfoRequest extends Message {
    constructor(driver: Driver, options: GetNodeProtocolInfoRequestOptions);
    requestedNodeId: number;
    serialize(): Buffer;
    toJSON(): JSONObject;
}
export declare class GetNodeProtocolInfoResponse extends Message {
    constructor(driver: Driver, options: MessageDeserializationOptions);
    private _isListening;
    get isListening(): boolean;
    private _isFrequentListening;
    get isFrequentListening(): boolean;
    private _isRouting;
    get isRouting(): boolean;
    private _maxBaudRate;
    get maxBaudRate(): Baudrate;
    private _isSecure;
    get isSecure(): boolean;
    private _version;
    get version(): number;
    private _isBeaming;
    get isBeaming(): boolean;
    private _deviceClass;
    get deviceClass(): DeviceClass;
    toJSON(): JSONObject;
}
export {};
