/// <reference types="jest" />
import { ConfigManager } from "@zwave-js/config";
import { Message } from "../message/Message";
export declare class MockRequestMessageWithExpectation extends Message {
}
export declare class MockRequestMessageWithoutExpectation extends Message {
}
export declare class MockResponseMessage extends Message {
}
export declare const mockDriverDummyCallbackId = 254;
export declare function createEmptyMockDriver(): {
    sendMessage: jest.Mock<any, any>;
    sendCommand: jest.Mock<any, any>;
    saveNetworkToCache: jest.Mock<any, any>;
    getSafeCCVersionForNode: jest.Mock<any, any>;
    getNextCallbackId: jest.Mock<any, any>;
    controller: {
        nodes: Map<any, any>;
        ownNodeId: number;
    };
    valueDB: Map<any, any>;
    metadataDB: Map<any, any>;
    options: {
        timeouts: {
            ack: number;
            byte: number;
            response: number;
            report: number;
            nonce: number;
            sendDataCallback: number;
        };
        attempts: {
            sendData: number;
            controller: number;
        };
    };
    driverLog: {};
    controllerLog: {};
    configManager: ConfigManager;
};
