/// <reference types="node" />
/** Encrypts a payload using AES-128-ECB (as described in SDS10865) */
export declare function encryptAES128ECB(plaintext: Buffer, key: Buffer): Buffer;
/** Encrypts a payload using AES-OFB (as described in SDS10865) */
export declare const encryptAES128OFB: (input: Buffer, key: Buffer, iv: Buffer) => Buffer;
/** Decrypts a payload using AES-OFB (as described in SDS10865) */
export declare const decryptAES128OFB: (input: Buffer, key: Buffer, iv: Buffer) => Buffer;
/** Computes a message authentication code (as described in SDS10865) */
export declare function computeMAC(authData: Buffer, key: Buffer, iv?: Buffer): Buffer;
//# sourceMappingURL=crypto.d.ts.map