/** Ensures that the values array is consecutive */
export declare function isConsecutiveArray(values: number[]): boolean;
/** Returns an object that includes all non-undefined properties from the original one */
export declare function stripUndefined<T>(obj: Record<string, T>): Record<string, T>;
/**
 * Validates the payload about to be parsed. This can be used to avoid crashes caused by malformed packets
 * @param assertions An array of assertions to check if we have a valid payload
 */
declare type PayloadValidationFunction = (...assertions: unknown[]) => void;
interface ValidatePayload extends PayloadValidationFunction {
    /**
     * @param reason The optional reason for a rejection
     */
    withReason(reason: string): PayloadValidationFunction;
}
export declare const validatePayload: ValidatePayload;
/**
 * Determines how many bits a value must be shifted to be right-aligned with a given bit mask
 * Example:
 * ```txt
 *   Mask = 00110000
 *             ^---- => 4 bits
 *
 *   Mask = 00110001
 *                 ^ => 0 bits
 * ```
 */
export declare function getMinimumShiftForBitMask(mask: number): number;
export {};
//# sourceMappingURL=misc.d.ts.map