/// <reference types="node" />
import { CommandClasses, Maybe, MessageOrCCLogEntry } from "@zwave-js/core";
import type { Driver } from "../driver/Driver";
import { PhysicalCCAPI } from "./API";
import { CCCommandOptions, CommandClass, CommandClassDeserializationOptions, CommandClassOptions } from "./CommandClass";
export declare enum AssociationGroupInfoCommand {
    NameGet = 1,
    NameReport = 2,
    InfoGet = 3,
    InfoReport = 4,
    CommandListGet = 5,
    CommandListReport = 6
}
/**
 * @publicAPI
 */
export declare enum AssociationGroupInfoProfile {
    "General: N/A" = 0,
    "General: Lifeline" = 1,
    "Control: Key 01" = 8193,
    "Control: Key 02" = 8194,
    "Control: Key 03" = 8195,
    "Control: Key 04" = 8196,
    "Control: Key 05" = 8197,
    "Control: Key 06" = 8198,
    "Control: Key 07" = 8199,
    "Control: Key 08" = 8200,
    "Control: Key 09" = 8201,
    "Control: Key 10" = 8202,
    "Control: Key 11" = 8203,
    "Control: Key 12" = 8204,
    "Control: Key 13" = 8205,
    "Control: Key 14" = 8206,
    "Control: Key 15" = 8207,
    "Control: Key 16" = 8208,
    "Control: Key 17" = 8209,
    "Control: Key 18" = 8210,
    "Control: Key 19" = 8211,
    "Control: Key 20" = 8212,
    "Control: Key 21" = 8213,
    "Control: Key 22" = 8214,
    "Control: Key 23" = 8215,
    "Control: Key 24" = 8216,
    "Control: Key 25" = 8217,
    "Control: Key 26" = 8218,
    "Control: Key 27" = 8219,
    "Control: Key 28" = 8220,
    "Control: Key 29" = 8221,
    "Control: Key 30" = 8222,
    "Control: Key 31" = 8223,
    "Control: Key 32" = 8224,
    "Sensor: Air temperature" = 12545,
    "Sensor: General purpose" = 12546,
    "Sensor: Illuminance" = 12547,
    "Sensor: Power" = 12548,
    "Sensor: Humidity" = 12549,
    "Sensor: Velocity" = 12550,
    "Sensor: Direction" = 12551,
    "Sensor: Atmospheric pressure" = 12552,
    "Sensor: Barometric pressure" = 12553,
    "Sensor: Solar radiation" = 12554,
    "Sensor: Dew point" = 12555,
    "Sensor: Rain rate" = 12556,
    "Sensor: Tide level" = 12557,
    "Sensor: Weight" = 12558,
    "Sensor: Voltage" = 12559,
    "Sensor: Current" = 12560,
    "Sensor: Carbon dioxide (CO2) level" = 12561,
    "Sensor: Air flow" = 12562,
    "Sensor: Tank capacity" = 12563,
    "Sensor: Distance" = 12564,
    "Sensor: Angle position" = 12565,
    "Sensor: Rotation" = 12566,
    "Sensor: Water temperature" = 12567,
    "Sensor: Soil temperature" = 12568,
    "Sensor: Seismic Intensity" = 12569,
    "Sensor: Seismic magnitude" = 12570,
    "Sensor: Ultraviolet" = 12571,
    "Sensor: Electrical resistivity" = 12572,
    "Sensor: Electrical conductivity" = 12573,
    "Sensor: Loudness" = 12574,
    "Sensor: Moisture" = 12575,
    "Sensor: Frequency" = 12576,
    "Sensor: Time" = 12577,
    "Sensor: Target temperature" = 12578,
    "Sensor: Particulate Matter 2.5" = 12579,
    "Sensor: Formaldehyde (CH2O) level" = 12580,
    "Sensor: Radon concentration" = 12581,
    "Sensor: Methane (CH4) density" = 12582,
    "Sensor: Volatile Organic Compound level" = 12583,
    "Sensor: Carbon monoxide (CO) level" = 12584,
    "Sensor: Soil humidity" = 12585,
    "Sensor: Soil reactivity" = 12586,
    "Sensor: Soil salinity" = 12587,
    "Sensor: Heart rate" = 12588,
    "Sensor: Blood pressure" = 12589,
    "Sensor: Muscle mass" = 12590,
    "Sensor: Fat mass" = 12591,
    "Sensor: Bone mass" = 12592,
    "Sensor: Total body water (TBW)" = 12593,
    "Sensor: Basis metabolic rate (BMR)" = 12594,
    "Sensor: Body Mass Index (BMI)" = 12595,
    "Sensor: Acceleration X-axis" = 12596,
    "Sensor: Acceleration Y-axis" = 12597,
    "Sensor: Acceleration Z-axis" = 12598,
    "Sensor: Smoke density" = 12599,
    "Sensor: Water flow" = 12600,
    "Sensor: Water pressure" = 12601,
    "Sensor: RF signal strength" = 12602,
    "Sensor: Particulate Matter 10" = 12603,
    "Sensor: Respiratory rate" = 12604,
    "Sensor: Relative Modulation level" = 12605,
    "Sensor: Boiler water temperature" = 12606,
    "Sensor: Domestic Hot Water (DHW) temperature" = 12607,
    "Sensor: Outside temperature" = 12608,
    "Sensor: Exhaust temperature" = 12609,
    "Sensor: Water Chlorine level" = 12610,
    "Sensor: Water acidity" = 12611,
    "Sensor: Water Oxidation reduction potential" = 12612,
    "Sensor: Heart Rate LF/HF ratio" = 12613,
    "Sensor: Motion Direction" = 12614,
    "Sensor: Applied force on the sensor" = 12615,
    "Sensor: Return Air temperature" = 12616,
    "Sensor: Supply Air temperature" = 12617,
    "Sensor: Condenser Coil temperature" = 12618,
    "Sensor: Evaporator Coil temperature" = 12619,
    "Sensor: Liquid Line temperature" = 12620,
    "Sensor: Discharge Line temperature" = 12621,
    "Sensor: Suction Pressure" = 12622,
    "Sensor: Discharge Pressure" = 12623,
    "Sensor: Defrost temperature" = 12624,
    "Notification: Smoke Alarm" = 28929,
    "Notification: CO Alarm" = 28930,
    "Notification: CO2 Alarm" = 28931,
    "Notification: Heat Alarm" = 28932,
    "Notification: Water Alarm" = 28933,
    "Notification: Access Control" = 28934,
    "Notification: Home Security" = 28935,
    "Notification: Power Management" = 28936,
    "Notification: System" = 28937,
    "Notification: Emergency Alarm" = 28938,
    "Notification: Clock" = 28939,
    "Notification: Appliance" = 28940,
    "Notification: Home Health" = 28941,
    "Notification: Siren" = 28942,
    "Notification: Water Valve" = 28943,
    "Notification: Weather Alarm" = 28944,
    "Notification: Irrigation" = 28945,
    "Notification: Gas alarm" = 28946,
    "Notification: Pest Control" = 28947,
    "Notification: Light sensor" = 28948,
    "Notification: Water Quality Monitoring" = 28949,
    "Notification: Home monitoring" = 28950,
    "Meter: Electric" = 12801,
    "Meter: Gas" = 12802,
    "Meter: Water" = 12803,
    "Meter: Heating" = 12804,
    "Meter: Cooling" = 12805,
    "Irrigation: Channel 01" = 27393,
    "Irrigation: Channel 02" = 27394,
    "Irrigation: Channel 03" = 27395,
    "Irrigation: Channel 04" = 27396,
    "Irrigation: Channel 05" = 27397,
    "Irrigation: Channel 06" = 27398,
    "Irrigation: Channel 07" = 27399,
    "Irrigation: Channel 08" = 27400,
    "Irrigation: Channel 09" = 27401,
    "Irrigation: Channel 10" = 27402,
    "Irrigation: Channel 11" = 27403,
    "Irrigation: Channel 12" = 27404,
    "Irrigation: Channel 13" = 27405,
    "Irrigation: Channel 14" = 27406,
    "Irrigation: Channel 15" = 27407,
    "Irrigation: Channel 16" = 27408,
    "Irrigation: Channel 17" = 27409,
    "Irrigation: Channel 18" = 27410,
    "Irrigation: Channel 19" = 27411,
    "Irrigation: Channel 20" = 27412,
    "Irrigation: Channel 21" = 27413,
    "Irrigation: Channel 22" = 27414,
    "Irrigation: Channel 23" = 27415,
    "Irrigation: Channel 24" = 27416,
    "Irrigation: Channel 25" = 27417,
    "Irrigation: Channel 26" = 27418,
    "Irrigation: Channel 27" = 27419,
    "Irrigation: Channel 28" = 27420,
    "Irrigation: Channel 29" = 27421,
    "Irrigation: Channel 30" = 27422,
    "Irrigation: Channel 31" = 27423,
    "Irrigation: Channel 32" = 27424
}
/**
 * @publicAPI
 */
export interface AssociationGroup {
    /** How many nodes this association group supports */
    maxNodes: number;
    /** Whether this is the lifeline association (where the Controller must not be removed) */
    isLifeline: boolean;
    /** Whether multi channel associations are allowed */
    multiChannel: boolean;
    /** The name of the group */
    label: string;
    /** The association group profile (if known) */
    profile?: AssociationGroupInfoProfile;
    /** A map of Command Classes and commands issued by this group (if known) */
    issuedCommands?: ReadonlyMap<CommandClasses, readonly number[]>;
}
export declare class AssociationGroupInfoCCAPI extends PhysicalCCAPI {
    supportsCommand(cmd: AssociationGroupInfoCommand): Maybe<boolean>;
    getGroupName(groupId: number): Promise<string | undefined>;
    getGroupInfo(groupId: number, refreshCache?: boolean): Promise<{
        mode: number;
        profile: number;
        eventCode: number;
        hasDynamicInfo: boolean;
    } | undefined>;
    getCommands(groupId: number, allowCache?: boolean): Promise<AssociationGroupInfoCCCommandListReport["commands"] | undefined>;
}
export declare class AssociationGroupInfoCC extends CommandClass {
    ccCommand: AssociationGroupInfoCommand;
    constructor(driver: Driver, options: CommandClassOptions);
    determineRequiredCCInterviews(): readonly CommandClasses[];
    skipEndpointInterview(): boolean;
    /** Returns the name of an association group */
    getGroupNameCached(groupId: number): string | undefined;
    /** Returns the association profile for an association group */
    getGroupProfileCached(groupId: number): AssociationGroupInfoProfile | undefined;
    /** Returns the dictionary of all commands issued by the given association group */
    getIssuedCommandsCached(groupId: number): ReadonlyMap<CommandClasses, readonly number[]> | undefined;
    findGroupsForIssuedCommand(ccId: CommandClasses, command: number): number[];
    private getAssociationGroupCountCached;
    interview(complete?: boolean): Promise<void>;
}
export declare class AssociationGroupInfoCCNameReport extends AssociationGroupInfoCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    persistValues(): boolean;
    readonly groupId: number;
    readonly name: string;
    toLogEntry(): MessageOrCCLogEntry;
}
interface AssociationGroupInfoCCNameGetOptions extends CCCommandOptions {
    groupId: number;
}
export declare class AssociationGroupInfoCCNameGet extends AssociationGroupInfoCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | AssociationGroupInfoCCNameGetOptions);
    groupId: number;
    serialize(): Buffer;
    toLogEntry(): MessageOrCCLogEntry;
}
export interface AssociationGroupInfo {
    groupId: number;
    mode: number;
    profile: number;
    eventCode: number;
}
export declare class AssociationGroupInfoCCInfoReport extends AssociationGroupInfoCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    persistValues(): boolean;
    readonly isListMode: boolean;
    readonly hasDynamicInfo: boolean;
    readonly groups: readonly AssociationGroupInfo[];
    toLogEntry(): MessageOrCCLogEntry;
}
declare type AssociationGroupInfoCCInfoGetOptions = CCCommandOptions & {
    refreshCache: boolean;
} & ({
    listMode: boolean;
} | {
    groupId: number;
});
export declare class AssociationGroupInfoCCInfoGet extends AssociationGroupInfoCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | AssociationGroupInfoCCInfoGetOptions);
    refreshCache: boolean;
    listMode?: boolean;
    groupId?: number;
    serialize(): Buffer;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class AssociationGroupInfoCCCommandListReport extends AssociationGroupInfoCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    private issuedCommands;
    get groupId(): number;
    get commands(): ReadonlyMap<CommandClasses, readonly number[]>;
    toLogEntry(): MessageOrCCLogEntry;
}
interface AssociationGroupInfoCCCommandListGetOptions extends CCCommandOptions {
    allowCache: boolean;
    groupId: number;
}
export declare class AssociationGroupInfoCCCommandListGet extends AssociationGroupInfoCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | AssociationGroupInfoCCCommandListGetOptions);
    allowCache: boolean;
    groupId: number;
    serialize(): Buffer;
    toLogEntry(): MessageOrCCLogEntry;
}
export {};
