/// <reference types="node" />
import { Maybe, MessageOrCCLogEntry, ValueID, ValueMetadata } from "@zwave-js/core";
import type { Driver } from "../driver/Driver";
import { PhysicalCCAPI, PollValueImplementation, POLL_VALUE } from "./API";
import { CCCommandOptions, CommandClass, CommandClassDeserializationOptions } from "./CommandClass";
export declare enum BinarySensorCommand {
    Get = 2,
    Report = 3,
    SupportedGet = 1,
    SupportedReport = 4
}
/**
 * @publicAPI
 */
export declare enum BinarySensorType {
    "General Purpose" = 1,
    Smoke = 2,
    CO = 3,
    CO2 = 4,
    Heat = 5,
    Water = 6,
    Freeze = 7,
    Tamper = 8,
    Aux = 9,
    "Door/Window" = 10,
    Tilt = 11,
    Motion = 12,
    "Glass Break" = 13,
    Any = 255
}
/**
 * @publicAPI
 */
export declare type BinarySensorValueMetadata = ValueMetadata & {
    ccSpecific: {
        sensorType: BinarySensorType;
    };
};
export declare function getBinarySensorValueId(endpointIndex: number | undefined, sensorType: BinarySensorType): ValueID;
export declare function getSupportedSensorTypesValueId(endpointIndex: number): ValueID;
export declare class BinarySensorCCAPI extends PhysicalCCAPI {
    supportsCommand(cmd: BinarySensorCommand): Maybe<boolean>;
    protected [POLL_VALUE]: PollValueImplementation;
    /**
     * Retrieves the current value from this sensor
     * @param sensorType The (optional) sensor type to retrieve the value for
     */
    get(sensorType?: BinarySensorType): Promise<boolean | undefined>;
    getSupportedSensorTypes(): Promise<readonly BinarySensorType[] | undefined>;
}
export declare class BinarySensorCC extends CommandClass {
    ccCommand: BinarySensorCommand;
    interview(complete?: boolean): Promise<void>;
    setMappedBasicValue(value: number): boolean;
}
export declare class BinarySensorCCReport extends BinarySensorCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    persistValues(): boolean;
    private _type;
    get type(): BinarySensorType;
    private _value;
    get value(): boolean;
    toLogEntry(): MessageOrCCLogEntry;
}
interface BinarySensorCCGetOptions extends CCCommandOptions {
    sensorType?: BinarySensorType;
}
export declare class BinarySensorCCGet extends BinarySensorCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | BinarySensorCCGetOptions);
    sensorType: BinarySensorType | undefined;
    serialize(): Buffer;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class BinarySensorCCSupportedReport extends BinarySensorCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    private _supportedSensorTypes;
    get supportedSensorTypes(): readonly BinarySensorType[];
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class BinarySensorCCSupportedGet extends BinarySensorCC {
}
export {};
