"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BinarySensorCCSupportedGet = exports.BinarySensorCCSupportedReport = exports.BinarySensorCCGet = exports.BinarySensorCCReport = exports.BinarySensorCC = exports.BinarySensorCCAPI = exports.getSupportedSensorTypesValueId = exports.getBinarySensorValueId = exports.BinarySensorType = exports.BinarySensorCommand = void 0;
const core_1 = require("@zwave-js/core");
const shared_1 = require("@zwave-js/shared");
const Constants_1 = require("../message/Constants");
const API_1 = require("./API");
const CommandClass_1 = require("./CommandClass");
// All the supported commands
var BinarySensorCommand;
(function (BinarySensorCommand) {
    BinarySensorCommand[BinarySensorCommand["Get"] = 2] = "Get";
    BinarySensorCommand[BinarySensorCommand["Report"] = 3] = "Report";
    BinarySensorCommand[BinarySensorCommand["SupportedGet"] = 1] = "SupportedGet";
    BinarySensorCommand[BinarySensorCommand["SupportedReport"] = 4] = "SupportedReport";
})(BinarySensorCommand = exports.BinarySensorCommand || (exports.BinarySensorCommand = {}));
/**
 * @publicAPI
 */
var BinarySensorType;
(function (BinarySensorType) {
    BinarySensorType[BinarySensorType["General Purpose"] = 1] = "General Purpose";
    BinarySensorType[BinarySensorType["Smoke"] = 2] = "Smoke";
    BinarySensorType[BinarySensorType["CO"] = 3] = "CO";
    BinarySensorType[BinarySensorType["CO2"] = 4] = "CO2";
    BinarySensorType[BinarySensorType["Heat"] = 5] = "Heat";
    BinarySensorType[BinarySensorType["Water"] = 6] = "Water";
    BinarySensorType[BinarySensorType["Freeze"] = 7] = "Freeze";
    BinarySensorType[BinarySensorType["Tamper"] = 8] = "Tamper";
    BinarySensorType[BinarySensorType["Aux"] = 9] = "Aux";
    BinarySensorType[BinarySensorType["Door/Window"] = 10] = "Door/Window";
    BinarySensorType[BinarySensorType["Tilt"] = 11] = "Tilt";
    BinarySensorType[BinarySensorType["Motion"] = 12] = "Motion";
    BinarySensorType[BinarySensorType["Glass Break"] = 13] = "Glass Break";
    BinarySensorType[BinarySensorType["Any"] = 255] = "Any";
})(BinarySensorType = exports.BinarySensorType || (exports.BinarySensorType = {}));
function getBinarySensorValueId(endpointIndex, sensorType) {
    return {
        commandClass: core_1.CommandClasses["Binary Sensor"],
        endpoint: endpointIndex,
        property: shared_1.getEnumMemberName(BinarySensorType, sensorType),
    };
}
exports.getBinarySensorValueId = getBinarySensorValueId;
function getSupportedSensorTypesValueId(endpointIndex) {
    return {
        commandClass: core_1.CommandClasses["Binary Sensor"],
        endpoint: endpointIndex,
        property: "supportedSensorTypes",
    };
}
exports.getSupportedSensorTypesValueId = getSupportedSensorTypesValueId;
// @noSetValueAPI This CC is read-only
let BinarySensorCCAPI = class BinarySensorCCAPI extends API_1.PhysicalCCAPI {
    constructor() {
        super(...arguments);
        this[_a] = async ({ property, }) => {
            if (typeof property === "string") {
                const sensorType = BinarySensorType[property];
                if (sensorType)
                    return this.get(sensorType);
            }
            API_1.throwUnsupportedProperty(this.ccId, property);
        };
    }
    supportsCommand(cmd) {
        switch (cmd) {
            case BinarySensorCommand.Get:
                return true; // This is mandatory
            case BinarySensorCommand.SupportedGet:
                return this.version >= 2;
        }
        return super.supportsCommand(cmd);
    }
    /**
     * Retrieves the current value from this sensor
     * @param sensorType The (optional) sensor type to retrieve the value for
     */
    async get(sensorType) {
        this.assertSupportsCommand(BinarySensorCommand, BinarySensorCommand.Get);
        const cc = new BinarySensorCCGet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
            sensorType,
        });
        const response = await this.driver.sendCommand(cc, this.commandOptions);
        // We don't want to repeat the sensor type
        return response === null || response === void 0 ? void 0 : response.value;
    }
    // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
    async getSupportedSensorTypes() {
        this.assertSupportsCommand(BinarySensorCommand, BinarySensorCommand.SupportedGet);
        const cc = new BinarySensorCCSupportedGet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
        });
        const response = await this.driver.sendCommand(cc, this.commandOptions);
        // We don't want to repeat the sensor type
        return response === null || response === void 0 ? void 0 : response.supportedSensorTypes;
    }
};
_a = API_1.POLL_VALUE;
BinarySensorCCAPI = __decorate([
    CommandClass_1.API(core_1.CommandClasses["Binary Sensor"])
], BinarySensorCCAPI);
exports.BinarySensorCCAPI = BinarySensorCCAPI;
let BinarySensorCC = class BinarySensorCC extends CommandClass_1.CommandClass {
    async interview(complete = true) {
        const node = this.getNode();
        const endpoint = this.getEndpoint();
        const api = endpoint.commandClasses["Binary Sensor"].withOptions({
            priority: Constants_1.MessagePriority.NodeQuery,
        });
        this.driver.controllerLog.logNode(node.id, {
            endpoint: this.endpointIndex,
            message: `${this.constructor.name}: doing a ${complete ? "complete" : "partial"} interview...`,
            direction: "none",
        });
        // Find out which sensor types this sensor supports
        let supportedSensorTypes;
        if (complete && this.version >= 2) {
            this.driver.controllerLog.logNode(node.id, {
                endpoint: this.endpointIndex,
                message: "querying supported sensor types...",
                direction: "outbound",
            });
            supportedSensorTypes = await api.getSupportedSensorTypes();
            if (supportedSensorTypes) {
                const logMessage = `received supported sensor types: ${supportedSensorTypes
                    .map((type) => shared_1.getEnumMemberName(BinarySensorType, type))
                    .map((name) => `\n· ${name}`)
                    .join("")}`;
                this.driver.controllerLog.logNode(node.id, {
                    endpoint: this.endpointIndex,
                    message: logMessage,
                    direction: "inbound",
                });
            }
            else {
                this.driver.controllerLog.logNode(node.id, {
                    endpoint: this.endpointIndex,
                    message: "Querying supported sensor types timed out, skipping interview...",
                    level: "warn",
                });
                return;
            }
        }
        else {
            supportedSensorTypes = this.getValueDB().getValue(getSupportedSensorTypesValueId(this.endpointIndex));
        }
        // Always query (all of) the sensor's current value(s)
        if (this.version === 1) {
            this.driver.controllerLog.logNode(node.id, {
                endpoint: this.endpointIndex,
                message: "querying current value...",
                direction: "outbound",
            });
            const currentValue = await api.get();
            if (currentValue != undefined) {
                this.driver.controllerLog.logNode(node.id, {
                    endpoint: this.endpointIndex,
                    message: `received current value: ${currentValue}`,
                    direction: "inbound",
                });
            }
        }
        else if (supportedSensorTypes) {
            for (const type of supportedSensorTypes) {
                const sensorName = shared_1.getEnumMemberName(BinarySensorType, type);
                this.driver.controllerLog.logNode(node.id, {
                    endpoint: this.endpointIndex,
                    message: `querying current value for ${sensorName}...`,
                    direction: "outbound",
                });
                const currentValue = await api.get(type);
                if (currentValue != undefined) {
                    this.driver.controllerLog.logNode(node.id, {
                        endpoint: this.endpointIndex,
                        message: `received current value for ${sensorName}: ${currentValue}`,
                        direction: "inbound",
                    });
                }
            }
        }
        // Remember that the interview is complete
        this.interviewComplete = true;
    }
    setMappedBasicValue(value) {
        this.getValueDB().setValue(getBinarySensorValueId(this.endpointIndex, BinarySensorType.Any), value > 0);
        return true;
    }
};
BinarySensorCC = __decorate([
    CommandClass_1.commandClass(core_1.CommandClasses["Binary Sensor"]),
    CommandClass_1.implementedVersion(2)
], BinarySensorCC);
exports.BinarySensorCC = BinarySensorCC;
let BinarySensorCCReport = class BinarySensorCCReport extends BinarySensorCC {
    constructor(driver, options) {
        super(driver, options);
        core_1.validatePayload(this.payload.length >= 1);
        this._value = this.payload[0] === 0xff;
        this._type = BinarySensorType.Any;
        if (this.version >= 2 && this.payload.length >= 2) {
            this._type = this.payload[1];
        }
        this.persistValues();
    }
    persistValues() {
        const valueId = getBinarySensorValueId(this.endpointIndex, this._type);
        this.getValueDB().setMetadata(valueId, {
            ...core_1.ValueMetadata.ReadOnlyBoolean,
            label: shared_1.getEnumMemberName(BinarySensorType, this._type),
            ccSpecific: { sensorType: this._type },
        });
        this.getValueDB().setValue(valueId, this._value);
        return true;
    }
    get type() {
        return this._type;
    }
    get value() {
        return this._value;
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                type: shared_1.getEnumMemberName(BinarySensorType, this._type),
                value: this._value,
            },
        };
    }
};
BinarySensorCCReport = __decorate([
    CommandClass_1.CCCommand(BinarySensorCommand.Report)
], BinarySensorCCReport);
exports.BinarySensorCCReport = BinarySensorCCReport;
function testResponseForBinarySensorGet(sent, received) {
    // We expect a Binary Sensor Report that matches the requested sensor type (if a type was requested)
    return (sent.sensorType == undefined ||
        sent.sensorType === BinarySensorType.Any ||
        received.type === sent.sensorType);
}
let BinarySensorCCGet = class BinarySensorCCGet extends BinarySensorCC {
    constructor(driver, options) {
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            throw new core_1.ZWaveError(`${this.constructor.name}: deserialization not implemented`, core_1.ZWaveErrorCodes.Deserialization_NotImplemented);
        }
        else {
            this.sensorType = options.sensorType;
        }
    }
    serialize() {
        if (this.version >= 2 && this.sensorType != undefined) {
            this.payload = Buffer.from([this.sensorType]);
        }
        return super.serialize();
    }
    toLogEntry() {
        var _b;
        return {
            ...super.toLogEntry(),
            message: {
                type: shared_1.getEnumMemberName(BinarySensorType, (_b = this.sensorType) !== null && _b !== void 0 ? _b : BinarySensorType.Any),
            },
        };
    }
};
BinarySensorCCGet = __decorate([
    CommandClass_1.CCCommand(BinarySensorCommand.Get),
    CommandClass_1.expectedCCResponse(BinarySensorCCReport, testResponseForBinarySensorGet)
], BinarySensorCCGet);
exports.BinarySensorCCGet = BinarySensorCCGet;
let BinarySensorCCSupportedReport = class BinarySensorCCSupportedReport extends BinarySensorCC {
    constructor(driver, options) {
        super(driver, options);
        core_1.validatePayload(this.payload.length >= 1);
        // The enumeration starts at 1, but the first (reserved) bit is included
        // in the report
        this._supportedSensorTypes = core_1.parseBitMask(this.payload, 0).filter((t) => t !== 0);
        this.persistValues();
    }
    get supportedSensorTypes() {
        return this._supportedSensorTypes;
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                "supported types": this._supportedSensorTypes
                    .map((type) => shared_1.getEnumMemberName(BinarySensorType, type))
                    .join(", "),
            },
        };
    }
};
__decorate([
    CommandClass_1.ccValue({ internal: true })
], BinarySensorCCSupportedReport.prototype, "supportedSensorTypes", null);
BinarySensorCCSupportedReport = __decorate([
    CommandClass_1.CCCommand(BinarySensorCommand.SupportedReport)
], BinarySensorCCSupportedReport);
exports.BinarySensorCCSupportedReport = BinarySensorCCSupportedReport;
let BinarySensorCCSupportedGet = class BinarySensorCCSupportedGet extends BinarySensorCC {
};
BinarySensorCCSupportedGet = __decorate([
    CommandClass_1.CCCommand(BinarySensorCommand.SupportedGet),
    CommandClass_1.expectedCCResponse(BinarySensorCCSupportedReport)
], BinarySensorCCSupportedGet);
exports.BinarySensorCCSupportedGet = BinarySensorCCSupportedGet;

//# sourceMappingURL=BinarySensorCC.js.map
