/// <reference types="node" />
import { Duration, Maybe, MessageOrCCLogEntry } from "@zwave-js/core";
import type { Driver } from "../driver/Driver";
import { CCAPI, PollValueImplementation, POLL_VALUE, SetValueImplementation, SET_VALUE } from "./API";
import { CCCommandOptions, CommandClass, CommandClassDeserializationOptions } from "./CommandClass";
export declare enum BinarySwitchCommand {
    Set = 1,
    Get = 2,
    Report = 3
}
export declare class BinarySwitchCCAPI extends CCAPI {
    supportsCommand(cmd: BinarySwitchCommand): Maybe<boolean>;
    get(): Promise<{
        currentValue: Maybe<boolean>;
        targetValue: boolean | undefined;
        duration: Duration | undefined;
    } | undefined>;
    private refreshTimeout;
    /**
     * Sets the switch to the given value
     * @param targetValue The target value to set
     * @param duration The duration after which the target value should be reached. Only supported in V2 and above
     */
    set(targetValue: boolean, duration?: Duration): Promise<void>;
    protected [SET_VALUE]: SetValueImplementation;
    protected [POLL_VALUE]: PollValueImplementation;
}
export declare class BinarySwitchCC extends CommandClass {
    ccCommand: BinarySwitchCommand;
    interview(complete?: boolean): Promise<void>;
    setMappedBasicValue(value: number): boolean;
}
interface BinarySwitchCCSetOptions extends CCCommandOptions {
    targetValue: boolean;
    duration?: Duration;
}
export declare class BinarySwitchCCSet extends BinarySwitchCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | BinarySwitchCCSetOptions);
    targetValue: boolean;
    duration: Duration | undefined;
    serialize(): Buffer;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class BinarySwitchCCReport extends BinarySwitchCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    private _currentValue;
    get currentValue(): Maybe<boolean> | undefined;
    private _targetValue;
    get targetValue(): boolean | undefined;
    private _duration;
    get duration(): Duration | undefined;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class BinarySwitchCCGet extends BinarySwitchCC {
}
export {};
