"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClimateControlScheduleCCOverrideSet = exports.ClimateControlScheduleCCOverrideGet = exports.ClimateControlScheduleCCOverrideReport = exports.ClimateControlScheduleCCChangedGet = exports.ClimateControlScheduleCCChangedReport = exports.ClimateControlScheduleCCGet = exports.ClimateControlScheduleCCReport = exports.ClimateControlScheduleCCSet = exports.ClimateControlScheduleCC = exports.ClimateControlScheduleCCAPI = exports.ScheduleOverrideType = exports.ClimateControlScheduleCommand = void 0;
const core_1 = require("@zwave-js/core");
const shared_1 = require("@zwave-js/shared");
const strings_1 = require("alcalzone-shared/strings");
const SetbackState_1 = require("../values/SetbackState");
const Switchpoint_1 = require("../values/Switchpoint");
const API_1 = require("./API");
const ClockCC_1 = require("./ClockCC");
const CommandClass_1 = require("./CommandClass");
var ClimateControlScheduleCommand;
(function (ClimateControlScheduleCommand) {
    ClimateControlScheduleCommand[ClimateControlScheduleCommand["Set"] = 1] = "Set";
    ClimateControlScheduleCommand[ClimateControlScheduleCommand["Get"] = 2] = "Get";
    ClimateControlScheduleCommand[ClimateControlScheduleCommand["Report"] = 3] = "Report";
    ClimateControlScheduleCommand[ClimateControlScheduleCommand["ChangedGet"] = 4] = "ChangedGet";
    ClimateControlScheduleCommand[ClimateControlScheduleCommand["ChangedReport"] = 5] = "ChangedReport";
    ClimateControlScheduleCommand[ClimateControlScheduleCommand["OverrideSet"] = 6] = "OverrideSet";
    ClimateControlScheduleCommand[ClimateControlScheduleCommand["OverrideGet"] = 7] = "OverrideGet";
    ClimateControlScheduleCommand[ClimateControlScheduleCommand["OverrideReport"] = 8] = "OverrideReport";
})(ClimateControlScheduleCommand = exports.ClimateControlScheduleCommand || (exports.ClimateControlScheduleCommand = {}));
/**
 * @publicAPI
 */
var ScheduleOverrideType;
(function (ScheduleOverrideType) {
    ScheduleOverrideType[ScheduleOverrideType["None"] = 0] = "None";
    ScheduleOverrideType[ScheduleOverrideType["Temporary"] = 1] = "Temporary";
    ScheduleOverrideType[ScheduleOverrideType["Permanent"] = 2] = "Permanent";
})(ScheduleOverrideType = exports.ScheduleOverrideType || (exports.ScheduleOverrideType = {}));
let ClimateControlScheduleCCAPI = class ClimateControlScheduleCCAPI extends API_1.CCAPI {
    supportsCommand(cmd) {
        switch (cmd) {
            case ClimateControlScheduleCommand.Set:
            case ClimateControlScheduleCommand.OverrideSet:
                return true; // mandatory
            case ClimateControlScheduleCommand.Get:
            case ClimateControlScheduleCommand.ChangedGet:
            case ClimateControlScheduleCommand.OverrideGet:
                return this.isSinglecast();
        }
        return super.supportsCommand(cmd);
    }
    async set(weekday, switchPoints) {
        this.assertSupportsCommand(ClimateControlScheduleCommand, ClimateControlScheduleCommand.Set);
        const cc = new ClimateControlScheduleCCSet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
            weekday,
            switchPoints,
        });
        await this.driver.sendCommand(cc, this.commandOptions);
    }
    async get(weekday) {
        this.assertSupportsCommand(ClimateControlScheduleCommand, ClimateControlScheduleCommand.Get);
        const cc = new ClimateControlScheduleCCGet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
            weekday,
        });
        const response = await this.driver.sendCommand(cc, this.commandOptions);
        return response === null || response === void 0 ? void 0 : response.switchPoints;
    }
    async getChangeCounter() {
        this.assertSupportsCommand(ClimateControlScheduleCommand, ClimateControlScheduleCommand.ChangedGet);
        const cc = new ClimateControlScheduleCCChangedGet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
        });
        const response = await this.driver.sendCommand(cc, this.commandOptions);
        return response === null || response === void 0 ? void 0 : response.changeCounter;
    }
    // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
    async getOverride() {
        this.assertSupportsCommand(ClimateControlScheduleCommand, ClimateControlScheduleCommand.OverrideGet);
        const cc = new ClimateControlScheduleCCOverrideGet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
        });
        const response = await this.driver.sendCommand(cc, this.commandOptions);
        if (response) {
            return {
                type: response.overrideType,
                state: response.overrideState,
            };
        }
    }
    async setOverride(type, state) {
        this.assertSupportsCommand(ClimateControlScheduleCommand, ClimateControlScheduleCommand.OverrideSet);
        const cc = new ClimateControlScheduleCCOverrideSet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
            overrideType: type,
            overrideState: state,
        });
        await this.driver.sendCommand(cc, this.commandOptions);
    }
};
ClimateControlScheduleCCAPI = __decorate([
    CommandClass_1.API(core_1.CommandClasses["Climate Control Schedule"])
], ClimateControlScheduleCCAPI);
exports.ClimateControlScheduleCCAPI = ClimateControlScheduleCCAPI;
let ClimateControlScheduleCC = class ClimateControlScheduleCC extends CommandClass_1.CommandClass {
};
ClimateControlScheduleCC = __decorate([
    CommandClass_1.commandClass(core_1.CommandClasses["Climate Control Schedule"]),
    CommandClass_1.implementedVersion(1)
], ClimateControlScheduleCC);
exports.ClimateControlScheduleCC = ClimateControlScheduleCC;
let ClimateControlScheduleCCSet = class ClimateControlScheduleCCSet extends ClimateControlScheduleCC {
    constructor(driver, options) {
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            throw new core_1.ZWaveError(`${this.constructor.name}: deserialization not implemented`, core_1.ZWaveErrorCodes.Deserialization_NotImplemented);
        }
        else {
            this.switchPoints = options.switchPoints;
            this.weekday = options.weekday;
        }
    }
    serialize() {
        // Make sure we have exactly 9 entries
        const allSwitchPoints = this.switchPoints.slice(0, 9); // maximum 9
        while (allSwitchPoints.length < 9) {
            allSwitchPoints.push({
                hour: 0,
                minute: 0,
                state: "Unused",
            });
        }
        this.payload = Buffer.concat([
            Buffer.from([this.weekday & 0b111]),
            ...allSwitchPoints.map((sp) => Switchpoint_1.encodeSwitchpoint(sp)),
        ]);
        return super.serialize();
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                weekday: shared_1.getEnumMemberName(ClockCC_1.Weekday, this.weekday),
                switchpoints: `${this.switchPoints
                    .map((sp) => `
· ${strings_1.padStart(sp.hour.toString(), 2, "0")}:${strings_1.padStart(sp.minute.toString(), 2, "0")} --> ${sp.state}`)
                    .join("")}`,
            },
        };
    }
};
ClimateControlScheduleCCSet = __decorate([
    CommandClass_1.CCCommand(ClimateControlScheduleCommand.Set)
], ClimateControlScheduleCCSet);
exports.ClimateControlScheduleCCSet = ClimateControlScheduleCCSet;
let ClimateControlScheduleCCReport = class ClimateControlScheduleCCReport extends ClimateControlScheduleCC {
    constructor(driver, options) {
        super(driver, options);
        core_1.validatePayload(this.payload.length >= 28); // 1 + 9 * 3
        const weekday = this.payload[0] & 0b111;
        const allSwitchpoints = [];
        for (let i = 0; i <= 8; i++) {
            allSwitchpoints.push(Switchpoint_1.decodeSwitchpoint(this.payload.slice(1 + 3 * i)));
        }
        const switchPoints = allSwitchpoints.filter((sp) => sp.state !== "Unused");
        this.schedule = [weekday, switchPoints];
        this.persistValues();
    }
    get switchPoints() {
        return this.schedule[1];
    }
    get weekday() {
        return this.schedule[0];
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                weekday: shared_1.getEnumMemberName(ClockCC_1.Weekday, this.weekday),
                switchpoints: `${this.switchPoints
                    .map((sp) => `
· ${strings_1.padStart(sp.hour.toString(), 2, "0")}:${strings_1.padStart(sp.minute.toString(), 2, "0")} --> ${sp.state}`)
                    .join("")}`,
            },
        };
    }
};
__decorate([
    CommandClass_1.ccKeyValuePair()
], ClimateControlScheduleCCReport.prototype, "schedule", void 0);
ClimateControlScheduleCCReport = __decorate([
    CommandClass_1.CCCommand(ClimateControlScheduleCommand.Report)
], ClimateControlScheduleCCReport);
exports.ClimateControlScheduleCCReport = ClimateControlScheduleCCReport;
let ClimateControlScheduleCCGet = class ClimateControlScheduleCCGet extends ClimateControlScheduleCC {
    constructor(driver, options) {
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            throw new core_1.ZWaveError(`${this.constructor.name}: deserialization not implemented`, core_1.ZWaveErrorCodes.Deserialization_NotImplemented);
        }
        else {
            this.weekday = options.weekday;
        }
    }
    serialize() {
        this.payload = Buffer.from([this.weekday & 0b111]);
        return super.serialize();
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: { weekday: shared_1.getEnumMemberName(ClockCC_1.Weekday, this.weekday) },
        };
    }
};
ClimateControlScheduleCCGet = __decorate([
    CommandClass_1.CCCommand(ClimateControlScheduleCommand.Get),
    CommandClass_1.expectedCCResponse(ClimateControlScheduleCCReport)
], ClimateControlScheduleCCGet);
exports.ClimateControlScheduleCCGet = ClimateControlScheduleCCGet;
let ClimateControlScheduleCCChangedReport = class ClimateControlScheduleCCChangedReport extends ClimateControlScheduleCC {
    constructor(driver, options) {
        super(driver, options);
        core_1.validatePayload(this.payload.length >= 1);
        this._changeCounter = this.payload[0];
        this.persistValues();
    }
    get changeCounter() {
        return this._changeCounter;
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: { "change counter": this.changeCounter },
        };
    }
};
__decorate([
    CommandClass_1.ccValue()
], ClimateControlScheduleCCChangedReport.prototype, "changeCounter", null);
ClimateControlScheduleCCChangedReport = __decorate([
    CommandClass_1.CCCommand(ClimateControlScheduleCommand.ChangedReport)
], ClimateControlScheduleCCChangedReport);
exports.ClimateControlScheduleCCChangedReport = ClimateControlScheduleCCChangedReport;
let ClimateControlScheduleCCChangedGet = class ClimateControlScheduleCCChangedGet extends ClimateControlScheduleCC {
};
ClimateControlScheduleCCChangedGet = __decorate([
    CommandClass_1.CCCommand(ClimateControlScheduleCommand.ChangedGet),
    CommandClass_1.expectedCCResponse(ClimateControlScheduleCCChangedReport)
], ClimateControlScheduleCCChangedGet);
exports.ClimateControlScheduleCCChangedGet = ClimateControlScheduleCCChangedGet;
let ClimateControlScheduleCCOverrideReport = class ClimateControlScheduleCCOverrideReport extends ClimateControlScheduleCC {
    constructor(driver, options) {
        super(driver, options);
        core_1.validatePayload(this.payload.length >= 2);
        this._overrideType = this.payload[0] & 0b11;
        this._overrideState =
            SetbackState_1.decodeSetbackState(this.payload[1]) || this.payload[1];
        this.persistValues();
    }
    get overrideType() {
        return this._overrideType;
    }
    get overrideState() {
        return this._overrideState;
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                "override type": shared_1.getEnumMemberName(ScheduleOverrideType, this._overrideType),
                "override state": this._overrideState,
            },
        };
    }
};
__decorate([
    CommandClass_1.ccValue()
], ClimateControlScheduleCCOverrideReport.prototype, "overrideType", null);
__decorate([
    CommandClass_1.ccValue()
], ClimateControlScheduleCCOverrideReport.prototype, "overrideState", null);
ClimateControlScheduleCCOverrideReport = __decorate([
    CommandClass_1.CCCommand(ClimateControlScheduleCommand.OverrideReport)
], ClimateControlScheduleCCOverrideReport);
exports.ClimateControlScheduleCCOverrideReport = ClimateControlScheduleCCOverrideReport;
let ClimateControlScheduleCCOverrideGet = class ClimateControlScheduleCCOverrideGet extends ClimateControlScheduleCC {
};
ClimateControlScheduleCCOverrideGet = __decorate([
    CommandClass_1.CCCommand(ClimateControlScheduleCommand.OverrideGet),
    CommandClass_1.expectedCCResponse(ClimateControlScheduleCCOverrideReport)
], ClimateControlScheduleCCOverrideGet);
exports.ClimateControlScheduleCCOverrideGet = ClimateControlScheduleCCOverrideGet;
let ClimateControlScheduleCCOverrideSet = class ClimateControlScheduleCCOverrideSet extends ClimateControlScheduleCC {
    constructor(driver, options) {
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            throw new core_1.ZWaveError(`${this.constructor.name}: deserialization not implemented`, core_1.ZWaveErrorCodes.Deserialization_NotImplemented);
        }
        else {
            this.overrideType = options.overrideType;
            this.overrideState = options.overrideState;
        }
    }
    serialize() {
        this.payload = Buffer.from([
            this.overrideType & 0b11,
            SetbackState_1.encodeSetbackState(this.overrideState),
        ]);
        return super.serialize();
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                "override type": shared_1.getEnumMemberName(ScheduleOverrideType, this.overrideType),
                "override state": this.overrideState,
            },
        };
    }
};
ClimateControlScheduleCCOverrideSet = __decorate([
    CommandClass_1.CCCommand(ClimateControlScheduleCommand.OverrideSet)
], ClimateControlScheduleCCOverrideSet);
exports.ClimateControlScheduleCCOverrideSet = ClimateControlScheduleCCOverrideSet;

//# sourceMappingURL=ClimateControlScheduleCC.js.map
