/// <reference types="node" />
import type { MessageOrCCLogEntry } from "@zwave-js/core";
import { Duration, Maybe } from "@zwave-js/core";
import type { Driver } from "../driver/Driver";
import { PhysicalCCAPI, PollValueImplementation, POLL_VALUE, SetValueImplementation, SET_VALUE } from "./API";
import { CCCommandOptions, CommandClass, CommandClassDeserializationOptions } from "./CommandClass";
export declare enum DoorLockCommand {
    OperationSet = 1,
    OperationGet = 2,
    OperationReport = 3,
    ConfigurationSet = 4,
    ConfigurationGet = 5,
    ConfigurationReport = 6,
    CapabilitiesGet = 7,
    CapabilitiesReport = 8
}
export declare enum DoorLockMode {
    Unsecured = 0,
    UnsecuredWithTimeout = 1,
    InsideUnsecured = 16,
    InsideUnsecuredWithTimeout = 17,
    OutsideUnsecured = 32,
    OutsideUnsecuredWithTimeout = 33,
    Unknown = 254,
    Secured = 255
}
export declare enum DoorLockOperationType {
    Constant = 1,
    Timed = 2
}
export declare type DoorHandleStatus = [boolean, boolean, boolean, boolean];
export declare class DoorLockCCAPI extends PhysicalCCAPI {
    supportsCommand(cmd: DoorLockCommand): Maybe<boolean>;
    protected [SET_VALUE]: SetValueImplementation;
    protected [POLL_VALUE]: PollValueImplementation;
    getCapabilities(): Promise<Pick<DoorLockCCCapabilitiesReport, "autoRelockSupported" | "blockToBlockSupported" | "boltSupported" | "doorSupported" | "holdAndReleaseSupported" | "latchSupported" | "twistAssistSupported" | "supportedDoorLockModes" | "supportedInsideHandles" | "supportedOperationTypes" | "supportedOutsideHandles"> | undefined>;
    private refreshTimeout;
    get(): Promise<Pick<DoorLockCCOperationReport, "duration" | "targetMode" | "currentMode" | "outsideHandlesCanOpenDoor" | "insideHandlesCanOpenDoor" | "latchStatus" | "boltStatus" | "doorStatus" | "lockTimeout"> | undefined>;
    set(mode: DoorLockMode): Promise<void>;
    setConfiguration(configuration: DoorLockCCConfigurationSetOptions): Promise<void>;
    getConfiguration(): Promise<Pick<DoorLockCCConfigurationReport, "operationType" | "outsideHandlesCanOpenDoorConfiguration" | "insideHandlesCanOpenDoorConfiguration" | "lockTimeoutConfiguration" | "autoRelockTime" | "holdAndReleaseTime" | "twistAssist" | "blockToBlock"> | undefined>;
}
export declare class DoorLockCC extends CommandClass {
    ccCommand: DoorLockCommand;
    interview(complete?: boolean): Promise<void>;
}
interface DoorLockCCOperationSetOptions extends CCCommandOptions {
    mode: DoorLockMode;
}
export declare class DoorLockCCOperationSet extends DoorLockCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | DoorLockCCOperationSetOptions);
    mode: DoorLockMode;
    serialize(): Buffer;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class DoorLockCCOperationReport extends DoorLockCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    readonly currentMode: DoorLockMode;
    readonly targetMode?: DoorLockMode;
    readonly duration?: Duration;
    readonly outsideHandlesCanOpenDoor: DoorHandleStatus;
    readonly insideHandlesCanOpenDoor: DoorHandleStatus;
    readonly latchStatus: "open" | "closed";
    readonly boltStatus: "locked" | "unlocked";
    readonly doorStatus: "open" | "closed";
    readonly lockTimeout?: number;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class DoorLockCCOperationGet extends DoorLockCC {
}
export declare class DoorLockCCConfigurationReport extends DoorLockCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    readonly operationType: DoorLockOperationType;
    readonly outsideHandlesCanOpenDoorConfiguration: DoorHandleStatus;
    readonly insideHandlesCanOpenDoorConfiguration: DoorHandleStatus;
    readonly lockTimeoutConfiguration?: number;
    readonly autoRelockTime?: number;
    readonly holdAndReleaseTime?: number;
    readonly twistAssist?: boolean;
    readonly blockToBlock?: boolean;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class DoorLockCCConfigurationGet extends DoorLockCC {
}
declare type DoorLockCCConfigurationSetOptions = ({
    operationType: DoorLockOperationType.Timed;
    lockTimeoutConfiguration: number;
} | {
    operationType: DoorLockOperationType.Constant;
    lockTimeoutConfiguration?: undefined;
}) & {
    outsideHandlesCanOpenDoorConfiguration: DoorHandleStatus;
    insideHandlesCanOpenDoorConfiguration: DoorHandleStatus;
    autoRelockTime?: number;
    holdAndReleaseTime?: number;
    twistAssist?: boolean;
    blockToBlock?: boolean;
};
export declare class DoorLockCCConfigurationSet extends DoorLockCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | (CCCommandOptions & DoorLockCCConfigurationSetOptions));
    operationType: DoorLockOperationType;
    outsideHandlesCanOpenDoorConfiguration: DoorHandleStatus;
    insideHandlesCanOpenDoorConfiguration: DoorHandleStatus;
    lockTimeoutConfiguration?: number;
    autoRelockTime?: number;
    holdAndReleaseTime?: number;
    twistAssist?: boolean;
    blockToBlock?: boolean;
    serialize(): Buffer;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class DoorLockCCCapabilitiesReport extends DoorLockCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    readonly supportedOperationTypes: readonly DoorLockOperationType[];
    readonly supportedDoorLockModes: readonly DoorLockMode[];
    readonly supportedOutsideHandles: DoorHandleStatus;
    readonly supportedInsideHandles: DoorHandleStatus;
    readonly latchSupported: boolean;
    readonly boltSupported: boolean;
    readonly doorSupported: boolean;
    readonly autoRelockSupported: boolean;
    readonly holdAndReleaseSupported: boolean;
    readonly twistAssistSupported: boolean;
    readonly blockToBlockSupported: boolean;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class DoorLockCCCapabilitiesGet extends DoorLockCC {
}
export {};
