/// <reference types="node" />
import type { MessageOrCCLogEntry, ValueID } from "@zwave-js/core";
import { Maybe, ValueMetadata } from "@zwave-js/core";
import type { Driver } from "../driver/Driver";
import { CCAPI, PollValueImplementation, POLL_VALUE, SetValueImplementation, SET_VALUE } from "./API";
import { CCCommandOptions, CommandClass, CommandClassDeserializationOptions, CommandClassOptions } from "./CommandClass";
/**
 * @publicAPI
 */
export declare type IndicatorMetadata = ValueMetadata & {
    ccSpecific: {
        indicatorId: number;
        propertyId?: number;
    };
};
export declare function getSupportedIndicatorIDsValueID(endpoint: number | undefined): ValueID;
export declare function getSupportedPropertyIDsValueID(endpoint: number | undefined, indicatorId: number): ValueID;
export declare function getIndicatorValueValueID(endpoint: number | undefined, indicatorId: number, propertyId: number): ValueID;
export declare enum IndicatorCommand {
    Set = 1,
    Get = 2,
    Report = 3,
    SupportedGet = 4,
    SupportedReport = 5
}
export declare class IndicatorCCAPI extends CCAPI {
    supportsCommand(cmd: IndicatorCommand): Maybe<boolean>;
    protected [SET_VALUE]: SetValueImplementation;
    protected [POLL_VALUE]: PollValueImplementation;
    get(indicatorId?: number): Promise<number | IndicatorObject[] | undefined>;
    set(value: number | IndicatorObject[]): Promise<void>;
    getSupported(indicatorId: number): Promise<{
        indicatorId?: number;
        supportedProperties: readonly number[];
        nextIndicatorId: number;
    } | undefined>;
    /**
     * Instructs the node to identify itself. Available starting with V3 of this CC.
     */
    identify(): Promise<void>;
}
export declare class IndicatorCC extends CommandClass {
    ccCommand: IndicatorCommand;
    constructor(driver: Driver, options: CommandClassOptions);
    interview(complete?: boolean): Promise<void>;
    translatePropertyKey(property: string | number, propertyKey: string | number): string | undefined;
    translateProperty(property: string | number, propertyKey?: string | number): string;
    protected supportsV2Indicators(): boolean;
}
export interface IndicatorObject {
    indicatorId: number;
    propertyId: number;
    value: number | boolean;
}
declare type IndicatorCCSetOptions = {
    value: number;
} | {
    values: IndicatorObject[];
};
export declare class IndicatorCCSet extends IndicatorCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | (IndicatorCCSetOptions & CCCommandOptions));
    indicator0Value: number | undefined;
    values: IndicatorObject[] | undefined;
    serialize(): Buffer;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class IndicatorCCReport extends IndicatorCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    readonly value: number | undefined;
    readonly values: IndicatorObject[] | undefined;
    private setIndicatorValue;
    toLogEntry(): MessageOrCCLogEntry;
}
interface IndicatorCCGetOptions extends CCCommandOptions {
    indicatorId?: number;
}
export declare class IndicatorCCGet extends IndicatorCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | IndicatorCCGetOptions);
    indicatorId: number | undefined;
    serialize(): Buffer;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class IndicatorCCSupportedReport extends IndicatorCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    persistValues(): boolean;
    readonly indicatorId: number;
    readonly nextIndicatorId: number;
    readonly supportedProperties: readonly number[];
    toLogEntry(): MessageOrCCLogEntry;
}
interface IndicatorCCSupportedGetOptions extends CCCommandOptions {
    indicatorId: number;
}
export declare class IndicatorCCSupportedGet extends IndicatorCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | IndicatorCCSupportedGetOptions);
    indicatorId: number;
    serialize(): Buffer;
    toLogEntry(): MessageOrCCLogEntry;
}
export {};
