"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MeterCCReset = exports.MeterCCSupportedGet = exports.MeterCCSupportedReport = exports.MeterCCGet = exports.MeterCCReport = exports.MeterCC = exports.MeterCCAPI = exports.getResetValueId = exports.getSupportedRateTypesValueId = exports.getSupportedScalesValueId = exports.getSupportsResetValueId = exports.getTypeValueId = exports.RateType = exports.MeterCommand = void 0;
const core_1 = require("@zwave-js/core");
const shared_1 = require("@zwave-js/shared");
const Constants_1 = require("../message/Constants");
const API_1 = require("./API");
const CommandClass_1 = require("./CommandClass");
// All the supported commands
var MeterCommand;
(function (MeterCommand) {
    MeterCommand[MeterCommand["Get"] = 1] = "Get";
    MeterCommand[MeterCommand["Report"] = 2] = "Report";
    MeterCommand[MeterCommand["SupportedGet"] = 3] = "SupportedGet";
    MeterCommand[MeterCommand["SupportedReport"] = 4] = "SupportedReport";
    MeterCommand[MeterCommand["Reset"] = 5] = "Reset";
})(MeterCommand = exports.MeterCommand || (exports.MeterCommand = {}));
/**
 * @publicAPI
 */
var RateType;
(function (RateType) {
    RateType[RateType["Unspecified"] = 0] = "Unspecified";
    RateType[RateType["Consumed"] = 1] = "Consumed";
    RateType[RateType["Produced"] = 2] = "Produced";
})(RateType = exports.RateType || (exports.RateType = {}));
function toPropertyKey(meterType, rateType, scale) {
    return (meterType << 16) | (scale << 8) | rateType;
}
function splitPropertyKey(key) {
    return {
        rateType: key & 0xff,
        scale: (key >>> 8) & 0xff,
        meterType: key >>> 16,
    };
}
function getMeterTypeName(configManager, type) {
    var _c, _d;
    return ((_d = (_c = configManager.lookupMeter(type)) === null || _c === void 0 ? void 0 : _c.name) !== null && _d !== void 0 ? _d : `UNKNOWN (${shared_1.num2hex(type)})`);
}
function getTypeValueId(endpoint) {
    return {
        commandClass: core_1.CommandClasses.Meter,
        endpoint,
        property: "type",
    };
}
exports.getTypeValueId = getTypeValueId;
function getSupportsResetValueId(endpoint) {
    return {
        commandClass: core_1.CommandClasses.Meter,
        endpoint,
        property: "supportsReset",
    };
}
exports.getSupportsResetValueId = getSupportsResetValueId;
function getSupportedScalesValueId(endpoint) {
    return {
        commandClass: core_1.CommandClasses.Meter,
        endpoint,
        property: "supportedScales",
    };
}
exports.getSupportedScalesValueId = getSupportedScalesValueId;
function getSupportedRateTypesValueId(endpoint) {
    return {
        commandClass: core_1.CommandClasses.Meter,
        endpoint,
        property: "supportedRateTypes",
    };
}
exports.getSupportedRateTypesValueId = getSupportedRateTypesValueId;
function getResetValueId(endpoint, type) {
    return {
        commandClass: core_1.CommandClasses.Meter,
        endpoint,
        property: "reset",
        propertyKey: type,
    };
}
exports.getResetValueId = getResetValueId;
function getValueLabel(configManager, meterType, scale, rateType, suffix) {
    let ret = getMeterTypeName(configManager, meterType);
    if (rateType !== RateType.Unspecified) {
        ret += ` ${shared_1.getEnumMemberName(RateType, rateType)}`;
    }
    ret += ` [${scale.label}]`;
    if (suffix) {
        ret += ` (${suffix})`;
    }
    return ret;
}
let MeterCCAPI = class MeterCCAPI extends API_1.PhysicalCCAPI {
    constructor() {
        super(...arguments);
        this[_a] = async ({ property, propertyKey, }) => {
            var _c;
            switch (property) {
                case "value":
                case "previousValue":
                case "deltaTime": {
                    if (propertyKey == undefined) {
                        API_1.throwMissingPropertyKey(this.ccId, property);
                    }
                    else if (typeof propertyKey !== "number") {
                        API_1.throwUnsupportedPropertyKey(this.ccId, property, propertyKey);
                    }
                    const { rateType, scale } = splitPropertyKey(propertyKey);
                    return (_c = (await this.get({
                        rateType,
                        scale,
                    }))) === null || _c === void 0 ? void 0 : _c[property];
                }
                default:
                    API_1.throwUnsupportedProperty(this.ccId, property);
            }
        };
        this[_b] = async ({ property, propertyKey }, value) => {
            if (property !== "reset") {
                API_1.throwUnsupportedProperty(this.ccId, property);
            }
            else if (propertyKey != undefined &&
                typeof propertyKey !== "number") {
                API_1.throwUnsupportedPropertyKey(this.ccId, property, propertyKey);
            }
            else if (value !== true) {
                API_1.throwWrongValueType(this.ccId, property, "true", value === false ? "false" : typeof value);
            }
            const resetOptions = propertyKey != undefined
                ? {
                    type: propertyKey,
                    targetValue: 0,
                }
                : {};
            await this.reset(resetOptions);
            // Refresh values
            await this.getAll();
        };
    }
    supportsCommand(cmd) {
        switch (cmd) {
            case MeterCommand.Get:
                return true; // This is mandatory
            case MeterCommand.SupportedGet:
                return this.version >= 2;
            case MeterCommand.Reset: {
                const node = this.endpoint.getNodeUnsafe();
                const ret = node.getValue({
                    commandClass: CommandClass_1.getCommandClass(this),
                    endpoint: this.endpoint.index,
                    property: "supportsReset",
                });
                return ret === true;
            }
        }
        return super.supportsCommand(cmd);
    }
    // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
    async get(options) {
        this.assertSupportsCommand(MeterCommand, MeterCommand.Get);
        const cc = new MeterCCGet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
            ...options,
        });
        const response = await this.driver.sendCommand(cc, this.commandOptions);
        if (response) {
            return shared_1.pick(response, [
                "type",
                "scale",
                "value",
                "previousValue",
                "rateType",
                "deltaTime",
            ]);
        }
    }
    // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
    async getAll() {
        var _c, _d;
        const node = this.endpoint.getNodeUnsafe();
        if (this.version >= 2) {
            const supportedScales = (_c = node.getValue(getSupportedScalesValueId(this.endpoint.index))) !== null && _c !== void 0 ? _c : [];
            const supportedRateTypes = (_d = node.getValue(getSupportedRateTypesValueId(this.endpoint.index))) !== null && _d !== void 0 ? _d : [];
            const rateTypes = supportedRateTypes.length
                ? supportedRateTypes
                : [undefined];
            const ret = [];
            for (const rateType of rateTypes) {
                for (const scale of supportedScales) {
                    const response = await this.get({
                        scale,
                        rateType,
                    });
                    if (response)
                        ret.push(response);
                }
            }
            return ret;
        }
        else {
            const response = await this.get();
            return response ? [response] : [];
        }
    }
    // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
    async getSupported() {
        this.assertSupportsCommand(MeterCommand, MeterCommand.SupportedGet);
        const cc = new MeterCCSupportedGet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
        });
        const response = await this.driver.sendCommand(cc, this.commandOptions);
        if (response) {
            return shared_1.pick(response, [
                "type",
                "supportsReset",
                "supportedScales",
                "supportedRateTypes",
            ]);
        }
    }
    async reset(options) {
        this.assertSupportsCommand(MeterCommand, MeterCommand.Reset);
        const cc = new MeterCCReset(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
            ...options,
        });
        await this.driver.sendCommand(cc, this.commandOptions);
    }
};
_a = API_1.POLL_VALUE, _b = API_1.SET_VALUE;
MeterCCAPI = __decorate([
    CommandClass_1.API(core_1.CommandClasses.Meter)
], MeterCCAPI);
exports.MeterCCAPI = MeterCCAPI;
let MeterCC = class MeterCC extends CommandClass_1.CommandClass {
    async interview(complete = true) {
        var _c, _d;
        const node = this.getNode();
        const endpoint = this.getEndpoint();
        const api = endpoint.commandClasses.Meter.withOptions({
            priority: Constants_1.MessagePriority.NodeQuery,
        });
        this.driver.controllerLog.logNode(node.id, {
            endpoint: this.endpointIndex,
            message: `${this.constructor.name}: doing a ${complete ? "complete" : "partial"} interview...`,
            direction: "none",
        });
        if (this.version >= 2) {
            let type;
            let supportsReset;
            let supportedScales;
            let supportedRateTypes;
            const storedType = node.getValue(getTypeValueId(this.endpointIndex));
            if (complete || storedType == undefined) {
                this.driver.controllerLog.logNode(node.id, {
                    endpoint: this.endpointIndex,
                    message: "querying meter support...",
                    direction: "outbound",
                });
                const suppResp = await api.getSupported();
                if (suppResp) {
                    type = suppResp.type;
                    supportsReset = suppResp.supportsReset;
                    supportedScales = suppResp.supportedScales;
                    supportedRateTypes = suppResp.supportedRateTypes;
                    const logMessage = `received meter support:
type:                 ${getMeterTypeName(this.driver.configManager, type)}
supported scales:     ${supportedScales
                        .map((s) => this.driver.configManager.lookupMeterScale(type, s).label)
                        .map((label) => `\n· ${label}`)
                        .join("")}
supported rate types: ${supportedRateTypes
                        .map((rt) => shared_1.getEnumMemberName(RateType, rt))
                        .map((label) => `\n· ${label}`)
                        .join("")}
supports reset:       ${supportsReset}`;
                    this.driver.controllerLog.logNode(node.id, {
                        endpoint: this.endpointIndex,
                        message: logMessage,
                        direction: "inbound",
                    });
                }
                else {
                    this.driver.controllerLog.logNode(node.id, {
                        endpoint: this.endpointIndex,
                        message: "Querying meter support timed out, skipping interview...",
                        level: "warn",
                    });
                    return;
                }
            }
            else {
                type = storedType;
                // supportsReset =
                // 	node.getValue(
                // 		getSupportsResetValueId(this.endpointIndex),
                // 	) ?? false;
                supportedScales = (_c = node.getValue(getSupportedScalesValueId(this.endpointIndex))) !== null && _c !== void 0 ? _c : [];
                supportedRateTypes = (_d = node.getValue(getSupportedRateTypesValueId(this.endpointIndex))) !== null && _d !== void 0 ? _d : [];
            }
            const rateTypes = supportedRateTypes.length
                ? supportedRateTypes
                : [undefined];
            for (const rateType of rateTypes) {
                for (const scale of supportedScales) {
                    this.driver.controllerLog.logNode(node.id, {
                        endpoint: this.endpointIndex,
                        message: `querying meter value (type = ${getMeterTypeName(this.driver.configManager, type)}, scale = ${this.driver.configManager.lookupMeterScale(type, scale).label}${rateType != undefined
                            ? `, rate type = ${shared_1.getEnumMemberName(RateType, rateType)}`
                            : ""})...`,
                        direction: "outbound",
                    });
                    await api.get({ scale, rateType });
                }
            }
        }
        else {
            this.driver.controllerLog.logNode(node.id, {
                endpoint: this.endpointIndex,
                message: `querying default meter value...`,
                direction: "outbound",
            });
            await api.get();
        }
        // Remember that the interview is complete
        this.interviewComplete = true;
    }
    translatePropertyKey(property, propertyKey) {
        if ((property === "value" ||
            property === "previousValue" ||
            property === "deltaTime") &&
            typeof propertyKey === "number") {
            const { meterType, rateType, scale } = splitPropertyKey(propertyKey);
            let ret;
            if (meterType !== 0) {
                ret = `${this.driver.configManager.getMeterName(meterType)}_${this.driver.configManager.lookupMeterScale(meterType, scale)
                    .label}`;
            }
            else {
                ret = "default";
            }
            if (rateType !== RateType.Unspecified) {
                ret += "_" + shared_1.getEnumMemberName(RateType, rateType);
            }
            return ret;
        }
        else if (property === "reset" && typeof propertyKey === "number") {
            return getMeterTypeName(this.driver.configManager, propertyKey);
        }
        return super.translatePropertyKey(property, propertyKey);
    }
};
MeterCC = __decorate([
    CommandClass_1.commandClass(core_1.CommandClasses.Meter),
    CommandClass_1.implementedVersion(6)
], MeterCC);
exports.MeterCC = MeterCC;
let MeterCCReport = class MeterCCReport extends MeterCC {
    constructor(driver, options) {
        super(driver, options);
        core_1.validatePayload(this.payload.length >= 2);
        this._type = this.payload[0] & 31;
        this._rateType = (this.payload[0] & 96) >>> 5;
        const scale1Bit2 = (this.payload[0] & 128) >>> 7;
        const { scale: scale1Bits10, value, bytesRead } = core_1.parseFloatWithScale(this.payload.slice(1));
        let offset = 2 + (bytesRead - 1);
        // The scale is composed of two fields (see SDS13781)
        const scale1 = (scale1Bit2 << 2) | scale1Bits10;
        let scale2 = 0;
        this._value = value;
        if (this.version >= 2 && this.payload.length >= offset + 2) {
            this._deltaTime = this.payload.readUInt16BE(offset);
            offset += 2;
            if (this._deltaTime === 0xffff) {
                this._deltaTime = core_1.unknownNumber;
            }
            if (
            // 0 means that no previous value is included
            this.deltaTime !== 0 &&
                this.payload.length >= offset + (bytesRead - 1)) {
                const { value: prevValue } = core_1.parseFloatWithScale(
                // This float is split in the payload
                Buffer.concat([
                    Buffer.from([this.payload[1]]),
                    this.payload.slice(offset),
                ]));
                offset += bytesRead - 1;
                this._previousValue = prevValue;
            }
            if (this.version >= 4 &&
                scale1 === 7 &&
                this.payload.length >= offset + 1) {
                scale2 = this.payload[offset];
            }
        }
        else {
            // 0 means that no previous value is included
            this._deltaTime = 0;
        }
        const scale = scale1 === 7 ? scale1 + scale2 : scale1;
        this._scale = this.driver.configManager.lookupMeterScale(this._type, scale);
        this.persistValues();
    }
    persistValues() {
        const valueIdBase = {
            commandClass: this.ccId,
            endpoint: this.endpointIndex,
            propertyKey: toPropertyKey(this._type, this._rateType, this._scale.key),
        };
        const ccSpecific = {
            meterType: this._type,
            rateType: this._rateType,
            scale: this._scale.key,
        };
        const valueDB = this.getValueDB();
        const valueValueId = { ...valueIdBase, property: "value" };
        const previousValueValueID = {
            ...valueIdBase,
            property: "previousValue",
        };
        const deltaTimeValueId = { ...valueIdBase, property: "deltaTime" };
        // Always create metadata if it does not exist
        if (!valueDB.hasMetadata(valueValueId)) {
            valueDB.setMetadata(valueValueId, {
                ...core_1.ValueMetadata.ReadOnlyNumber,
                label: getValueLabel(this.driver.configManager, this._type, this._scale, this._rateType),
                unit: this._scale.label,
                ccSpecific,
            });
        }
        if (this.version >= 2 && !valueDB.hasMetadata(previousValueValueID)) {
            valueDB.setMetadata(previousValueValueID, {
                ...core_1.ValueMetadata.ReadOnlyNumber,
                label: getValueLabel(this.driver.configManager, this._type, this._scale, this._rateType, "prev. value"),
                unit: this._scale.label,
                ccSpecific,
            });
        }
        if (this.version >= 2 && !valueDB.hasMetadata(deltaTimeValueId)) {
            valueDB.setMetadata({ ...valueIdBase, property: "deltaTime" }, {
                ...core_1.ValueMetadata.ReadOnlyNumber,
                label: getValueLabel(this.driver.configManager, this._type, this._scale, this._rateType, "prev. time delta"),
                unit: "s",
                ccSpecific,
            });
        }
        valueDB.setValue(valueValueId, this._value);
        if (this._previousValue != undefined) {
            valueDB.setValue(previousValueValueID, this._previousValue);
        }
        if (this._deltaTime != "unknown") {
            valueDB.setValue({ ...valueIdBase, property: "deltaTime" }, this._deltaTime);
        }
        return true;
    }
    get type() {
        return this._type;
    }
    get scale() {
        return this._scale;
    }
    get value() {
        return this._value;
    }
    get previousValue() {
        return this._previousValue;
    }
    get rateType() {
        return this._rateType;
    }
    get deltaTime() {
        return this._deltaTime;
    }
    toLogEntry() {
        var _c, _d;
        const message = {
            type: (_d = (_c = this.driver.configManager.lookupMeter(this.type)) === null || _c === void 0 ? void 0 : _c.name) !== null && _d !== void 0 ? _d : `Unknown (${shared_1.num2hex(this._type)})`,
            scale: this._scale.label,
            "rate type": shared_1.getEnumMemberName(RateType, this._rateType),
            value: this.value,
        };
        if (this._deltaTime !== "unknown") {
            message["time delta"] = `${this.deltaTime} seconds`;
        }
        if (this._previousValue != undefined) {
            message["prev. value"] = this._previousValue;
        }
        return {
            ...super.toLogEntry(),
            message,
        };
    }
};
MeterCCReport = __decorate([
    CommandClass_1.CCCommand(MeterCommand.Report)
], MeterCCReport);
exports.MeterCCReport = MeterCCReport;
function testResponseForMeterGet(sent, received) {
    // We expect a Meter Report that matches the requested scale and rate type
    // (if they were requested)
    return ((sent.scale == undefined || sent.scale === received.scale.key) &&
        (sent.rateType == undefined || sent.rateType == received.rateType));
}
let MeterCCGet = class MeterCCGet extends MeterCC {
    constructor(driver, options) {
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            // TODO: Deserialize payload
            throw new core_1.ZWaveError(`${this.constructor.name}: deserialization not implemented`, core_1.ZWaveErrorCodes.Deserialization_NotImplemented);
        }
        else {
            this.rateType = options.rateType;
            this.scale = options.scale;
        }
    }
    serialize() {
        let scale1;
        let scale2;
        let bufferLength = 0;
        if (this.scale == undefined) {
            scale1 = 0;
        }
        else if (this.version >= 4 && this.scale >= 7) {
            scale1 = 7;
            scale2 = this.scale >>> 3;
            bufferLength = 2;
        }
        else if (this.version >= 3) {
            scale1 = this.scale & 0b111;
            bufferLength = 1;
        }
        else if (this.version >= 2) {
            scale1 = this.scale & 0b11;
            bufferLength = 1;
        }
        else {
            scale1 = 0;
        }
        let rateTypeFlags = 0;
        if (this.version >= 4 && this.rateType != undefined) {
            rateTypeFlags = this.rateType & 0b11;
            bufferLength = Math.max(bufferLength, 1);
        }
        this.payload = Buffer.alloc(bufferLength, 0);
        this.payload[0] = (rateTypeFlags << 6) | (scale1 << 3);
        if (scale2)
            this.payload[1] = scale2;
        return super.serialize();
    }
    toLogEntry() {
        const message = {};
        if (this.rateType != undefined) {
            message["rate type"] = shared_1.getEnumMemberName(RateType, this.rateType);
        }
        if (this.scale != undefined) {
            // Try to lookup the meter type to translate the scale
            const type = this.getValueDB().getValue(getTypeValueId(this.endpointIndex));
            if (type != undefined) {
                message.duration = this.driver.configManager.lookupMeterScale(type, this.scale).label;
            }
        }
        return {
            ...super.toLogEntry(),
            message,
        };
    }
};
MeterCCGet = __decorate([
    CommandClass_1.CCCommand(MeterCommand.Get),
    CommandClass_1.expectedCCResponse(MeterCCReport, testResponseForMeterGet)
], MeterCCGet);
exports.MeterCCGet = MeterCCGet;
let MeterCCSupportedReport = class MeterCCSupportedReport extends MeterCC {
    constructor(driver, options) {
        super(driver, options);
        core_1.validatePayload(this.payload.length >= 2);
        this._type = this.payload[0] & 31;
        this._supportsReset = !!(this.payload[0] & 128);
        const hasMoreScales = !!(this.payload[1] & 128);
        if (hasMoreScales) {
            // The bitmask is spread out
            core_1.validatePayload(this.payload.length >= 3);
            const extraBytes = this.payload[2];
            core_1.validatePayload(this.payload.length >= 3 + extraBytes);
            // The bitmask is the original payload byte plus all following bytes
            // Since the first byte only has 7 bits, we need to reduce all following bits by 1
            this._supportedScales = core_1.parseBitMask(Buffer.concat([
                Buffer.from([this.payload[1] & 127]),
                this.payload.slice(3, 3 + extraBytes),
            ]), 0).map((scale) => (scale >= 8 ? scale - 1 : scale));
        }
        else {
            // only 7 bits in the bitmask. Bit 7 is 0, so no need to mask it out
            this._supportedScales = core_1.parseBitMask(Buffer.from([this.payload[1]]), 0);
        }
        // This is only present in V4+
        this._supportedRateTypes = core_1.parseBitMask(Buffer.from([(this.payload[0] & 96) >>> 5]), 1);
        this.persistValues();
    }
    get type() {
        return this._type;
    }
    get supportsReset() {
        return this._supportsReset;
    }
    get supportedScales() {
        return this._supportedScales;
    }
    get supportedRateTypes() {
        return this._supportedRateTypes;
    }
    persistValues() {
        if (!super.persistValues())
            return false;
        if (!this._supportsReset)
            return true;
        const valueDb = this.getValueDB();
        // Create reset values
        if (this.version < 6) {
            const resetAllValueId = getResetValueId(this.endpointIndex);
            if (!valueDb.hasMetadata(resetAllValueId)) {
                this.getValueDB().setMetadata(resetAllValueId, {
                    ...core_1.ValueMetadata.WriteOnlyBoolean,
                    label: `Reset accumulated values`,
                });
            }
        }
        else {
            const resetSingle = getResetValueId(this.endpointIndex, this._type);
            if (!valueDb.hasMetadata(resetSingle)) {
                this.getValueDB().setMetadata(resetSingle, {
                    ...core_1.ValueMetadata.WriteOnlyBoolean,
                    label: `Reset (${getMeterTypeName(this.driver.configManager, this._type)})`,
                    ccSpecific: {
                        meterType: this._type,
                    },
                });
            }
        }
        return true;
    }
    toLogEntry() {
        var _c, _d;
        const message = {
            type: `${(_d = (_c = this.driver.configManager.lookupMeter(this.type)) === null || _c === void 0 ? void 0 : _c.name) !== null && _d !== void 0 ? _d : `Unknown (${shared_1.num2hex(this.type)})`}`,
            "supports reset": this._supportsReset,
            "supported scales": `${this._supportedScales
                .map((scale) => `
· ${this.driver.configManager.lookupMeterScale(this.type, scale).label}`)
                .join("")}`,
            "supported rate types": this._supportedRateTypes
                .map((rt) => shared_1.getEnumMemberName(RateType, rt))
                .join(", "),
        };
        return {
            ...super.toLogEntry(),
            message,
        };
    }
};
__decorate([
    CommandClass_1.ccValue({ internal: true })
], MeterCCSupportedReport.prototype, "type", null);
__decorate([
    CommandClass_1.ccValue({ internal: true })
], MeterCCSupportedReport.prototype, "supportsReset", null);
__decorate([
    CommandClass_1.ccValue({ internal: true })
], MeterCCSupportedReport.prototype, "supportedScales", null);
__decorate([
    CommandClass_1.ccValue({ internal: true })
], MeterCCSupportedReport.prototype, "supportedRateTypes", null);
MeterCCSupportedReport = __decorate([
    CommandClass_1.CCCommand(MeterCommand.SupportedReport)
], MeterCCSupportedReport);
exports.MeterCCSupportedReport = MeterCCSupportedReport;
let MeterCCSupportedGet = class MeterCCSupportedGet extends MeterCC {
};
MeterCCSupportedGet = __decorate([
    CommandClass_1.CCCommand(MeterCommand.SupportedGet),
    CommandClass_1.expectedCCResponse(MeterCCSupportedReport)
], MeterCCSupportedGet);
exports.MeterCCSupportedGet = MeterCCSupportedGet;
let MeterCCReset = class MeterCCReset extends MeterCC {
    constructor(driver, options) {
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            // TODO: Deserialize payload
            throw new core_1.ZWaveError(`${this.constructor.name}: deserialization not implemented`, core_1.ZWaveErrorCodes.Deserialization_NotImplemented);
        }
        else {
            this.type = options.type;
            this.targetValue = options.targetValue;
            // Test if this is a valid target value
            if (this.targetValue != undefined &&
                !core_1.getMinIntegerSize(this.targetValue, true)) {
                throw new core_1.ZWaveError(`${this.targetValue} is not a valid target value!`, core_1.ZWaveErrorCodes.Argument_Invalid);
            }
        }
    }
    serialize() {
        if (this.version >= 6 && this.targetValue != undefined && this.type) {
            const size = (this.targetValue &&
                core_1.getMinIntegerSize(this.targetValue, true)) ||
                0;
            if (size > 0) {
                this.payload = Buffer.allocUnsafe(1 + size);
                this.payload[0] = (size << 5) | (this.type & 0b11111);
                this.payload.writeIntBE(this.targetValue, 1, size);
            }
        }
        return super.serialize();
    }
    toLogEntry() {
        var _c, _d;
        const message = {};
        if (this.type != undefined) {
            message.type = `${(_d = (_c = this.driver.configManager.lookupMeter(this.type)) === null || _c === void 0 ? void 0 : _c.name) !== null && _d !== void 0 ? _d : `Unknown (${shared_1.num2hex(this.type)})`}`;
        }
        if (this.targetValue != undefined) {
            message["target value"] = this.targetValue;
        }
        return {
            ...super.toLogEntry(),
            message,
        };
    }
};
MeterCCReset = __decorate([
    CommandClass_1.CCCommand(MeterCommand.Reset)
], MeterCCReset);
exports.MeterCCReset = MeterCCReset;

//# sourceMappingURL=MeterCC.js.map
