"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.NotificationCCEventSupportedGet = exports.NotificationCCEventSupportedReport = exports.NotificationCCSupportedGet = exports.NotificationCCSupportedReport = exports.NotificationCCGet = exports.NotificationCCReport = exports.NotificationCCSet = exports.NotificationCC = exports.NotificationCCAPI = exports.getNotificationModeValueId = exports.getSupportedNotificationEventsValueId = exports.getSupportedNotificationTypesValueId = exports.NotificationCommand = void 0;
const config_1 = require("@zwave-js/config");
const core_1 = require("@zwave-js/core");
const shared_1 = require("@zwave-js/shared");
const typeguards_1 = require("alcalzone-shared/typeguards");
const Constants_1 = require("../message/Constants");
const API_1 = require("./API");
const CommandClass_1 = require("./CommandClass");
var NotificationCommand;
(function (NotificationCommand) {
    // All the supported commands
    NotificationCommand[NotificationCommand["EventSupportedGet"] = 1] = "EventSupportedGet";
    NotificationCommand[NotificationCommand["EventSupportedReport"] = 2] = "EventSupportedReport";
    NotificationCommand[NotificationCommand["Get"] = 4] = "Get";
    NotificationCommand[NotificationCommand["Report"] = 5] = "Report";
    NotificationCommand[NotificationCommand["Set"] = 6] = "Set";
    NotificationCommand[NotificationCommand["SupportedGet"] = 7] = "SupportedGet";
    NotificationCommand[NotificationCommand["SupportedReport"] = 8] = "SupportedReport";
})(NotificationCommand = exports.NotificationCommand || (exports.NotificationCommand = {}));
/** Returns the ValueID used to store the supported notification types of a node */
function getSupportedNotificationTypesValueId() {
    return {
        commandClass: core_1.CommandClasses.Notification,
        property: "supportedNotificationTypes",
    };
}
exports.getSupportedNotificationTypesValueId = getSupportedNotificationTypesValueId;
/** Returns the ValueID used to store the supported notification events of a node */
function getSupportedNotificationEventsValueId(type) {
    return {
        commandClass: core_1.CommandClasses.Notification,
        property: "supportedNotificationEvents",
        propertyKey: type,
    };
}
exports.getSupportedNotificationEventsValueId = getSupportedNotificationEventsValueId;
/** Returns the ValueID used to store whether a node supports push or pull */
function getNotificationModeValueId() {
    return {
        commandClass: core_1.CommandClasses.Notification,
        property: "notificationMode",
    };
}
exports.getNotificationModeValueId = getNotificationModeValueId;
let NotificationCCAPI = class NotificationCCAPI extends API_1.PhysicalCCAPI {
    supportsCommand(cmd) {
        switch (cmd) {
            case NotificationCommand.Report:
            case NotificationCommand.Get:
                return true; // These exist starting with V1
            case NotificationCommand.Set:
            case NotificationCommand.SupportedGet:
                return this.version >= 2;
            case NotificationCommand.EventSupportedGet:
                return this.version >= 3;
        }
        return super.supportsCommand(cmd);
    }
    /**
     * @internal
     */
    async getInternal(options) {
        this.assertSupportsCommand(NotificationCommand, NotificationCommand.Get);
        const cc = new NotificationCCGet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
            ...options,
        });
        return this.driver.sendCommand(cc, this.commandOptions);
    }
    async sendReport(options) {
        this.assertSupportsCommand(NotificationCommand, NotificationCommand.Report);
        const cc = new NotificationCCReport(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
            ...options,
        });
        await this.driver.sendCommand(cc, this.commandOptions);
    }
    // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
    async get(options) {
        const response = await this.getInternal(options);
        if (response) {
            return shared_1.pick(response, [
                "notificationStatus",
                "notificationEvent",
                "alarmLevel",
                "zensorNetSourceNodeId",
                "eventParameters",
                "sequenceNumber",
            ]);
        }
    }
    async set(notificationType, notificationStatus) {
        this.assertSupportsCommand(NotificationCommand, NotificationCommand.Set);
        const cc = new NotificationCCSet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
            notificationType,
            notificationStatus,
        });
        await this.driver.sendCommand(cc, this.commandOptions);
    }
    // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
    async getSupported() {
        this.assertSupportsCommand(NotificationCommand, NotificationCommand.SupportedGet);
        const cc = new NotificationCCSupportedGet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
        });
        const response = await this.driver.sendCommand(cc, this.commandOptions);
        if (response) {
            return shared_1.pick(response, [
                "supportsV1Alarm",
                "supportedNotificationTypes",
            ]);
        }
    }
    async getSupportedEvents(notificationType) {
        this.assertSupportsCommand(NotificationCommand, NotificationCommand.EventSupportedGet);
        const cc = new NotificationCCEventSupportedGet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
            notificationType,
        });
        const response = await this.driver.sendCommand(cc, this.commandOptions);
        return response === null || response === void 0 ? void 0 : response.supportedEvents;
    }
};
NotificationCCAPI = __decorate([
    CommandClass_1.API(core_1.CommandClasses.Notification)
], NotificationCCAPI);
exports.NotificationCCAPI = NotificationCCAPI;
function defineMetadataForNotificationEvents(configManager, endpoint, type, events) {
    const ret = new Map();
    const notificationConfig = configManager.lookupNotification(type);
    if (!notificationConfig) {
        // This is an unknown notification
        const property = `UNKNOWN_${shared_1.num2hex(type)}`;
        const valueId = {
            commandClass: core_1.CommandClasses.Notification,
            endpoint,
            property,
        };
        ret.set(JSON.stringify(valueId), {
            ...core_1.ValueMetadata.ReadOnlyUInt8,
            label: `Unknown notification (${shared_1.num2hex(type)})`,
            ccSpecific: {
                notificationType: type,
            },
        });
        return ret;
    }
    const property = notificationConfig.name;
    for (const value of events) {
        // Find out which property we need to update
        const valueConfig = notificationConfig.lookupValue(value);
        if ((valueConfig === null || valueConfig === void 0 ? void 0 : valueConfig.type) === "state") {
            const valueId = {
                commandClass: core_1.CommandClasses.Notification,
                endpoint,
                property,
                propertyKey: valueConfig.variableName,
            };
            const dictKey = JSON.stringify(valueId);
            const metadata = ret.get(dictKey) || {
                ...core_1.ValueMetadata.ReadOnlyUInt8,
                label: valueConfig.variableName,
                states: {},
                ccSpecific: {
                    notificationType: type,
                },
            };
            if (valueConfig.idle) {
                metadata.states[0] = "idle";
            }
            metadata.states[value] = valueConfig.label;
            ret.set(dictKey, metadata);
        }
    }
    return ret;
}
let NotificationCC = class NotificationCC extends CommandClass_1.CommandClass {
    // former AlarmCC (v1..v2)
    constructor(driver, options) {
        super(driver, options);
        // mark some value IDs as internal
        this.registerValue(getNotificationModeValueId().property, true);
        this.registerValue(getSupportedNotificationTypesValueId().property, true);
        this.registerValue(getSupportedNotificationEventsValueId(0).property, true);
    }
    determineRequiredCCInterviews() {
        return [
            ...super.determineRequiredCCInterviews(),
            core_1.CommandClasses.Association,
            core_1.CommandClasses["Multi Channel Association"],
            core_1.CommandClasses["Association Group Information"],
        ];
    }
    async determineNotificationMode(api, supportedNotificationEvents) {
        var _a, _b;
        const node = this.getNode();
        // SDS14223: If the supporting node does not support the Association Command Class,
        // it may be concluded that the supporting node implements Pull Mode and discovery may be aborted.
        if (!node.supportsCC(core_1.CommandClasses.Association))
            return "pull";
        try {
            if (node.supportsCC(core_1.CommandClasses["Association Group Information"])) {
                const assocGroups = this.driver.controller.getAssociationGroups(node.id);
                for (const group of assocGroups.values()) {
                    // Check if this group sends Notification Reports
                    if ((_b = (_a = group.issuedCommands) === null || _a === void 0 ? void 0 : _a.get(core_1.CommandClasses.Notification)) === null || _b === void 0 ? void 0 : _b.includes(NotificationCommand.Report)) {
                        return "push";
                    }
                }
                return "pull";
            }
        }
        catch (_c) {
            // We might be dealing with an older cache file, fall back to testing
        }
        this.driver.controllerLog.logNode(node.id, {
            endpoint: this.endpointIndex,
            message: `determining whether this node is pull or push...`,
            direction: "outbound",
        });
        // Find a notification type with at least one supported event
        for (const [type, events] of supportedNotificationEvents) {
            if (events.length === 0)
                continue;
            // Enable the event and request the status
            await api.set(type, true);
            try {
                const resp = await api.get({
                    notificationType: type,
                    notificationEvent: events[0],
                });
                switch (resp === null || resp === void 0 ? void 0 : resp.notificationStatus) {
                    case 0xff:
                        return "push";
                    case 0xfe:
                    case 0x00:
                        return "pull";
                }
            }
            catch (_d) {
                /* ignore */
            }
        }
        // If everything failed, fall back to "pull"
        return "pull";
    }
    async interview(complete = true) {
        var _a, _b;
        const node = this.getNode();
        const endpoint = this.getEndpoint();
        const api = endpoint.commandClasses.Notification.withOptions({
            priority: Constants_1.MessagePriority.NodeQuery,
        });
        const valueDB = this.getValueDB();
        this.driver.controllerLog.logNode(node.id, {
            endpoint: this.endpointIndex,
            message: `${this.constructor.name}: doing a ${complete ? "complete" : "partial"} interview...`,
            direction: "none",
        });
        if (this.version >= 2) {
            let supportedNotificationTypes;
            let supportedNotificationNames;
            const supportedNotificationEvents = new Map();
            const lookupNotificationNames = () => {
                return supportedNotificationTypes
                    .map((n) => {
                    const ret = this.driver.configManager.lookupNotification(n);
                    return [n, ret];
                })
                    .map(([type, ntfcn]) => ntfcn ? ntfcn.name : `UNKNOWN (${shared_1.num2hex(type)})`);
            };
            if (complete) {
                this.driver.controllerLog.logNode(node.id, {
                    endpoint: this.endpointIndex,
                    message: "querying supported notification types...",
                    direction: "outbound",
                });
                const suppResponse = await api.getSupported();
                if (!suppResponse) {
                    this.driver.controllerLog.logNode(node.id, {
                        endpoint: this.endpointIndex,
                        message: "Querying supported notification types timed out, skipping interview...",
                        level: "warn",
                    });
                    return;
                }
                supportedNotificationTypes =
                    suppResponse.supportedNotificationTypes;
                supportedNotificationNames = lookupNotificationNames();
                const logMessage = `received supported notification types:${supportedNotificationNames
                    .map((name) => `\n· ${name}`)
                    .join("")}`;
                this.driver.controllerLog.logNode(node.id, {
                    endpoint: this.endpointIndex,
                    message: logMessage,
                    direction: "inbound",
                });
                if (this.version >= 3) {
                    // Query each notification for its supported events
                    for (let i = 0; i < supportedNotificationTypes.length; i++) {
                        const type = supportedNotificationTypes[i];
                        const name = supportedNotificationNames[i];
                        this.driver.controllerLog.logNode(node.id, {
                            endpoint: this.endpointIndex,
                            message: `querying supported notification events for ${name}...`,
                            direction: "outbound",
                        });
                        const supportedEvents = await api.getSupportedEvents(type);
                        if (supportedEvents) {
                            supportedNotificationEvents.set(type, supportedEvents);
                            this.driver.controllerLog.logNode(node.id, {
                                endpoint: this.endpointIndex,
                                message: `received supported notification events for ${name}: ${supportedEvents
                                    .map(String)
                                    .join(", ")}`,
                                direction: "inbound",
                            });
                        }
                    }
                }
            }
            else {
                // Load supported notification types and events from cache
                supportedNotificationTypes = (_a = valueDB.getValue(getSupportedNotificationTypesValueId())) !== null && _a !== void 0 ? _a : [];
                supportedNotificationNames = lookupNotificationNames();
                for (const type of supportedNotificationTypes) {
                    supportedNotificationEvents.set(type, (_b = valueDB.getValue(getSupportedNotificationEventsValueId(type))) !== null && _b !== void 0 ? _b : []);
                }
            }
            // Determine whether the node is a push or pull node
            let notificationMode = valueDB.getValue(getNotificationModeValueId());
            if (!notificationMode) {
                notificationMode = await this.determineNotificationMode(api, supportedNotificationEvents);
                valueDB.setValue(getNotificationModeValueId(), notificationMode);
            }
            if (notificationMode === "pull") {
                for (let i = 0; i < supportedNotificationTypes.length; i++) {
                    const type = supportedNotificationTypes[i];
                    const name = supportedNotificationNames[i];
                    // Always query each notification for its current status
                    this.driver.controllerLog.logNode(node.id, {
                        endpoint: this.endpointIndex,
                        message: `querying notification status for ${name}...`,
                        direction: "outbound",
                    });
                    const response = await api.getInternal({
                        notificationType: type,
                    });
                    // NotificationReports don't store their values themselves,
                    // because the behaviour is too complex and spans the lifetime
                    // of several reports. Thus we handle it in the Node instance
                    if (response)
                        await node.handleCommand(response);
                }
            } /* if (notificationMode === "push") */
            else {
                for (let i = 0; i < supportedNotificationTypes.length; i++) {
                    const type = supportedNotificationTypes[i];
                    const name = supportedNotificationNames[i];
                    const notificationConfig = this.driver.configManager.lookupNotification(type);
                    if (complete) {
                        // Enable reports for each notification type
                        this.driver.controllerLog.logNode(node.id, {
                            endpoint: this.endpointIndex,
                            message: `enabling notifications for ${name}...`,
                            direction: "outbound",
                        });
                        await api.set(type, true);
                    }
                    // Set the value to idle if possible and there is no value yet
                    if (notificationConfig) {
                        const property = notificationConfig.name;
                        const events = supportedNotificationEvents.get(type);
                        if (events) {
                            // Find all variables that are supported by this node and have an idle state
                            for (const variable of notificationConfig.variables.filter((v) => !!v.idle)) {
                                if ([...variable.states.keys()].some((key) => events.includes(key))) {
                                    const propertyKey = variable.name;
                                    const valueId = {
                                        commandClass: core_1.CommandClasses.Notification,
                                        endpoint: endpoint.index,
                                        property,
                                        propertyKey,
                                    };
                                    // Set the value to idle if it has no value yet
                                    // TODO: GH#1028
                                    // * do this only if the last update was more than 5 minutes ago
                                    // * schedule an auto-idle if the last update was less than 5 minutes ago but before the current driver start
                                    if (valueDB.getValue(valueId) == undefined) {
                                        valueDB.setValue(valueId, 0 /* idle */);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        // Remember that the interview is complete
        this.interviewComplete = true;
    }
    /** Whether the node implements push or pull notifications */
    get notificationMode() {
        var _a;
        return ((_a = this.getValueDB().getValue(getNotificationModeValueId())) !== null && _a !== void 0 ? _a : "unknown");
    }
};
NotificationCC = __decorate([
    CommandClass_1.commandClass(core_1.CommandClasses.Notification),
    CommandClass_1.implementedVersion(8)
], NotificationCC);
exports.NotificationCC = NotificationCC;
let NotificationCCSet = class NotificationCCSet extends NotificationCC {
    constructor(driver, options) {
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            // TODO: Deserialize payload
            throw new core_1.ZWaveError(`${this.constructor.name}: deserialization not implemented`, core_1.ZWaveErrorCodes.Deserialization_NotImplemented);
        }
        else {
            this.notificationType = options.notificationType;
            this.notificationStatus = options.notificationStatus;
        }
    }
    serialize() {
        this.payload = Buffer.from([
            this.notificationType,
            this.notificationStatus ? 0xff : 0x00,
        ]);
        return super.serialize();
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                "notification type": this.driver.configManager.getNotificationName(this.notificationType),
                status: this.notificationStatus,
            },
        };
    }
};
NotificationCCSet = __decorate([
    CommandClass_1.CCCommand(NotificationCommand.Set)
], NotificationCCSet);
exports.NotificationCCSet = NotificationCCSet;
let NotificationCCReport = class NotificationCCReport extends NotificationCC {
    constructor(driver, options) {
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            core_1.validatePayload(this.payload.length >= 2);
            this.alarmType = this.payload[0];
            this.alarmLevel = this.payload[1];
            // V2..V3, reserved in V4+
            if ((this.version === 2 || this.version === 3) &&
                this.payload.length >= 3) {
                this.zensorNetSourceNodeId = this.payload[2];
            }
            // V2+ requires the alarm bytes to be zero. Manufacturers don't care though, so we don't enforce that.
            // Don't use the version to decide because we might discard notifications
            // before the interview is complete
            if (this.payload.length >= 7) {
                // Ignore the legacy alarm bytes
                this.alarmType = 0;
                this.alarmLevel = 0;
                this.notificationStatus = this.payload[3];
                this.notificationType = this.payload[4];
                this.notificationEvent = this.payload[5];
                const containsSeqNum = !!(this.payload[6] & 128);
                const numEventParams = this.payload[6] & 0b11111;
                if (numEventParams > 0) {
                    core_1.validatePayload(this.payload.length >= 7 + numEventParams);
                    this.eventParameters = Buffer.from(this.payload.slice(7, 7 + numEventParams));
                }
                if (containsSeqNum) {
                    core_1.validatePayload(this.payload.length >= 7 + numEventParams + 1);
                    this.sequenceNumber = this.payload[7 + numEventParams];
                }
                // Turn the event parameters into something useful
                this.parseEventParameters();
            }
            else if (this.alarmType !== 0 && this.version >= 2) {
                // Check if the device actually supports Notification CC, but chooses
                // to send Alarm frames instead (GH#1034)
                const valueDB = this.getValueDB();
                const supportedNotificationTypes = valueDB.getValue(getSupportedNotificationTypesValueId());
                if (typeguards_1.isArray(supportedNotificationTypes) &&
                    supportedNotificationTypes.includes(this.alarmType)) {
                    const supportedNotificationEvents = valueDB.getValue(getSupportedNotificationEventsValueId(this.alarmType));
                    if (typeguards_1.isArray(supportedNotificationEvents) &&
                        supportedNotificationEvents.includes(this.alarmLevel)) {
                        // This alarm frame corresponds to a valid notification event
                        this.driver.controllerLog.logNode(this.nodeId, `treating V1 Alarm frame as Notification Report`);
                        this.notificationType = this.alarmType;
                        this.notificationEvent = this.alarmLevel;
                        this.alarmType = 0;
                        this.alarmLevel = 0;
                    }
                }
            }
        }
        else {
            if ("alarmType" in options) {
                this.alarmType = options.alarmType;
                this.alarmLevel = options.alarmLevel;
                // Send a V1 command
                this.version = 1;
            }
            else {
                this.notificationType = options.notificationType;
                this.notificationStatus = true;
                this.notificationEvent = options.notificationEvent;
                this.eventParameters = options.eventParameters;
                this.sequenceNumber = options.sequenceNumber;
            }
        }
    }
    toLogEntry() {
        var _a, _b, _c;
        let message;
        if (this.alarmType) {
            message = {
                "V1 alarm type": this.alarmType,
                "V1 alarm level": this.alarmLevel,
            };
        }
        else {
            const valueConfig = (_a = this.driver.configManager
                .lookupNotification(this.notificationType)) === null || _a === void 0 ? void 0 : _a.lookupValue(this.notificationEvent);
            message = {
                "notification type": this.driver.configManager.getNotificationName(this.notificationType),
                "notification status": this.notificationStatus,
                [`notification ${(_b = valueConfig === null || valueConfig === void 0 ? void 0 : valueConfig.type) !== null && _b !== void 0 ? _b : "event"}`]: (_c = valueConfig === null || valueConfig === void 0 ? void 0 : valueConfig.label) !== null && _c !== void 0 ? _c : `Unknown (${shared_1.num2hex(this.notificationEvent)})`,
            };
        }
        if (this.zensorNetSourceNodeId) {
            message["zensor net source node id"] = this.zensorNetSourceNodeId;
        }
        if (this.sequenceNumber != undefined) {
            message["sequence number"] = this.sequenceNumber;
        }
        if (this.eventParameters != undefined) {
            message["event parameters"] = String(this.eventParameters);
        }
        return {
            ...super.toLogEntry(),
            message,
        };
    }
    toJSON() {
        var _a;
        return super.toJSONInherited({
            alarmType: this.alarmType,
            notificationType: this.notificationType != undefined
                ? (_a = this.driver.configManager.lookupNotification(this.notificationType)) === null || _a === void 0 ? void 0 : _a.name : this.notificationType,
            notificationStatus: this.notificationStatus,
            notificationEvent: this.notificationEvent,
            alarmLevel: this.alarmLevel,
            zensorNetSourceNodeId: this.zensorNetSourceNodeId,
            eventParameters: this.eventParameters,
            sequenceNumber: this.sequenceNumber,
        });
    }
    parseEventParameters() {
        if (this.notificationType == undefined ||
            this.notificationEvent == undefined ||
            !Buffer.isBuffer(this.eventParameters)) {
            return;
        }
        // Look up the received notification and value in the config
        const notificationConfig = this.driver.configManager.lookupNotification(this.notificationType);
        if (!notificationConfig)
            return;
        const valueConfig = notificationConfig.lookupValue(this.notificationEvent);
        if (!valueConfig)
            return;
        // Parse the event parameters if possible
        if (valueConfig.parameter instanceof config_1.NotificationParameterWithDuration) {
            // The parameters contain a Duration
            this.eventParameters = core_1.Duration.parseReport(this.eventParameters[0]);
        }
        else if (valueConfig.parameter instanceof
            config_1.NotificationParameterWithCommandClass) {
            // The parameters **should** contain a CC, however there might be some exceptions
            if (this.eventParameters.length === 1 &&
                notificationConfig.id === 0x06 &&
                (this.notificationEvent === 0x05 ||
                    this.notificationEvent === 0x06)) {
                // Access control -> Keypad Lock/Unlock operation
                // Some devices only send the User ID, not a complete CC payload
                this.eventParameters = {
                    userId: this.eventParameters[0],
                };
            }
            else {
                this.eventParameters = CommandClass_1.CommandClass.from(this.driver, {
                    data: this.eventParameters,
                    fromEncapsulation: true,
                    encapCC: this,
                });
            }
        }
        else if (valueConfig.parameter instanceof config_1.NotificationParameterWithValue) {
            // The parameters contain a named value
            this.eventParameters = {
                [valueConfig.parameter
                    .propertyName]: this.eventParameters.readUIntBE(0, this.eventParameters.length),
            };
        }
    }
    serialize() {
        var _a, _b;
        if (this.version === 1) {
            if (this.alarmLevel == undefined || this.alarmType == undefined) {
                throw new core_1.ZWaveError(`Notification CC V1 (Alarm CC) reports requires the alarm type and level to be set!`, core_1.ZWaveErrorCodes.Argument_Invalid);
            }
            this.payload = Buffer.from([this.alarmType, this.alarmLevel]);
        }
        else {
            if (this.notificationType == undefined ||
                this.notificationEvent == undefined) {
                throw new core_1.ZWaveError(`Notification CC reports requires the notification type and event to be set!`, core_1.ZWaveErrorCodes.Argument_Invalid);
            }
            else if (this.eventParameters != undefined &&
                !Buffer.isBuffer(this.eventParameters)) {
                throw new core_1.ZWaveError(`When sending Notification CC reports, the event parameters can only be buffers!`, core_1.ZWaveErrorCodes.Argument_Invalid);
            }
            const controlByte = (this.sequenceNumber != undefined ? 128 : 0) |
                (((_b = (_a = this.eventParameters) === null || _a === void 0 ? void 0 : _a.length) !== null && _b !== void 0 ? _b : 0) & 0b11111);
            this.payload = Buffer.from([
                0,
                0,
                0,
                0xff,
                this.notificationType,
                this.notificationEvent,
                controlByte,
            ]);
            if (this.eventParameters) {
                this.payload = Buffer.concat([
                    this.payload,
                    this.eventParameters,
                ]);
            }
            if (this.sequenceNumber != undefined) {
                this.payload = Buffer.concat([
                    this.payload,
                    Buffer.from([this.sequenceNumber]),
                ]);
            }
        }
        return super.serialize();
    }
};
NotificationCCReport = __decorate([
    CommandClass_1.CCCommand(NotificationCommand.Report)
], NotificationCCReport);
exports.NotificationCCReport = NotificationCCReport;
let NotificationCCGet = class NotificationCCGet extends NotificationCC {
    constructor(driver, options) {
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            // TODO: Deserialize payload
            throw new core_1.ZWaveError(`${this.constructor.name}: deserialization not implemented`, core_1.ZWaveErrorCodes.Deserialization_NotImplemented);
        }
        else {
            if ("alarmType" in options) {
                this.alarmType = options.alarmType;
            }
            else {
                this.notificationType = options.notificationType;
                this.notificationEvent = options.notificationEvent;
            }
        }
    }
    serialize() {
        const payload = [this.alarmType || 0];
        if (this.version >= 2 && this.notificationType != undefined) {
            payload.push(this.notificationType);
            if (this.version >= 3) {
                payload.push(this.notificationType === 0xff
                    ? 0x00
                    : this.notificationEvent || 0);
            }
        }
        this.payload = Buffer.from(payload);
        return super.serialize();
    }
    toLogEntry() {
        var _a, _b, _c;
        const message = {};
        if (this.alarmType != undefined) {
            message["V1 alarm type"] = this.alarmType;
        }
        if (this.notificationType != undefined) {
            message["notification type"] = this.driver.configManager.getNotificationName(this.notificationType);
            if (this.notificationEvent != undefined) {
                message["notification event"] = (_c = (_b = (_a = this.driver.configManager
                    .lookupNotification(this.notificationType)) === null || _a === void 0 ? void 0 : _a.events.get(this.notificationEvent)) === null || _b === void 0 ? void 0 : _b.label) !== null && _c !== void 0 ? _c : `Unknown (${shared_1.num2hex(this.notificationEvent)})`;
            }
        }
        return {
            ...super.toLogEntry(),
            message,
        };
    }
};
NotificationCCGet = __decorate([
    CommandClass_1.CCCommand(NotificationCommand.Get),
    CommandClass_1.expectedCCResponse(NotificationCCReport)
], NotificationCCGet);
exports.NotificationCCGet = NotificationCCGet;
let NotificationCCSupportedReport = class NotificationCCSupportedReport extends NotificationCC {
    constructor(driver, options) {
        super(driver, options);
        core_1.validatePayload(this.payload.length >= 1);
        this._supportsV1Alarm = !!(this.payload[0] & 128);
        const numBitMaskBytes = this.payload[0] & 31;
        core_1.validatePayload(numBitMaskBytes > 0, this.payload.length >= 1 + numBitMaskBytes);
        const notificationBitMask = this.payload.slice(1, 1 + numBitMaskBytes);
        this._supportedNotificationTypes = core_1.parseBitMask(notificationBitMask, 
        // bit 0 is ignored, but counting still starts at 1, so the first bit must have the value 0
        0);
        this.persistValues();
    }
    get supportsV1Alarm() {
        return this._supportsV1Alarm;
    }
    get supportedNotificationTypes() {
        return this._supportedNotificationTypes;
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                "supports V1 alarm": this.supportsV1Alarm,
                "supported notification types": this.supportedNotificationTypes
                    .map((t) => `\n· ${this.driver.configManager.getNotificationName(t)}`)
                    .join(""),
            },
        };
    }
};
__decorate([
    CommandClass_1.ccValue({ internal: true })
], NotificationCCSupportedReport.prototype, "supportsV1Alarm", null);
__decorate([
    CommandClass_1.ccValue({ internal: true })
], NotificationCCSupportedReport.prototype, "supportedNotificationTypes", null);
NotificationCCSupportedReport = __decorate([
    CommandClass_1.CCCommand(NotificationCommand.SupportedReport)
], NotificationCCSupportedReport);
exports.NotificationCCSupportedReport = NotificationCCSupportedReport;
let NotificationCCSupportedGet = class NotificationCCSupportedGet extends NotificationCC {
};
NotificationCCSupportedGet = __decorate([
    CommandClass_1.CCCommand(NotificationCommand.SupportedGet),
    CommandClass_1.expectedCCResponse(NotificationCCSupportedReport)
], NotificationCCSupportedGet);
exports.NotificationCCSupportedGet = NotificationCCSupportedGet;
let NotificationCCEventSupportedReport = class NotificationCCEventSupportedReport extends NotificationCC {
    constructor(driver, options) {
        super(driver, options);
        core_1.validatePayload(this.payload.length >= 1);
        this._notificationType = this.payload[0];
        const numBitMaskBytes = this.payload[1] & 31;
        if (numBitMaskBytes === 0) {
            // Notification type is not supported
            this._supportedEvents = [];
            return;
        }
        core_1.validatePayload(this.payload.length >= 2 + numBitMaskBytes);
        const eventBitMask = this.payload.slice(2, 2 + numBitMaskBytes);
        this._supportedEvents = core_1.parseBitMask(eventBitMask, 
        // In this mask, bit 0 is ignored, but counting still starts at 1, so the first bit must have the value 0
        0);
        this.persistValues();
    }
    persistValues() {
        if (!super.persistValues())
            return false;
        const valueDB = this.getValueDB();
        // Store which events this notification supports
        valueDB.setValue(getSupportedNotificationEventsValueId(this._notificationType), this._supportedEvents);
        // For each event, predefine the value metadata
        const metadataMap = defineMetadataForNotificationEvents(this.driver.configManager, this.endpointIndex, this._notificationType, this._supportedEvents);
        for (const [key, metadata] of metadataMap.entries()) {
            const valueId = JSON.parse(key);
            valueDB.setMetadata(valueId, metadata);
        }
        return true;
    }
    get notificationType() {
        return this._notificationType;
    }
    get supportedEvents() {
        return this._supportedEvents;
    }
    toLogEntry() {
        const notification = this.driver.configManager.lookupNotification(this.notificationType);
        return {
            ...super.toLogEntry(),
            message: {
                "notification type": this.driver.configManager.getNotificationName(this.notificationType),
                "supported events": this.supportedEvents
                    .map((e) => {
                    var _a, _b;
                    return `\n· ${(_b = (_a = notification === null || notification === void 0 ? void 0 : notification.events.get(e)) === null || _a === void 0 ? void 0 : _a.label) !== null && _b !== void 0 ? _b : `Unknown (${shared_1.num2hex(e)})`}`;
                })
                    .join(""),
            },
        };
    }
};
NotificationCCEventSupportedReport = __decorate([
    CommandClass_1.CCCommand(NotificationCommand.EventSupportedReport)
], NotificationCCEventSupportedReport);
exports.NotificationCCEventSupportedReport = NotificationCCEventSupportedReport;
let NotificationCCEventSupportedGet = class NotificationCCEventSupportedGet extends NotificationCC {
    constructor(driver, options) {
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            // TODO: Deserialize payload
            throw new core_1.ZWaveError(`${this.constructor.name}: deserialization not implemented`, core_1.ZWaveErrorCodes.Deserialization_NotImplemented);
        }
        else {
            this.notificationType = options.notificationType;
        }
    }
    serialize() {
        this.payload = Buffer.from([this.notificationType]);
        return super.serialize();
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                "notification type": this.driver.configManager.getNotificationName(this.notificationType),
            },
        };
    }
};
NotificationCCEventSupportedGet = __decorate([
    CommandClass_1.CCCommand(NotificationCommand.EventSupportedGet),
    CommandClass_1.expectedCCResponse(NotificationCCEventSupportedReport)
], NotificationCCEventSupportedGet);
exports.NotificationCCEventSupportedGet = NotificationCCEventSupportedGet;

//# sourceMappingURL=NotificationCC.js.map
