"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SupervisionCCGet = exports.SupervisionCCReport = exports.SupervisionCC = exports.SupervisionCCAPI = exports.getNextSessionId = exports.SupervisionStatus = exports.SupervisionCommand = void 0;
const core_1 = require("@zwave-js/core");
const shared_1 = require("@zwave-js/shared");
const API_1 = require("./API");
const CommandClass_1 = require("./CommandClass");
// @noSetValueAPI - This CC has no values to set
// @noInterview - This CC is only used for encapsulation
// All the supported commands
var SupervisionCommand;
(function (SupervisionCommand) {
    SupervisionCommand[SupervisionCommand["Get"] = 1] = "Get";
    SupervisionCommand[SupervisionCommand["Report"] = 2] = "Report";
})(SupervisionCommand = exports.SupervisionCommand || (exports.SupervisionCommand = {}));
/** @publicAPI */
var SupervisionStatus;
(function (SupervisionStatus) {
    SupervisionStatus[SupervisionStatus["NoSupport"] = 0] = "NoSupport";
    SupervisionStatus[SupervisionStatus["Working"] = 1] = "Working";
    SupervisionStatus[SupervisionStatus["Fail"] = 2] = "Fail";
    SupervisionStatus[SupervisionStatus["Success"] = 255] = "Success";
})(SupervisionStatus = exports.SupervisionStatus || (exports.SupervisionStatus = {}));
let sessionId = 0;
/** Returns the next session ID to be used for supervision */
function getNextSessionId() {
    // TODO: Check if this needs to be on the driver for Security 2
    sessionId = (sessionId + 1) & 0b111111;
    if (sessionId === 0)
        sessionId++;
    return sessionId;
}
exports.getNextSessionId = getNextSessionId;
let SupervisionCCAPI = class SupervisionCCAPI extends API_1.PhysicalCCAPI {
    supportsCommand(cmd) {
        switch (cmd) {
            case SupervisionCommand.Get:
                return true; // This is mandatory
        }
        return super.supportsCommand(cmd);
    }
    async sendEncapsulated(encapsulated, 
    // If possible, keep us updated about the progress
    requestStatusUpdates = true) {
        this.assertSupportsCommand(SupervisionCommand, SupervisionCommand.Get);
        const cc = new SupervisionCCGet(this.driver, {
            nodeId: this.endpoint.nodeId,
            requestStatusUpdates,
            encapsulated,
        });
        await this.driver.sendCommand(cc, this.commandOptions);
    }
};
SupervisionCCAPI = __decorate([
    CommandClass_1.API(core_1.CommandClasses.Supervision)
], SupervisionCCAPI);
exports.SupervisionCCAPI = SupervisionCCAPI;
let SupervisionCC = class SupervisionCC extends CommandClass_1.CommandClass {
    /** Tests if a command should be supervised and thus requires encapsulation */
    static requiresEncapsulation(cc) {
        return cc.supervised && !(cc instanceof SupervisionCCGet);
    }
    /** Encapsulates a command that targets a specific endpoint */
    static encapsulate(driver, cc, requestStatusUpdates = true) {
        if (!cc.isSinglecast()) {
            throw new core_1.ZWaveError(`Supervision is only possible for singlecast commands!`, core_1.ZWaveErrorCodes.Argument_Invalid);
        }
        return new SupervisionCCGet(driver, {
            nodeId: cc.nodeId,
            // Supervision CC is wrapped inside MultiChannel CCs, so the endpoint must be copied
            endpoint: cc.endpointIndex,
            encapsulated: cc,
            requestStatusUpdates,
        });
    }
};
SupervisionCC = __decorate([
    CommandClass_1.commandClass(core_1.CommandClasses.Supervision),
    CommandClass_1.implementedVersion(1)
], SupervisionCC);
exports.SupervisionCC = SupervisionCC;
let SupervisionCCReport = class SupervisionCCReport extends SupervisionCC {
    // @noCCValues
    constructor(driver, options) {
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            core_1.validatePayload(this.payload.length >= 3);
            this.moreUpdatesFollow = !!(this.payload[0] & 128);
            this.sessionId = this.payload[0] & 0b111111;
            this.status = this.payload[1];
            this.duration = core_1.Duration.parseReport(this.payload[2]);
        }
        else {
            this.moreUpdatesFollow = options.moreUpdatesFollow;
            this.sessionId = options.sessionId;
            this.status = options.status;
            if (options.status === SupervisionStatus.Working) {
                this.duration = options.duration;
            }
        }
    }
    toLogEntry() {
        const message = {
            "session id": this.sessionId,
            "more updates follow": this.moreUpdatesFollow,
            status: shared_1.getEnumMemberName(SupervisionStatus, this.status),
        };
        if (this.duration) {
            message.duration = this.duration.toString();
        }
        return {
            ...super.toLogEntry(),
            message,
        };
    }
};
SupervisionCCReport = __decorate([
    CommandClass_1.CCCommand(SupervisionCommand.Report)
], SupervisionCCReport);
exports.SupervisionCCReport = SupervisionCCReport;
function testResponseForSupervisionCCGet(sent, received) {
    return received.sessionId === sent.sessionId;
}
let SupervisionCCGet = class SupervisionCCGet extends SupervisionCC {
    constructor(driver, options) {
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            // TODO: Deserialize payload
            throw new core_1.ZWaveError(`${this.constructor.name}: deserialization not implemented`, core_1.ZWaveErrorCodes.Deserialization_NotImplemented);
        }
        else {
            this.sessionId = getNextSessionId();
            this.requestStatusUpdates = options.requestStatusUpdates;
            this.encapsulated = options.encapsulated;
            options.encapsulated.encapsulatingCC = this;
            // If the encapsulated command requires security, so does this one
            if (this.encapsulated.secure)
                this.secure = true;
        }
    }
    serialize() {
        const encapCC = this.encapsulated.serialize();
        this.payload = Buffer.concat([
            Buffer.from([
                (this.requestStatusUpdates ? 128 : 0) |
                    (this.sessionId & 0b111111),
                encapCC.length,
            ]),
            encapCC,
        ]);
        return super.serialize();
    }
    computeEncapsulationOverhead() {
        // Supervision CC adds two bytes (control byte + cc length)
        return super.computeEncapsulationOverhead() + 2;
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                "session id": this.sessionId,
                "request updates": this.requestStatusUpdates,
            },
        };
    }
};
SupervisionCCGet = __decorate([
    CommandClass_1.CCCommand(SupervisionCommand.Get),
    CommandClass_1.expectedCCResponse(SupervisionCCReport, testResponseForSupervisionCCGet)
], SupervisionCCGet);
exports.SupervisionCCGet = SupervisionCCGet;

//# sourceMappingURL=SupervisionCC.js.map
