import { NodeUpdatePayload } from "@zwave-js/core";
import type { JSONObject } from "@zwave-js/shared";
import type { Driver } from "../driver/Driver";
import { Message, MessageDeserializationOptions } from "../message/Message";
import type { SuccessIndicator } from "../message/SuccessIndicator";
export declare enum ApplicationUpdateTypes {
    NodeInfo_Received = 132,
    NodeInfo_RequestDone = 130,
    NodeInfo_RequestFailed = 129,
    RoutingPending = 128,
    NewIdAssigned = 64,
    DeleteDone = 32,
    SUC_IdChanged = 16
}
export declare class ApplicationUpdateRequest extends Message {
    constructor(driver: Driver, options: MessageDeserializationOptions);
    private _updateType;
    get updateType(): ApplicationUpdateTypes;
}
export declare class ApplicationUpdateRequestNodeInfoReceived extends ApplicationUpdateRequest {
    constructor(driver: Driver, options: MessageDeserializationOptions);
    private _nodeId;
    get nodeId(): number;
    private _nodeInformation;
    get nodeInformation(): NodeUpdatePayload;
    toJSON(): JSONObject;
}
export declare class ApplicationUpdateRequestNodeInfoRequestFailed extends ApplicationUpdateRequest implements SuccessIndicator {
    isOK(): boolean;
}
