/** The priority of messages, sorted from high (0) to low (>0) */
export declare enum MessagePriority {
    Handshake = 0,
    PreTransmitHandshake = 1,
    Controller = 2,
    Ping = 3,
    MultistepController = 4,
    WakeUp = 5,
    Normal = 6,
    NodeQuery = 7,
    Poll = 8
}
export declare function isMessagePriority(val: unknown): val is MessagePriority;
/** Indicates the type of a data message */
export declare enum MessageType {
    Request = 0,
    Response = 1
}
/**
 * Complete list of function IDs for data messages.
 * IDs starting with FUNC_ID are straight from OZW and not implemented here yet.
 * IDs starting with UNKNOWN_FUNC are taken from openhab-zwave and not implemented here yet.
 * IDs starting with UNKNOWN_FUNC are also taken from https://github.com/yepher/RaZBerry/blob/master/README.md and not implemented yet
 * IDs ending with UNKNOWN_<hex-code> are reported by the stick but we don't know what they mean.
 */
export declare enum FunctionType {
    GetSerialApiInitData = 2,
    FUNC_ID_SERIAL_API_APPL_NODE_INFORMATION = 3,
    ApplicationCommand = 4,
    GetControllerCapabilities = 5,
    SetSerialApiTimeouts = 6,
    GetSerialApiCapabilities = 7,
    FUNC_ID_SERIAL_API_SOFT_RESET = 8,
    UNKNOWN_FUNC_UNKNOWN_0x09 = 9,
    UNKNOWN_FUNC_UNKNOWN_0x0a = 10,
    UNKNOWN_FUNC_SerialAPISetup = 11,
    UNKNOWN_FUNC_RF_RECEIVE_MODE = 16,
    UNKNOWN_FUNC_SET_SLEEP_MODE = 17,
    FUNC_ID_ZW_SEND_NODE_INFORMATION = 18,
    SendData = 19,
    SendDataMulticast = 20,
    GetControllerVersion = 21,
    SendDataAbort = 22,
    FUNC_ID_ZW_R_F_POWER_LEVEL_SET = 23,
    UNKNOWN_FUNC_SEND_DATA_META = 24,
    FUNC_ID_ZW_GET_RANDOM = 28,
    GetControllerId = 32,
    UNKNOWN_FUNC_MEMORY_GET_BYTE = 33,
    UNKNOWN_FUNC_MEMORY_PUT_BYTE = 34,
    UNKNOWN_FUNC_MEMORY_GET_BUFFER = 35,
    UNKNOWN_FUNC_MEMORY_PUT_BUFFER = 36,
    UNKNOWN_FUNC_FlashAutoProgSet = 39,
    UNKNOWN_FUNC_UNKNOWN_0x28 = 40,
    UNKNOWN_FUNC_NVMGetId = 41,
    UNKNOWN_FUNC_NVMExtReadLongBuffer = 42,
    UNKNOWN_FUNC_NVMExtWriteLongBuffer = 43,
    UNKNOWN_FUNC_NVMExtReadLongByte = 44,
    UNKNOWN_FUNC_NVMExtWriteLongByte = 45,
    UNKNOWN_FUNC_CLOCK_SET = 48,
    UNKNOWN_FUNC_CLOCK_GET = 49,
    UNKNOWN_FUNC_CLOCK_COMPARE = 50,
    UNKNOWN_FUNC_RTC_TIMER_CREATE = 51,
    UNKNOWN_FUNC_RTC_TIMER_READ = 52,
    UNKNOWN_FUNC_RTC_TIMER_DELETE = 53,
    UNKNOWN_FUNC_RTC_TIMER_CALL = 54,
    UNKNOWN_FUNC_ClearNetworkStats = 57,
    UNKNOWN_FUNC_GetNetworkStats = 58,
    UNKNOWN_FUNC_GetBackgroundRSSI = 59,
    UNKNOWN_FUNC_RemoveNodeIdFromNetwork = 63,
    FUNC_ID_ZW_SET_LEARN_NODE_STATE = 64,
    GetNodeProtocolInfo = 65,
    HardReset = 66,
    FUNC_ID_ZW_NEW_CONTROLLER = 67,
    FUNC_ID_ZW_REPLICATION_COMMAND_COMPLETE = 68,
    FUNC_ID_ZW_REPLICATION_SEND_DATA = 69,
    AssignReturnRoute = 70,
    DeleteReturnRoute = 71,
    RequestNodeNeighborUpdate = 72,
    ApplicationUpdateRequest = 73,
    AddNodeToNetwork = 74,
    RemoveNodeFromNetwork = 75,
    FUNC_ID_ZW_CREATE_NEW_PRIMARY = 76,
    FUNC_ID_ZW_CONTROLLER_CHANGE = 77,
    FUNC_ID_ZW_SET_LEARN_MODE = 80,
    FUNC_ID_ZW_ASSIGN_SUC_RETURN_ROUTE = 81,
    FUNC_ID_ZW_ENABLE_SUC = 82,
    FUNC_ID_ZW_REQUEST_NETWORK_UPDATE = 83,
    FUNC_ID_ZW_SET_SUC_NODE_ID = 84,
    FUNC_ID_ZW_DELETE_SUC_RETURN_ROUTE = 85,
    GetSUCNodeId = 86,
    UNKNOWN_FUNC_SEND_SUC_ID = 87,
    UNKNOWN_FUNC_AssignPrioritySUCReturnRoute = 88,
    UNKNOWN_FUNC_REDISCOVERY_NEEDED = 89,
    FUNC_ID_ZW_REQUEST_NODE_NEIGHBOR_UPDATE_OPTIONS = 90,
    FUNC_ID_ZW_EXPLORE_REQUEST_INCLUSION = 94,
    RequestNodeInfo = 96,
    RemoveFailedNode = 97,
    IsFailedNode = 98,
    ReplaceFailedNode = 99,
    UNKNOWN_FUNC_UNKNOWN_0x66 = 102,
    UNKNOWN_FUNC_UNKNOWN_0x67 = 103,
    UNKNOWN_FUNC_TIMER_START = 112,
    UNKNOWN_FUNC_TIMER_RESTART = 113,
    UNKNOWN_FUNC_TIMER_CANCEL = 114,
    UNKNOWN_FUNC_TIMER_CALL = 115,
    UNKNOWN_FUNC_UNKNOWN_0x78 = 120,
    GetRoutingInfo = 128,
    UNKNOWN_FUNC_GetTXCounter = 129,
    UNKNOWN_FUNC_ResetTXCounter = 130,
    UNKNOWN_FUNC_StoreNodeInfo = 131,
    UNKNOWN_FUNC_StoreHomeId = 132,
    UNKNOWN_FUNC_LOCK_ROUTE_RESPONSE = 144,
    UNKNOWN_FUNC_SEND_DATA_ROUTE_DEMO = 145,
    UNKNOWN_FUNC_GET_PRIORITY_ROUTE = 146,
    UNKNOWN_FUNC_SET_PRIORITY_ROUTE = 147,
    UNKNOWN_FUNC_SERIAL_API_TEST = 149,
    UNKNOWN_FUNC_UNKNOWN_0x98 = 152,
    FUNC_ID_SERIAL_API_SLAVE_NODE_INFO = 160,
    FUNC_ID_APPLICATION_SLAVE_COMMAND_HANDLER = 161,
    FUNC_ID_ZW_SEND_SLAVE_NODE_INFO = 162,
    FUNC_ID_ZW_SEND_SLAVE_DATA = 163,
    FUNC_ID_ZW_SET_SLAVE_LEARN_MODE = 164,
    FUNC_ID_ZW_GET_VIRTUAL_NODES = 165,
    FUNC_ID_ZW_IS_VIRTUAL_NODE = 166,
    BridgeApplicationCommand = 168,
    UNKNOWN_FUNC_UNKNOWN_0xB4 = 180,
    UNKNOWN_FUNC_WATCH_DOG_ENABLE = 182,
    UNKNOWN_FUNC_WATCH_DOG_DISABLE = 183,
    UNKNOWN_FUNC_WATCH_DOG_KICK = 184,
    UNKNOWN_FUNC_UNKNOWN_0xB9 = 185,
    UNKNOWN_FUNC_RF_POWERLEVEL_GET = 186,
    UNKNOWN_FUNC_GET_LIBRARY_TYPE = 189,
    UNKNOWN_FUNC_SEND_TEST_FRAME = 190,
    UNKNOWN_FUNC_GET_PROTOCOL_STATUS = 191,
    FUNC_ID_ZW_SET_PROMISCUOUS_MODE = 208,
    FUNC_ID_PROMISCUOUS_APPLICATION_COMMAND_HANDLER = 209,
    UNKNOWN_FUNC_UNKNOWN_0xD2 = 210,
    UNKNOWN_FUNC_UNKNOWN_0xD3 = 211,
    UNKNOWN_FUNC_UNKNOWN_0xD4 = 212,
    UNKNOWN_FUNC_UNKNOWN_0xEF = 239,
    UNKNOWN_FUNC_ZMEFreqChange = 242,
    UNKNOWN_FUNC_ZMERestore = 243,
    UNKNOWN_FUNC_ZMEBootloaderFlash = 244,
    UNKNOWN_FUNC_ZMECapabilities = 245,
    UNKNOWN_FUNC_ZMESerialAPIOptions = 248
}
