import type { MetadataUpdatedArgs, ValueAddedArgs, ValueID, ValueNotificationArgs, ValueRemovedArgs, ValueUpdatedArgs } from "@zwave-js/core";
import type { FirmwareUpdateStatus } from "../commandclass";
import type { NotificationCCReport } from "../commandclass/NotificationCC";
import type { ZWaveNode } from "./Node";
export interface TranslatedValueID extends ValueID {
    commandClassName: string;
    propertyName?: string;
    propertyKeyName?: string;
}
export declare type NodeInterviewFailedEventArgs = {
    errorMessage: string;
    isFinal: boolean;
} & ({
    attempt: number;
    maxAttempts: number;
} | {});
export declare type ZWaveNodeValueAddedArgs = ValueAddedArgs & TranslatedValueID;
export declare type ZWaveNodeValueUpdatedArgs = ValueUpdatedArgs & TranslatedValueID;
export declare type ZWaveNodeValueRemovedArgs = ValueRemovedArgs & TranslatedValueID;
export declare type ZWaveNodeValueNotificationArgs = ValueNotificationArgs & TranslatedValueID;
export declare type ZWaveNodeMetadataUpdatedArgs = MetadataUpdatedArgs & TranslatedValueID;
export declare type ZWaveNodeValueAddedCallback = (node: ZWaveNode, args: ZWaveNodeValueAddedArgs) => void;
export declare type ZWaveNodeValueUpdatedCallback = (node: ZWaveNode, args: ZWaveNodeValueUpdatedArgs) => void;
export declare type ZWaveNodeValueRemovedCallback = (node: ZWaveNode, args: ZWaveNodeValueRemovedArgs) => void;
export declare type ZWaveNodeValueNotificationCallback = (node: ZWaveNode, args: ZWaveNodeValueNotificationArgs) => void;
export declare type ZWaveNodeMetadataUpdatedCallback = (node: ZWaveNode, args: ZWaveNodeMetadataUpdatedArgs) => void;
export declare type ZWaveNotificationCallback = (node: ZWaveNode, notificationLabel: string, parameters?: NotificationCCReport["eventParameters"]) => void;
export declare type ZWaveInterviewFailedCallback = (node: ZWaveNode, args: NodeInterviewFailedEventArgs) => void;
export declare type ZWaveNodeFirmwareUpdateProgressCallback = (node: ZWaveNode, sentFragments: number, totalFragments: number) => void;
export declare type ZWaveNodeFirmwareUpdateFinishedCallback = (node: ZWaveNode, status: FirmwareUpdateStatus, waitTime?: number) => void;
export declare type ZWaveNodeStatusChangeCallback = (node: ZWaveNode, oldStatus: NodeStatus) => void;
export interface ZWaveNodeValueEventCallbacks {
    "value added": ZWaveNodeValueAddedCallback;
    "value updated": ZWaveNodeValueUpdatedCallback;
    "value removed": ZWaveNodeValueRemovedCallback;
    "metadata updated": ZWaveNodeMetadataUpdatedCallback;
    "value notification": ZWaveNodeValueNotificationCallback;
}
export interface ZWaveNodeEventCallbacks extends ZWaveNodeValueEventCallbacks {
    notification: ZWaveNotificationCallback;
    "interview failed": ZWaveInterviewFailedCallback;
    "firmware update progress": ZWaveNodeFirmwareUpdateProgressCallback;
    "firmware update finished": ZWaveNodeFirmwareUpdateFinishedCallback;
    "wake up": ZWaveNodeStatusChangeCallback;
    sleep: ZWaveNodeStatusChangeCallback;
    dead: ZWaveNodeStatusChangeCallback;
    alive: ZWaveNodeStatusChangeCallback;
    "interview completed": (node: ZWaveNode) => void;
    ready: (node: ZWaveNode) => void;
}
export declare type ZWaveNodeEvents = Extract<keyof ZWaveNodeEventCallbacks, string>;
export declare enum InterviewStage {
    /** The interview process hasn't started for this node */
    None = 0,
    /** The node's protocol information has been queried from the controller */
    ProtocolInfo = 1,
    /** The node has been queried for supported and controlled command classes */
    NodeInfo = 2,
    /**
     * This marks the beginning of re-interviews on application startup.
     * RestartFromCache and later stages will be serialized as "Complete" in the cache
     */
    RestartFromCache = 3,
    /**
     * Information for all command classes has been queried.
     * This includes static information that is requested once as well as dynamic
     * information that is requested on every restart.
     */
    CommandClasses = 4,
    /**
     * Device information for the node has been loaded from a config file.
     * If defined, some of the reported information will be overwritten based on the
     * config file contents.
     */
    OverwriteConfig = 5,
    /** The node has been queried for its current neighbor list */
    Neighbors = 6,
    /** The interview process has finished */
    Complete = 7
}
export declare enum NodeStatus {
    Unknown = 0,
    Asleep = 1,
    Awake = 2,
    Dead = 3,
    Alive = 4
}
