"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.assertCC = void 0;
const objects_1 = require("alcalzone-shared/objects");
const SendDataMessages_1 = require("../controller/SendDataMessages");
/** Performs assertions on a sendMessage call argument that's supposed to be a CC */
function assertCC(callArg, options) {
    const request = callArg;
    expect(request).toBeInstanceOf(SendDataMessages_1.SendDataRequest);
    if (options.nodeId)
        expect(request.getNodeId()).toBe(options.nodeId);
    const command = request.command;
    expect(command).toBeInstanceOf(options.cc);
    if (options.ccValues) {
        for (const [prop, val] of objects_1.entries(options.ccValues)) {
            expect(command[prop]).toBe(val);
        }
    }
}
exports.assertCC = assertCC;

//# sourceMappingURL=assertCC.js.map
