#!/usr/bin/env node
"use strict";

var _zwaveJs = require("zwave-js");

var _qth = _interopRequireDefault(require("qth"));

var _argparse = require("argparse");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _createForOfIteratorHelper(o, allowArrayLike) { var it; if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e2) { throw _e2; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = o[Symbol.iterator](); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e3) { didErr = true; err = _e3; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var QthValueBridge = /*#__PURE__*/function () {
  function QthValueBridge(qth, qthPrefix, node, valueId) {
    var _this = this;

    _classCallCheck(this, QthValueBridge);

    this.onSetValue = this.onSetValue.bind(this);
    this.qth = qth;
    this.node = node;
    this.valueId = valueId;
    this.metadata = this.node.getValueMetadata(this.valueId);
    var normalisedName = this.metadata.label.replaceAll(/[^A-Za-z0-9()]+/g, '-');
    this.valuePath = "".concat(qthPrefix, "values/").concat(normalisedName); // The value itself

    this.qth.register(this.valuePath, this.metadata.readable ? "PROPERTY-1:N" : "EVENT-N:1", "Zwave '".concat(this.metadata.label, "' value. ") + "Command class ".concat(this.valueId.commandClass, " (").concat(this.valueId.commandClassName, "), ") + "endpoint ".concat(this.valueId.endpoint, ", ") + "property ".concat(this.valueId.property, " (").concat(this.valueId.propertyName, "), ") + "property key ".concat(this.valueId.propertyKey, " (").concat(this.valueId.propertyKeyName, "). ") + "Metadata: ".concat(JSON.stringify(this.metadata)), this.metadata.readable ? {
      "delete_on_unregister": true
    } : {});

    if (this.metadata.readable) {
      var curValue = this.node.getValue(this.valueId);
      this.expectedValues = [curValue];
      this.qth.setProperty(this.valuePath, curValue);
      this.node.setMaxListeners(0);
      this.node.on("value updated", function (_node, _ref) {
        var commandClass = _ref.commandClass,
            endpoint = _ref.endpoint,
            property = _ref.property,
            propertyKey = _ref.propertyKey,
            newValue = _ref.newValue;

        if (commandClass === _this.valueId.commandClass && endpoint === _this.valueId.endpoint && property === _this.valueId.property && propertyKey === _this.valueId.propertyKey) {
          _this.expectedValues.push(newValue);

          _this.qth.setProperty(_this.valuePath, newValue);
        }
      });
    }

    if (this.metadata.writeable) {
      if (this.metadata.readable) {
        this.qth.watchProperty(this.valuePath, this.onSetValue);
      } else {
        this.qth.watchEvent(this.valuePath, this.onSetValue);
      }
    } // Metadata


    this.qth.register("".concat(this.valuePath, "/metadata"), "PROPERTY-1:N", "Information describing the value", {
      "delete_on_unregister": true
    });
    this.qth.setProperty("".concat(this.valuePath, "/metadata"), this.metadata);
  }

  _createClass(QthValueBridge, [{
    key: "onSetValue",
    value: function onSetValue(_topic, value) {
      var i = this.expectedValues.indexOf(value);

      if (i < 0) {
        if (value !== undefined) {
          this.node.setValue(this.valueId, value);
        }
      } else {
        // Ignore expected value arriving
        this.expectedValues.splice(i, 1);
      }
    }
  }, {
    key: "remove",
    value: function remove() {
      this.qth.unregister(this.valuePath);

      if (this.metadata.writeable) {
        if (this.metadata.readable) {
          this.qth.unwatchProperty(this.valuePath, this.onSetValue);
        } else {
          this.qth.unwatchEvent(this.valuePath, this.onSetValue);
        }
      }

      this.qth.unregister("".concat(this.valuePath, "/metadata"));
    }
  }]);

  return QthValueBridge;
}();

var QthNodeBridge = /*#__PURE__*/function () {
  function QthNodeBridge(qth, qthPrefix, controller, node) {
    var _this2 = this;

    _classCallCheck(this, QthNodeBridge);

    this.qth = qth;
    this.controller = controller, this.node = node;
    this.nodePrefix = "".concat(qthPrefix, "nodes/").concat(this.node.id, "/");
    this.values = [];
    this.node.on("ready", function () {
      _this2.qth.register("".concat(_this2.nodePrefix, "manufacturer_name"), "PROPERTY-1:N", "Device manufacturer's name", {
        "delete_on_unregister": true
      });

      _this2.qth.setProperty("".concat(_this2.nodePrefix, "manufacturer_name"), node.deviceConfig.manufacturer);

      _this2.qth.register("".concat(_this2.nodePrefix, "description"), "PROPERTY-1:N", "Device description", {
        "delete_on_unregister": true
      });

      _this2.qth.setProperty("".concat(_this2.nodePrefix, "description"), node.deviceConfig.description);

      _this2.qth.register("".concat(_this2.nodePrefix, "neighbors"), "PROPERTY-1:N", "Neighbouring node IDs", {
        "delete_on_unregister": true
      });

      _this2.qth.setProperty("".concat(_this2.nodePrefix, "neighbors"), node.neighbors); // Refresh


      _this2.qth.register("".concat(_this2.nodePrefix, "refresh_values"), "EVENT-N:1", "Trigger a poll of all this node's values", {
        "delete_on_unregister": true
      });

      _this2.onRefreshValues = _this2.onRefreshValues.bind(_this2);

      _this2.qth.watchEvent("".concat(_this2.nodePrefix, "refresh_values"), _this2.onRefreshValues); // Remove failed node


      _this2.qth.register("".concat(_this2.nodePrefix, "remove_failed_node"), "EVENT-N:1", "Send the string 'remove' to forcibly remove this node from the controller.", {
        "delete_on_unregister": true
      });

      _this2.onRemoveFailedNode = _this2.onRemoveFailedNode.bind(_this2);

      _this2.qth.watchEvent("".concat(_this2.nodePrefix, "remove_failed_node"), _this2.onRemoveFailedNode); // Values


      var _iterator = _createForOfIteratorHelper(_this2.node.getDefinedValueIDs()),
          _step;

      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var valueId = _step.value;

          _this2.values.push(new QthValueBridge(_this2.qth, _this2.nodePrefix, _this2.node, valueId));
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }
    });
  }

  _createClass(QthNodeBridge, [{
    key: "onRefreshValues",
    value: function onRefreshValues() {
      this.node.refreshValues();
    }
  }, {
    key: "onRemoveFailedNode",
    value: function onRemoveFailedNode(_topic, value) {
      if (value === "remove") {
        this.controller.removeFailedNode(this.node.id);
      }
    }
  }, {
    key: "remove",
    value: function remove() {
      this.qth.unregister("".concat(this.nodePrefix, "manufacturer_name"));
      this.qth.unregister("".concat(this.nodePrefix, "description"));
      this.qth.unregister("".concat(this.nodePrefix, "neighbors"));
      this.qth.unregister("".concat(this.nodePrefix, "refresh_values"));
      this.qth.unregister("".concat(this.nodePrefix, "remove_failed_node"));
      this.qth.unwatchEvent("".concat(this.nodePrefix, "refresh_values"), this.onRefreshValues);
      this.qth.unwatchEvent("".concat(this.nodePrefix, "remove_failed_node"), this.onRemoveFailedNode);

      var _iterator2 = _createForOfIteratorHelper(this.values),
          _step2;

      try {
        for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
          var value = _step2.value;
          value.remove();
        }
      } catch (err) {
        _iterator2.e(err);
      } finally {
        _iterator2.f();
      }
    }
  }]);

  return QthNodeBridge;
}();

var QthZwaveBridge = function QthZwaveBridge(qthHostWs, qthPrefix, zwaveDriver) {
  var _this3 = this;

  _classCallCheck(this, QthZwaveBridge);

  this.qth = new _qth["default"](qthHostWs, {
    "clientId": "qth_zwave_js",
    "description": "A Qth/ZWave bridge"
  });
  this.qthPrefix = qthPrefix;
  this.driver = zwaveDriver;
  this.nodes = new Map(); // Status monitoring

  this.qth.register("".concat(this.qthPrefix, "state"), "PROPERTY-1:N", "Human-readable state of the ZWave network interface.", {
    "delete_on_unregister": true
  });

  var setState = function setState(state) {
    _this3.qth.setProperty("".concat(_this3.qthPrefix, "state"), state);
  };

  setState("starting");
  this.driver.on("error", function (e) {
    return setState("error: ".concat(e));
  });
  this.driver.on("driver ready", function () {
    return setState("driver ready");
  });
  this.driver.on("all nodes ready", function () {
    return setState("all nodes ready");
  }); // Healing

  this.driver.on("driver ready", function () {
    _this3.qth.register("".concat(_this3.qthPrefix, "heal_network"), "EVENT-N:1", "Send a non-false value to start healing, send false top stop it.");

    _this3.qth.register("".concat(_this3.qthPrefix, "heal_network/progress"), "PROPERTY-1:N", "An object giving the healing status of each node (or null if not healing)", {
      "delete_on_unregister": true
    });

    var setHealProgress = function setHealProgress(progress) {
      _this3.qth.setProperty("".concat(_this3.qthPrefix, "heal_network/progress"), progress);
    };

    setHealProgress(null);

    _this3.qth.watchEvent("".concat(_this3.qthPrefix, "heal_network"), function (_topic, command) {
      if (command !== false) {
        _this3.driver.controller.beginHealingNetwork();

        setHealProgress({});
      } else {
        _this3.driver.controller.stopHealingNetwork();

        setHealProgress(null);
      }
    });

    _this3.driver.controller.on("heal network progress", function (progress) {
      setHealProgress(Object.fromEntries(progress));
    });

    _this3.driver.controller.on("heal network done", function () {
      setHealProgress(null);
    });
  }); // Inclusion/Exclusion

  this.driver.on("driver ready", function () {
    var _loop = function _loop() {
      var kind = _arr[_i];

      _this3.qth.register("".concat(_this3.qthPrefix).concat(kind, "_mode"), "PROPERTY-N:1", "Set to true to begin ${kind} and false to stop ${kind}.", {
        "delete_on_unregister": true
      });

      _this3.qth.register("".concat(_this3.qthPrefix).concat(kind, "_mode/result"), "PROPERTY-1:N", "Stores the state of the last ${kind} operation.", {
        "delete_on_unregister": true
      });

      _this3.qth.setProperty("".concat(_this3.qthPrefix).concat(kind, "_mode"), false);

      _this3.qth.watchProperty("".concat(_this3.qthPrefix).concat(kind, "_mode"), function (_topic, state) {
        var tkind = kind.replace(kind[0], kind[0].toUpperCase());

        if (state === true) {
          _this3.driver.controller["begin".concat(tkind)]();
        } else {
          _this3.driver.controller["stop".concat(tkind)]();
        }
      });

      _this3.driver.controller.on("".concat(kind, " started"), function () {
        _this3.qth.setProperty("".concat(_this3.qthPrefix).concat(kind, "_mode/result"), "in progress");
      });

      _this3.driver.controller.on("".concat(kind, " failed"), function () {
        _this3.qth.setProperty("".concat(_this3.qthPrefix).concat(kind, "_mode/result"), "failed");
      });

      _this3.driver.controller.on("".concat(kind, " stopped"), function () {
        _this3.qth.setProperty("".concat(_this3.qthPrefix).concat(kind, "_mode/result"), "success or manually stopped");
      });
    };

    for (var _i = 0, _arr = ["inclusion", "exclusion"]; _i < _arr.length; _i++) {
      _loop();
    }
  }); // Nodes

  this.driver.on("driver ready", function () {
    var _iterator3 = _createForOfIteratorHelper(_this3.driver.controller.nodes.entries()),
        _step3;

    try {
      for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
        var _step3$value = _slicedToArray(_step3.value, 2),
            id = _step3$value[0],
            node = _step3$value[1];

        _this3.nodes.set(id, new QthNodeBridge(_this3.qth, _this3.qthPrefix, _this3.driver.controller, node));
      }
    } catch (err) {
      _iterator3.e(err);
    } finally {
      _iterator3.f();
    }

    _this3.driver.controller.on("node added", function (node) {
      if (_this3.nodes.has(node.id)) {
        _this3.nodes.get(node.id).remove();
      }

      _this3.nodes.set(node.id, new QthNodeBridge(_this3.qth, _this3.qthPrefix, _this3.driver.controller, node));
    });

    _this3.driver.controller.on("node removed", function (node) {
      if (_this3.nodes.has(node.id)) {
        _this3.nodes.get(node.id).remove();

        _this3.nodes["delete"](node.id);
      }
    });
  });
};

function main() {
  return _main.apply(this, arguments);
}

function _main() {
  _main = _asyncToGenerator(function* () {
    var parser = new _argparse.ArgumentParser();
    parser.add_argument("--qth-host-uri", "-H", {
      help: "Qth server URI, e.g. tcp://hostname:port or wss://example.com/qth/ws",
      type: String,
      "default": "tcp://localhost:1883"
    });
    parser.add_argument("--qth-prefix", "-p", {
      help: "Qth path prefix for zwave properties.",
      type: String,
      "default": "sys/zwave/"
    });
    parser.add_argument("--serial-port", "-s", {
      help: "Serial port for zwave controller.",
      type: String,
      "default": "/dev/ttyACM0"
    });
    parser.add_argument("--cache-dir", "-c", {
      help: "ZWave.js cache directory",
      "default": "./qth_zwave_js_cache/"
    });
    parser.add_argument("--verbose", "-v", {
      help: "Increase logging verbosity. May be used multiple times.",
      action: "count",
      "default": 0
    });
    var args = parser.parse_args();
    var driver = new _zwaveJs.Driver(args.serial_port, {
      logConfig: {
        level: args.verbose
      },
      storage: {
        cacheDir: args.cache_dir
      }
    });
    var qth = new QthZwaveBridge(args.qth_host_uri, args.qth_prefix, driver);
    driver.start();
  });
  return _main.apply(this, arguments);
}

main();