import { JSONObject, ReadonlyObjectKeyMap } from "@zwave-js/shared";
import { CompatConfig } from "./CompatConfig";
export interface FirmwareVersionRange {
    min: string;
    max: string;
}
export interface DeviceID {
    manufacturerId: number;
    productType: number;
    productId: number;
    firmwareVersion?: string;
}
export interface DeviceConfigIndexEntry {
    manufacturerId: string;
    productType: string;
    productId: string;
    firmwareVersion: FirmwareVersionRange;
    filename: string;
}
export interface FulltextDeviceConfigIndexEntry {
    manufacturerId: string;
    manufacturer: string;
    label: string;
    description: string;
    productType: string;
    productId: string;
    firmwareVersion: FirmwareVersionRange;
    filename: string;
}
export declare type ParamInfoMap = ReadonlyObjectKeyMap<{
    parameter: number;
    valueBitMask?: number;
}, ParamInformation>;
export declare const devicesDir: string;
export declare const indexPath: string;
export declare const fulltextIndexPath: string;
export declare type DeviceConfigIndex = DeviceConfigIndexEntry[];
export declare type FulltextDeviceConfigIndex = FulltextDeviceConfigIndexEntry[];
export declare class DeviceConfig {
    static from(filename: string, options?: {
        relativeTo?: string;
        deviceId?: DeviceID;
    }): Promise<DeviceConfig>;
    readonly filename: string;
    constructor(filename: string, definition: any, deviceId?: DeviceID);
    readonly manufacturer: string;
    readonly manufacturerId: number;
    readonly label: string;
    readonly description: string;
    readonly devices: readonly {
        productType: string;
        productId: string;
    }[];
    readonly firmwareVersion: FirmwareVersionRange;
    readonly associations?: ReadonlyMap<number, AssociationConfig>;
    readonly paramInformation?: ParamInfoMap;
    /**
     * Contains manufacturer-specific support information for the
     * ManufacturerProprietary CC
     */
    readonly proprietary?: Record<string, unknown>;
    /** Contains compatibility options */
    readonly compat?: CompatConfig;
    /** Contains instructions and other metadata for the device */
    readonly metadata?: DeviceMetadata;
}
export declare class AssociationConfig {
    constructor(filename: string, groupId: number, definition: JSONObject);
    readonly groupId: number;
    readonly label: string;
    readonly description?: string;
    readonly maxNodes: number;
    /**
     * Whether this association group is used to report updates to the controller.
     * While Z-Wave+ defines a single lifeline, older devices may have multiple lifeline associations.
     */
    readonly isLifeline: boolean;
    /** Some devices support multi channel associations but require some of its groups to use node id associations */
    readonly noEndpoint: boolean;
}
export declare class ParamInformation {
    constructor(parent: DeviceConfig, parameterNumber: number, valueBitMask: number | undefined, definition: JSONObject, deviceId?: DeviceID);
    readonly parameterNumber: number;
    readonly valueBitMask?: number;
    readonly label: string;
    readonly description?: string;
    readonly valueSize: number;
    readonly minValue: number;
    readonly maxValue: number;
    readonly unsigned?: boolean;
    readonly defaultValue: number;
    readonly unit?: string;
    readonly readOnly: boolean;
    readonly writeOnly: boolean;
    readonly allowManualEntry: boolean;
    readonly options: readonly ConfigOption[];
}
export interface ConfigOption {
    value: number;
    label: string;
}
export declare class DeviceMetadata {
    constructor(filename: string, definition: JSONObject);
    /** Inclusion instructions */
    readonly inclusion?: string;
    /** Exclusion instructions */
    readonly exclusion?: string;
    /** Instructions for resetting the device to factory defaults */
    readonly reset?: string;
    /** A link to the device manual */
    readonly manual?: string;
}
//# sourceMappingURL=Devices.d.ts.map