/// <reference types="node" />
import { CommandClasses } from "./CommandClasses";
export interface NodeInformationFrame {
    generic: number;
    specific: number;
    supportedCCs: CommandClasses[];
}
interface ExtendedNodeInformationFrame extends NodeInformationFrame {
    controlledCCs: CommandClasses[];
}
export interface NodeUpdatePayload extends ExtendedNodeInformationFrame {
    nodeId: number;
    basic: number;
}
export declare function parseNodeUpdatePayload(nif: Buffer): NodeUpdatePayload;
/**
 * Reads a CC id from the given buffer, returning the parsed CC id and the number of bytes read
 * @param offset The offset at which the CC id is located
 */
export declare function parseCCId(payload: Buffer, offset?: number): {
    ccId: CommandClasses;
    bytesRead: number;
};
export declare function parseCCList(payload: Buffer): {
    supportedCCs: CommandClasses[];
    controlledCCs: CommandClasses[];
};
export declare function parseNodeInformationFrame(nif: Buffer): NodeInformationFrame;
export {};
//# sourceMappingURL=NodeInfo.d.ts.map