/**
 * Used to identify errors from this library without relying on the error message
 */
export declare enum ZWaveErrorCodes {
    PacketFormat_Truncated = 0,
    PacketFormat_Invalid = 1,
    PacketFormat_Checksum = 2,
    PacketFormat_InvalidPayload = 3,
    PacketFormat_DecryptionFailed = 4,
    /** The driver failed to start */
    Driver_Failed = 5,
    Driver_Reset = 6,
    Driver_Destroyed = 7,
    Driver_NotReady = 8,
    Driver_InvalidDataReceived = 9,
    Driver_NotSupported = 10,
    Driver_NoPriority = 11,
    Driver_InvalidCache = 12,
    Driver_InvalidOptions = 13,
    /** The driver tried to do something that requires security */
    Driver_NoSecurity = 14,
    Driver_NoErrorHandler = 15,
    /** The controller has timed out while waiting for a report from the node */
    Controller_Timeout = 16,
    Controller_NodeTimeout = 17,
    Controller_MessageDropped = 18,
    Controller_ResponseNOK = 19,
    Controller_CallbackNOK = 20,
    Controller_InclusionFailed = 21,
    Controller_ExclusionFailed = 22,
    /** The node with the given node ID was not found */
    Controller_NodeNotFound = 23,
    /** The endpoint with the given index was not found on the node */
    Controller_EndpointNotFound = 24,
    /** The node was removed from the network */
    Controller_NodeRemoved = 25,
    /** Communication with the node will be insecure (no security configured) */
    Controller_NodeInsecureCommunication = 26,
    /** The message has expired (the given timeout has elapsed) */
    Controller_MessageExpired = 27,
    CC_Invalid = 28,
    CC_NoNodeID = 29,
    CC_NotSupported = 30,
    CC_NotImplemented = 31,
    CC_NoAPI = 32,
    Deserialization_NotImplemented = 33,
    Arithmetic = 34,
    Argument_Invalid = 35,
    Config_Invalid = 36,
    Config_NotFound = 37,
    /** A compound config file has circular imports */
    Config_CircularImport = 38,
    /** The removal process could not be started or completed due to one or several reasons */
    RemoveFailedNode_Failed = 39,
    /** The removal process was aborted because the node has responded */
    RemoveFailedNode_NodeOK = 40,
    /** The replace process could not be started or completed due to one or several reasons */
    ReplaceFailedNode_Failed = 41,
    /** The replace process was aborted because the node has responded */
    ReplaceFailedNode_NodeOK = 42,
    /**
     * Used to report the first existing parameter number
     * available in a node's configuration
     */
    ConfigurationCC_FirstParameterNumber = 1000,
    /**
     * Used to report that a V3+ node should not have its parameters scanned with get/set commands
     */
    ConfigurationCC_NoLegacyScanOnNewDevices = 1001,
    /**
     * Used to report that a node using V3 or less MUST not use the resetToDefault flag
     */
    ConfigurationCC_NoResetToDefaultOnLegacyDevices = 1002,
    /**
     * Used to report that the command was not executed by the target node
     */
    SupervisionCC_CommandFailed = 1100,
    /**
     * Used to report that a ManufacturerProprietaryCC could not be instanciated
     * because of a missing manufacturer ID.
     */
    ManufacturerProprietaryCC_NoManufacturerId = 1200,
    /**
     * Used to report that an invalid group ID was used to address a (Multi Channel) Association
     */
    AssociationCC_InvalidGroup = 1300,
    /** Cannot add an association because it is not allowed */
    AssociationCC_NotAllowed = 1301,
    /** Used to report that no nonce exists */
    SecurityCC_NoNonce = 1400,
    /** The firmware update process is already active */
    FirmwareUpdateCC_Busy = 1500,
    /** The selected firmware target is not upgradable */
    FirmwareUpdateCC_NotUpgradable = 1501,
    /** The selected firmware target does not exist */
    FirmwareUpdateCC_TargetNotFound = 1502,
    /** The node reported that it could not start the update */
    FirmwareUpdateCC_FailedToStart = 1503,
    /** The node did not confirm the aborted update */
    FirmwareUpdateCC_FailedToAbort = 1504,
    /** The node did not confirm the completed update or the process stalled for too long */
    FirmwareUpdateCC_Timeout = 1505,
    /** An invalid firmware file was provided that cannot be handled by this library */
    Invalid_Firmware_File = 1506,
    /** An firmware file with an unsupported format was provided */
    Unsupported_Firmware_Format = 1507
}
/**
 * Errors thrown in this library are of this type. The `code` property identifies what went wrong.
 */
export declare class ZWaveError extends Error {
    readonly message: string;
    readonly code: ZWaveErrorCodes;
    /** Additional info required to handle this error (e.g. the Z-Wave message indicating the failure) */
    readonly context?: unknown;
    /** If this error corresponds to a failed transaction, this contains the stack where it was created */
    readonly transactionSource?: string | undefined;
    constructor(message: string, code: ZWaveErrorCodes, 
    /** Additional info required to handle this error (e.g. the Z-Wave message indicating the failure) */
    context?: unknown, 
    /** If this error corresponds to a failed transaction, this contains the stack where it was created */
    transactionSource?: string | undefined);
}
export declare function isTransmissionError(e: unknown): e is ZWaveError & {
    code: ZWaveErrorCodes.Controller_MessageDropped | ZWaveErrorCodes.Controller_CallbackNOK | ZWaveErrorCodes.Controller_ResponseNOK | ZWaveErrorCodes.Controller_NodeTimeout;
};
//# sourceMappingURL=ZWaveError.d.ts.map