/// <reference types="node" />
import { DataDirection, ZWaveLogContainer, ZWaveLoggerBase } from "@zwave-js/core";
export declare const SERIAL_LABEL = "SERIAL";
export declare class SerialLogger extends ZWaveLoggerBase {
    constructor(loggers: ZWaveLogContainer);
    private _isVisible;
    private isVisible;
    /**
     * Logs transmission or receipt of an ACK frame
     * @param direction The direction this ACK was sent
     */
    ACK(direction: DataDirection): void;
    /**
     * Logs transmission or receipt of an NAK frame
     * @param direction The direction this NAK was sent
     */
    NAK(direction: DataDirection): void;
    /**
     * Logs transmission or receipt of an CAN frame
     * @param direction The direction this CAN was sent
     */
    CAN(direction: DataDirection): void;
    private logMessageHeader;
    /**
     * Logs transmission or receipt of a data chunk
     * @param direction The direction the data was sent
     * @param data The data that was transmitted or received
     */
    data(direction: DataDirection, data: Buffer): void;
    /**
     * Logs a message
     * @param msg The message to output
     */
    message(message: string): void;
}
//# sourceMappingURL=Logger.d.ts.map