"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SerialLogger = exports.SERIAL_LABEL = void 0;
const Sentry = __importStar(require("@sentry/node"));
const core_1 = require("@zwave-js/core");
const shared_1 = require("@zwave-js/shared");
const MessageHeaders_1 = require("./MessageHeaders");
exports.SERIAL_LABEL = "SERIAL";
const SERIAL_LOGLEVEL = "debug";
class SerialLogger extends core_1.ZWaveLoggerBase {
    constructor(loggers) {
        super(loggers, exports.SERIAL_LABEL);
    }
    isVisible() {
        if (this._isVisible === undefined) {
            this._isVisible = this.container.isLoglevelVisible(SERIAL_LOGLEVEL);
        }
        return this._isVisible;
    }
    /**
     * Logs transmission or receipt of an ACK frame
     * @param direction The direction this ACK was sent
     */
    ACK(direction) {
        if (this.isVisible())
            this.logMessageHeader(direction, MessageHeaders_1.MessageHeaders.ACK);
    }
    /**
     * Logs transmission or receipt of an NAK frame
     * @param direction The direction this NAK was sent
     */
    NAK(direction) {
        if (this.isVisible())
            this.logMessageHeader(direction, MessageHeaders_1.MessageHeaders.NAK);
    }
    /**
     * Logs transmission or receipt of an CAN frame
     * @param direction The direction this CAN was sent
     */
    CAN(direction) {
        if (this.isVisible())
            this.logMessageHeader(direction, MessageHeaders_1.MessageHeaders.CAN);
    }
    logMessageHeader(direction, header) {
        this.logger.log({
            level: SERIAL_LOGLEVEL,
            primaryTags: `[${MessageHeaders_1.MessageHeaders[header]}]`,
            message: "",
            secondaryTags: `(${shared_1.num2hex(header)})`,
            direction: core_1.getDirectionPrefix(direction),
        });
    }
    /**
     * Logs transmission or receipt of a data chunk
     * @param direction The direction the data was sent
     * @param data The data that was transmitted or received
     */
    data(direction, data) {
        if (this.isVisible()) {
            this.logger.log({
                level: SERIAL_LOGLEVEL,
                message: `0x${data.toString("hex")}`,
                secondaryTags: `(${data.length} bytes)`,
                direction: core_1.getDirectionPrefix(direction),
            });
        }
        if (process.env.NODE_ENV !== "test") {
            // Enrich error data in case something goes wrong
            Sentry.addBreadcrumb({
                category: "serial",
                timestamp: Date.now() / 1000,
                type: "debug",
                message: `${core_1.getDirectionPrefix(direction)}${shared_1.buffer2hex(data)}`,
            });
        }
    }
    // /**
    //  * Logs the current content of the receive buffer
    //  * @param data The data that is currently in the receive buffer
    //  */
    // export function receiveBuffer(data: Buffer, isComplete: boolean): void {
    // 	if (isVisible()) {
    // 		getLogger().log({
    // 			level: isComplete ? SERIAL_LOGLEVEL : "silly",
    // 			primaryTags: isComplete ? undefined : "[incomplete]",
    // 			message: `Buffer := 0x${data.toString("hex")}`,
    // 			secondaryTags: `(${data.length} bytes)`,
    // 			direction: getDirectionPrefix("none"),
    // 		});
    // 	}
    // }
    /**
     * Logs a message
     * @param msg The message to output
     */
    message(message) {
        if (this.isVisible()) {
            this.logger.log({
                level: SERIAL_LOGLEVEL,
                message,
                direction: core_1.getDirectionPrefix("none"),
            });
        }
    }
}
exports.SerialLogger = SerialLogger;
//# sourceMappingURL=Logger.js.map