"use strict";
// wotan-disable no-restricted-property-access
// wotan-disable prefer-dot-notation
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MockSerialPort = void 0;
const shared_1 = require("@zwave-js/shared");
const events_1 = require("events");
const stream_1 = require("stream");
const ZWaveSerialPort_1 = require("./ZWaveSerialPort");
const instances = new Map();
let MockBinding = class MockBinding extends stream_1.PassThrough {
};
MockBinding = __decorate([
    shared_1.Mixin([events_1.EventEmitter])
], MockBinding);
class MockSerialPort extends ZWaveSerialPort_1.ZWaveSerialPort {
    constructor(port, loggers) {
        super(port, loggers, MockBinding);
        this.__isOpen = false;
        this.openStub = jest.fn(() => Promise.resolve());
        this.closeStub = jest.fn(() => Promise.resolve());
        this.writeStub = jest.fn();
        instances.set(port, this);
    }
    static getInstance(port) {
        return instances.get(port);
    }
    get isOpen() {
        return this.__isOpen;
    }
    open() {
        return this.openStub().then(() => {
            this.__isOpen = true;
        });
    }
    close() {
        return this.closeStub().then(() => {
            this.__isOpen = false;
        });
    }
    receiveData(data) {
        this.serial.push(data);
    }
    raiseError(err) {
        this.emit("error", err);
    }
    writeAsync(data) {
        this._lastWrite = data;
        this.emit("write", data);
        return this.writeStub(data);
    }
    get lastWrite() {
        return this._lastWrite;
    }
}
exports.MockSerialPort = MockSerialPort;
//# sourceMappingURL=MockSerialPort.js.map